/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.jvm;

import com.sshtools.server.vsession.CliHelper;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Mem
extends ShellCommand {
    public Mem() {
        super("mem", "JVM", "mem", "Displays JVM memory information");
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException {
        HashMap<String, Long> memory = new HashMap<String, Long>();
        long free = Runtime.getRuntime().freeMemory();
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long used = Runtime.getRuntime().totalMemory();
        memory.put("free", free);
        memory.put("max", max);
        memory.put("total", total);
        memory.put("used", used);
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        argList.remove(0);
        boolean filtered = argList.contains("free") || argList.contains("max") || argList.contains("total") || argList.contains("used");
        for (String name : memory.keySet()) {
            if (filtered && !argList.contains(name)) continue;
            console.println(name + "=" + Mem.format(args, (Long)memory.get(name)));
        }
    }

    static String format(String[] args, long value) {
        if (CliHelper.hasShortOption(args, 'm')) {
            return value / 1024L / 1024L + " MB";
        }
        if (CliHelper.hasShortOption(args, 'k')) {
            return value / 1024L + " KB";
        }
        return value + " Bytes";
    }
}

