/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.common.ssh.Channel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.spi.Pty;
import org.jline.utils.ClosedException;
import org.jline.utils.Log;
import org.jline.utils.NonBlocking;
import org.jline.utils.NonBlockingInputStream;
import org.jline.utils.NonBlockingReader;

public class PosixChannelPtyTerminal
extends AbstractPosixTerminal {
    private final Channel out;
    private final InputStream masterInput;
    private final OutputStream masterOutput;
    private final NonBlockingInputStream input;
    private final OutputStream output;
    private final NonBlockingReader reader;
    private final PrintWriter writer;
    private final Object lock = new Object();
    private Thread outputPumpThread;
    private boolean paused = true;
    private ByteArrayOutputStream pauseBuffer = new ByteArrayOutputStream();
    Size size;

    public PosixChannelPtyTerminal(String name, String type, Pty pty, int cols, int rows, Channel out, Charset encoding) throws IOException {
        this(name, type, pty, cols, rows, out, encoding, Terminal.SignalHandler.SIG_DFL);
    }

    public PosixChannelPtyTerminal(String name, String type, Pty pty, int cols, int rows, Channel out, Charset encoding, Terminal.SignalHandler signalHandler) throws IOException {
        this(name, type, pty, cols, rows, out, encoding, signalHandler, false);
    }

    public PosixChannelPtyTerminal(String name, String type, Pty pty, int cols, int rows, Channel out, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused) throws IOException {
        super(name, type, pty, encoding, signalHandler);
        this.out = Objects.requireNonNull(out);
        this.masterInput = pty.getMasterInput();
        this.masterOutput = pty.getMasterOutput();
        this.input = new InputStreamWrapper(NonBlocking.nonBlocking((String)name, (InputStream)pty.getSlaveInput()));
        this.output = pty.getSlaveOutput();
        this.reader = NonBlocking.nonBlocking((String)name, (InputStream)this.input, (Charset)this.encoding());
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, this.encoding()));
        this.size = new Size(cols, rows);
        this.parseInfoCmp();
        if (!paused) {
            this.resume();
        }
    }

    public Size getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void in(byte[] buf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.paused) {
                this.pauseBuffer.write(buf, off, len);
                return;
            }
        }
        this.masterOutput.write(buf, off, len);
        this.masterOutput.flush();
    }

    public InputStream input() {
        return this.input;
    }

    public NonBlockingReader reader() {
        return this.reader;
    }

    public OutputStream output() {
        return this.output;
    }

    public PrintWriter writer() {
        return this.writer;
    }

    public void close() throws IOException {
        super.close();
        this.reader.close();
    }

    public boolean canPauseResume() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(boolean wait) throws InterruptedException {
        Thread p2;
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            p2 = this.outputPumpThread;
        }
        if (p2 != null) {
            p2.interrupt();
        }
        if (p2 != null) {
            p2.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            if (this.outputPumpThread == null) {
                this.outputPumpThread = new Thread(this::pumpOut, ((Object)((Object)this)).toString() + " output pump thread");
                this.outputPumpThread.setDaemon(true);
                this.outputPumpThread.start();
            }
            if (this.pauseBuffer.size() > 0) {
                try {
                    this.masterOutput.write(this.pauseBuffer.toByteArray());
                    this.pauseBuffer.reset();
                    this.masterOutput.flush();
                }
                catch (IOException ioe) {
                    Log.error((Object[])new Object[]{"Failed to flush pause buffer.", ioe});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paused() {
        Object object = this.lock;
        synchronized (object) {
            return this.paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pumpOut() {
        try {
            byte[] byArray = new byte[65536];
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.paused) {
                        this.outputPumpThread = null;
                        return;
                    }
                }
                int b = this.masterInput.read(byArray);
                if (b < 0) {
                    this.input.close();
                    break;
                }
                this.out.sendData(byArray, 0, b);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.outputPumpThread = null;
            }
        }
        try {
            this.close();
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class InputStreamWrapper
    extends NonBlockingInputStream {
        private final NonBlockingInputStream in;
        private final AtomicBoolean closed = new AtomicBoolean();

        protected InputStreamWrapper(NonBlockingInputStream in) {
            this.in = in;
        }

        public int read(long timeout, boolean isPeek) throws IOException {
            if (this.closed.get()) {
                throw new ClosedException();
            }
            return this.in.read(timeout, isPeek);
        }

        public void close() throws IOException {
            this.closed.set(true);
        }
    }
}

