/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands;

import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageHelper;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;

public class Sleep
extends ShellCommand {
    public Sleep() {
        super("sleep", "Shell", UsageHelper.build("sleep [options] <time>", "-M     Time argument is in milliseconds", "-s     Time argument is in seconds (default)", "-m     Time argument is in minutes", "-h     Time argument is in hours", "-d     Time argument is in days"), "Sleep for some time (defaults to seconds)");
        this.setBuiltIn(false);
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException {
        if (args.length < 2) {
            throw new IllegalArgumentException("Requires single argument specifying time to sleep.");
        }
        long mult = 1000L;
        String ts = args[1];
        char t = ts.charAt(ts.length() - 1);
        if (t == 'M') {
            ts = ts.substring(ts.length() - 1);
            mult = 1L;
        } else if (t == 's') {
            ts = ts.substring(ts.length() - 1);
            mult = 1000L;
        } else if (t == 'm') {
            ts = ts.substring(ts.length() - 1);
            mult = 60000L;
        } else if (t == 'h') {
            ts = ts.substring(ts.length() - 1);
            mult = 3600000L;
        } else if (t == 'd') {
            ts = ts.substring(ts.length() - 1);
            mult = 86400000L;
        }
        try {
            Thread.sleep(Long.parseLong(ts) * mult);
        }
        catch (Exception e) {
            console.println("Interrupted");
        }
    }
}

