/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.jvm;

import com.sshtools.server.vsession.CliHelper;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageHelper;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Threads
extends ShellCommand {
    public Threads() {
        super("threads", "JVM", UsageHelper.build("threads <threadId>..", "-1     Set specified thread(s) priority to MINIMUM", "-2     Set specified thread(s) priority to NORMAL", "-3     Set specified thread(s) priority to MAXIMUM"), "List all running threads");
        this.setBuiltIn(false);
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        argList.remove(0);
        if (argList.size() == 0) {
            Threads.listAllThreads(console);
        } else {
            ThreadGroup root = Threads.getRootThread();
            Thread[] threadArray = new Thread[2000];
            int threads = root.enumerate(threadArray);
            for (int i = 0; i < threads; ++i) {
                Iterator it = argList.iterator();
                while (it.hasNext()) {
                    long id = Long.parseLong((String)it.next());
                    Thread thread = threadArray[i];
                    if (thread.getId() != id) continue;
                    if (CliHelper.hasShortOption(args, '1')) {
                        thread.setPriority(1);
                        continue;
                    }
                    if (CliHelper.hasShortOption(args, '2')) {
                        thread.setPriority(5);
                        continue;
                    }
                    if (CliHelper.hasShortOption(args, '3')) {
                        thread.setPriority(10);
                        continue;
                    }
                    Threads.printThreadInfo(console, thread, "");
                    for (StackTraceElement el : thread.getStackTrace()) {
                        console.println(el.toString());
                    }
                }
            }
        }
    }

    private static void printThreadInfo(VirtualConsole console, Thread t, String indent) throws IOException {
        if (t == null) {
            return;
        }
        console.println(indent + "Thread: " + String.format("%8d", t.getId()) + " " + t.getName() + "  Priority: " + t.getPriority() + (t.isDaemon() ? " Daemon" : "") + (t.isAlive() ? "" : " Not Alive"));
    }

    private static void printGroupInfo(VirtualConsole console, ThreadGroup g, String indent) throws IOException {
        int i;
        if (g == null) {
            return;
        }
        int numThreads = g.activeCount();
        int numGroups = g.activeGroupCount();
        Thread[] threads = new Thread[numThreads];
        ThreadGroup[] groups = new ThreadGroup[numGroups];
        g.enumerate(threads, false);
        g.enumerate(groups, false);
        console.println(indent + "Thread Group: " + g.getName() + "  Max Priority: " + g.getMaxPriority() + (g.isDaemon() ? " Daemon" : ""));
        for (i = 0; i < numThreads; ++i) {
            Threads.printThreadInfo(console, threads[i], indent + "    ");
        }
        for (i = 0; i < numGroups; ++i) {
            Threads.printGroupInfo(console, groups[i], indent + "    ");
        }
    }

    public static void listAllThreads(VirtualConsole console) throws IOException {
        ThreadGroup rootThreadGroup = Threads.getRootThread();
        Threads.printGroupInfo(console, rootThreadGroup, "");
    }

    protected static ThreadGroup getRootThread() {
        ThreadGroup currentThreadGroup;
        ThreadGroup rootThreadGroup = currentThreadGroup = Thread.currentThread().getThreadGroup();
        for (ThreadGroup parent = rootThreadGroup.getParent(); parent != null; parent = parent.getParent()) {
            rootThreadGroup = parent;
        }
        return rootThreadGroup;
    }
}

