/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vsession.commands.ssh;

import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.PasswordAuthenticator;
import com.sshtools.client.PublicKeyAuthenticator;
import com.sshtools.client.SshClient;
import com.sshtools.client.SshClientContext;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.publickey.SshPrivateKeyFileFactory;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.util.Utils;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.vsession.commands.ssh.CommandUtil;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class SshClientHelper {
    public static SshClientContext getSshContext(SshClientArguments arguments) throws IOException, SshException {
        if (CommandUtil.isNotEmpty(arguments.getSecurityLevel()) && (CommandUtil.isNotEmpty(arguments.getCiphers()) || CommandUtil.isNotEmpty(arguments.getHmacs()))) {
            throw new IllegalArgumentException("Security level cannot be specified together with cipher or hmac spec.");
        }
        if (CommandUtil.isNotEmpty(arguments.getSecurityLevel())) {
            SecurityLevel securityLevel = SecurityLevel.valueOf((String)arguments.getSecurityLevel());
            return new SshClientContext(securityLevel);
        }
        if (CommandUtil.isNotEmpty(arguments.getCiphers()) || CommandUtil.isNotEmpty(arguments.getHmacs())) {
            return new SshClientContext(SecurityLevel.NONE);
        }
        return new SshClientContext();
    }

    public static void setUpCipherSpecs(SshClientArguments arguments, SshClientContext ctx) throws IOException, SshException {
        if (CommandUtil.isNotEmpty(arguments.getCiphers())) {
            String[] cipherSpecs = arguments.getCiphers();
            for (int i = cipherSpecs.length - 1; i >= 0; --i) {
                ctx.setPreferredCipherCS(cipherSpecs[i]);
                ctx.setPreferredCipherSC(cipherSpecs[i]);
            }
        }
    }

    public static void setUpMacSpecs(SshClientArguments arguments, SshClientContext ctx) throws IOException, SshException {
        if (CommandUtil.isNotEmpty(arguments.getHmacs())) {
            String[] macSpecs = arguments.getHmacs();
            for (int i = macSpecs.length - 1; i >= 0; --i) {
                ctx.setPreferredMacCS(macSpecs[i]);
                ctx.setPreferredMacSC(macSpecs[i]);
            }
        }
    }

    public static void setUpCompression(SshClientArguments arguments, SshClientContext ctx) throws IOException, SshException {
        if (arguments.isCompression()) {
            ctx.setPreferredCompressionCS("zlib");
            ctx.setPreferredCompressionSC("zlib");
        }
    }

    public static SshClient connectClient(SshClientArguments arguments, VirtualConsole console) throws IOException, SshException, PermissionDeniedException {
        PublicKeyAuthenticator auth;
        SshClientContext ctx = SshClientHelper.getSshContext(arguments);
        SshClientHelper.setUpCipherSpecs(arguments, ctx);
        SshClientHelper.setUpMacSpecs(arguments, ctx);
        SshClientHelper.setUpCompression(arguments, ctx);
        SshClient sshClient = new SshClient(arguments.getDestination(), Integer.valueOf(arguments.getPort()), arguments.getLoginName(), ctx);
        if (Objects.nonNull(arguments.getIdentityFile())) {
            AbstractFile identityFileTarget = arguments.getIdentityFile();
            SshPrivateKeyFile pkf = SshPrivateKeyFileFactory.parse((InputStream)identityFileTarget.getInputStream());
            String passphrase = null;
            if (pkf.isPassphraseProtected()) {
                SshKeyPair pair = null;
                for (int i = 0; i < 3 && sshClient.isConnected(); ++i) {
                    try {
                        passphrase = console.getLineReader().readLine("Passphrase :", Character.valueOf('\u0000'));
                        pair = pkf.toKeyPair(passphrase);
                    }
                    catch (InvalidPassphraseException e) {
                        continue;
                    }
                    auth = new PublicKeyAuthenticator(new SshKeyPair[]{pair});
                    if (!sshClient.authenticate((ClientAuthenticator)auth, 30000L)) {
                        console.println("Public key authentication failed");
                        continue;
                    }
                    console.println("Public key authentication succeeded");
                }
            }
        }
        if (!sshClient.isAuthenticated() && Objects.nonNull(arguments.getIdentity())) {
            auth = new PublicKeyAuthenticator(new SshKeyPair[]{arguments.getIdentity()});
            if (!sshClient.authenticate((ClientAuthenticator)auth, 30000L)) {
                console.println("Public key authentication failed");
            } else {
                console.println("Public key authentication succeeded");
            }
        }
        if (!sshClient.isAuthenticated() && Utils.isNotBlank((String)arguments.getPassword())) {
            sshClient.authenticate((ClientAuthenticator)new PasswordAuthenticator(arguments.getPassword()), 30000L);
        }
        if (!sshClient.isAuthenticated()) {
            while (!sshClient.authenticate((ClientAuthenticator)(auth = new PasswordAuthenticator(console.getLineReader().readLine("Password :", Character.valueOf('*')))), 30000L) && sshClient.isConnected()) {
            }
        }
        if (!sshClient.isAuthenticated()) {
            throw new IOException(String.format("Could not authenticate with %s", arguments.getDestination()));
        }
        return sshClient;
    }
}

