/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.fs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.server.vsession.CliHelper;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageHelper;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;

public class Mv
extends ShellCommand {
    public Mv() {
        super("mv", "File System", UsageHelper.build("mv [options] <sourcePath> <targetPath>", "-v        Verbose. Display file names as they are moved"), "Move or rename a files or directories");
    }

    @Override
    public void run(String[] args, VirtualConsole process) throws IOException, PermissionDeniedException {
        if (args.length < 3) {
            throw new IOException("Not enough file names supplied.");
        }
        AbstractFile target = process.getCurrentDirectory().resolveFile(args[args.length - 1]);
        if (!(args.length <= 3 || target.exists() && target.isDirectory())) {
            throw new IOException("Target must exist as a folder if multiple sources are specified.");
        }
        for (int i = 1; i < args.length - 1; ++i) {
            AbstractFile src = process.getCurrentDirectory().resolveFile(args[i]);
            if (src.isDirectory() && target.isFile()) {
                throw new IOException("Cannot move folder " + src + " to file " + target);
            }
            if (!target.exists()) {
                src.moveTo(target);
            } else {
                src.moveTo(target.resolveFile(src.getName()));
            }
            if (!CliHelper.hasShortOption(args, 'v')) continue;
            process.println(src.toString());
        }
    }
}

