/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.fs;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;

public class Cd
extends ShellCommand {
    public Cd() {
        super("cd", "File System", "cd <directory>", "Moves the working directory to a new directory");
        this.setBuiltIn(true);
    }

    @Override
    public void run(String[] args, VirtualConsole process) throws IOException, PermissionDeniedException {
        if (args.length > 2) {
            throw new IllegalArgumentException("Too many arguments.");
        }
        if (args.length > 1) {
            process.setCurrentDirectory(args[1]);
        } else {
            try {
                process.setCurrentDirectory(process.getEnvironment().getOrDefault("HOME", "").toString());
            }
            catch (PermissionDeniedException e) {
                throw new IllegalAccessError();
            }
        }
    }
}

