/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileImpl;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.files.vfs.VFSFileFactory;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.PosixPermissions;
import com.sshtools.common.sftp.SftpFileAttributes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class VFSFile
extends AbstractFileImpl<VFSFile> {
    FileObject file;
    FileSystemOptions opts;

    public VFSFile(FileObject file, VFSFileFactory fileFactory) {
        super((AbstractFileFactory)fileFactory);
        this.file = file;
    }

    public VFSFile(String path, VFSFileFactory fileFactory) throws IOException {
        super((AbstractFileFactory)fileFactory);
        this.file = fileFactory.getFileSystemManager().resolveFile(path);
    }

    public VFSFile(String path, String defaultPath, VFSFileFactory fileFactory, FileSystemOptions opts) throws IOException {
        super((AbstractFileFactory)fileFactory);
        this.file = fileFactory.getFileSystemManager().resolveFile(path, opts);
        this.opts = opts;
    }

    public FileObject getFileObject() {
        return this.file;
    }

    public AbstractFile getParentFile() throws IOException {
        return new VFSFile(this.file.getParent(), (VFSFileFactory)this.fileFactory);
    }

    public boolean exists() throws IOException {
        return this.file.exists();
    }

    public boolean createFolder() throws PermissionDeniedException, IOException {
        if (!this.file.exists()) {
            this.file.createFolder();
            return this.file.exists();
        }
        return false;
    }

    public long lastModified() throws IOException {
        return this.file.getContent().getLastModifiedTime();
    }

    public String getName() {
        return this.file.getName().getBaseName();
    }

    public long length() throws IOException {
        if (this.file.getType() == FileType.FILE) {
            return this.file.getContent().getSize();
        }
        return 0L;
    }

    public SftpFileAttributes getAttributes() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException();
        }
        SftpFileAttributes.SftpFileAttributesBuilder bldr = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)this.getFileType(this.file), (String)"UTF-8");
        if (!this.isDirectory()) {
            bldr.withSize(this.length());
        }
        bldr.withLastModifiedTime(this.lastModified());
        bldr.withLastAccessTime(this.lastModified());
        PosixPermissions.PosixPermissionsBuilder permBldr = PosixPermissions.PosixPermissionsBuilder.create();
        if (this.isReadable()) {
            permBldr.withPermissions(new PosixFilePermission[]{PosixFilePermission.OWNER_READ});
        }
        if (this.isWritable()) {
            permBldr.withPermissions(new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE});
        }
        if (this.isDirectory()) {
            permBldr.withPermissions(new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE});
        }
        bldr.withPermissions(permBldr.build());
        try {
            for (String name : this.file.getContent().getAttributeNames()) {
                Object attribute = this.file.getContent().getAttribute(name);
                bldr.addExtendedAttribute(name, attribute == null ? new byte[]{} : String.valueOf(attribute).getBytes());
                if (name.equals("uid")) {
                    bldr.withUidOrUsername((String)attribute);
                    continue;
                }
                if (name.equals("gid")) {
                    bldr.withGidOrGroup((String)attribute);
                    continue;
                }
                if (!name.equals("accessedTime")) continue;
                bldr.withLastAccessTime(((Long)attribute).longValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bldr.build();
    }

    private int getFileType(FileObject file) throws FileSystemException {
        try {
            for (String name : file.getContent().getAttributeNames()) {
                Object attribute = file.getContent().getAttribute(name);
                if (name.equals("link") && Boolean.TRUE.equals(attribute)) {
                    return 3;
                }
                if (name.equals("block") && Boolean.TRUE.equals(attribute)) {
                    return 8;
                }
                if (name.equals("character") && Boolean.TRUE.equals(attribute)) {
                    return 7;
                }
                if (name.equals("socket") && Boolean.TRUE.equals(attribute)) {
                    return 6;
                }
                if (name.equals("fifo") && Boolean.TRUE.equals(attribute)) {
                    return 9;
                }
                if (!name.equals("pipe") || !Boolean.TRUE.equals(attribute)) continue;
                return 4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (file.getType()) {
            case FILE: {
                return 1;
            }
            case FOLDER: {
                return 2;
            }
        }
        return 5;
    }

    public boolean isHidden() throws IOException {
        return this.file.isHidden();
    }

    public boolean isDirectory() throws IOException {
        return this.file.getType() == FileType.FOLDER;
    }

    public List<AbstractFile> getChildren() throws IOException, PermissionDeniedException {
        ArrayList<AbstractFile> children = new ArrayList<AbstractFile>();
        for (FileObject f : this.file.getChildren()) {
            children.add((AbstractFile)new VFSFile(f, (VFSFileFactory)this.fileFactory));
        }
        return children;
    }

    public boolean isFile() throws IOException {
        return this.file.getType() == FileType.FILE;
    }

    public String getAbsolutePath() throws IOException, PermissionDeniedException {
        if (!((VFSFileFactory)this.getFileFactory()).isReturnURIForPath()) {
            return this.file.getName().getPath();
        }
        return this.file.getName().getURI();
    }

    public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        if (src instanceof VFSFile) {
            this.file.copyFrom(((VFSFile)src).file, (FileSelector)new AllFileSelector());
        } else {
            super.copyFrom(src);
        }
    }

    public boolean isReadable() throws IOException {
        return this.file.isReadable();
    }

    public boolean isWritable() throws IOException {
        return this.file.isWriteable();
    }

    public boolean createNewFile() throws PermissionDeniedException, IOException {
        if (!this.file.exists()) {
            this.file.createFile();
            return this.file.exists();
        }
        return false;
    }

    public void truncate() throws PermissionDeniedException, IOException {
        OutputStream out = this.file.getContent().getOutputStream();
        out.close();
    }

    public InputStream getInputStream() throws IOException {
        return this.file.getContent().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.file.getContent().getOutputStream();
    }

    public boolean delete(boolean recurse) throws IOException {
        if (recurse) {
            this.file.delete((FileSelector)new AllFileSelector());
            return true;
        }
        return this.file.delete();
    }

    public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        if (target instanceof VFSFile) {
            this.file.moveTo(((VFSFile)target).file);
        } else {
            super.moveTo(target);
        }
    }

    public void setAttributes(SftpFileAttributes attrs) throws IOException {
        this.file.getContent().setLastModifiedTime(attrs.lastModifiedTime().toMillis());
        if (this.file.getFileSystem().getRootName().getScheme().equals("sftp")) {
            Optional group;
            Optional username = attrs.bestUsernameOr();
            if (username.isPresent()) {
                this.file.getContent().setAttribute("uid", username.get());
            }
            if ((group = attrs.bestGroupOr()).isPresent()) {
                this.file.getContent().setAttribute("gid", group.get());
            }
            this.file.getContent().setAttribute("permissions", (Object)attrs.permissions().asInt());
        }
    }

    public String getCanonicalPath() throws IOException, PermissionDeniedException {
        return this.file.getName().getURI();
    }

    public boolean supportsRandomAccess() {
        return this.file.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_READ) || this.file.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_WRITE);
    }

    public AbstractFileRandomAccess openFile(boolean writeAccess) throws IOException {
        return new VFSFileRandomAccess(this.file.getContent().getRandomAccessContent(writeAccess ? RandomAccessMode.READWRITE : RandomAccessMode.READ));
    }

    public void refresh() {
        try {
            this.file.refresh();
        }
        catch (FileSystemException e) {
            Log.error((String)"Failed to refresh.", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        return new VFSFile(this.file.resolveFile(child), (VFSFileFactory)this.fileFactory);
    }

    protected int doHashCode() {
        return this.file.hashCode();
    }

    protected boolean doEquals(Object obj) {
        if (obj instanceof VFSFile) {
            VFSFile f2 = (VFSFile)((Object)obj);
            return this.file.equals(f2.file);
        }
        return false;
    }

    public String readSymbolicLink() throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    class VFSFileRandomAccess
    implements AbstractFileRandomAccess {
        RandomAccessContent randomAccessContent;

        public VFSFileRandomAccess(RandomAccessContent randomAccessContent) {
            this.randomAccessContent = randomAccessContent;
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            long length = Math.min(this.randomAccessContent.length() - this.randomAccessContent.getFilePointer(), (long)len);
            if (length <= 0L) {
                return -1;
            }
            this.randomAccessContent.readFully(buf, off, (int)length);
            return (int)length;
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            this.randomAccessContent.write(buf, off, len);
        }

        public void setLength(long length) throws IOException {
            long pos = this.randomAccessContent.getFilePointer();
            if (length > pos) {
                this.randomAccessContent.seek(pos - 1L);
                this.randomAccessContent.write(0);
                this.randomAccessContent.seek(pos);
            }
        }

        public void seek(long position) throws IOException {
            this.randomAccessContent.seek(position);
        }

        public void close() throws IOException {
            this.randomAccessContent.close();
        }

        public long getFilePointer() throws IOException {
            return this.randomAccessContent.getFilePointer();
        }

        public int read() throws IOException {
            return this.randomAccessContent.readByte() & 0xFF;
        }
    }
}

