/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.util.FileUtils;
import java.util.HashMap;
import java.util.Map;

public class AbstractMount {
    private Map<String, Object> attributes = new HashMap<String, Object>();
    protected String mount;
    protected String path;
    private boolean filesystemRoot;
    private boolean isDefault;
    protected boolean isImaginary;
    protected String username = "unknown";
    protected String group = "unknown";
    protected int uid = 0;
    protected int gid = 0;

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AbstractMount)) {
            return false;
        }
        return ((AbstractMount)obj).mount.equals(this.mount) && ((AbstractMount)obj).path.equals(this.path);
    }

    public int hashCode() {
        return this.mount.hashCode();
    }

    protected AbstractMount(String mount, String path) {
        this(mount, path, false, false);
    }

    protected AbstractMount(String mount, String path, boolean isDefault, boolean isImaginary) {
        this.filesystemRoot = mount.equals("/");
        this.mount = mount.equals("/") ? mount : FileUtils.removeTrailingSlash((String)mount);
        this.path = FileUtils.removeTrailingSlash((String)path);
        this.isDefault = isDefault;
        this.isImaginary = isImaginary;
    }

    public String getMount() {
        return this.mount;
    }

    public String getRoot() {
        return this.path;
    }

    public boolean isFilesystemRoot() {
        return this.filesystemRoot;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isImaginary() {
        return this.isImaginary;
    }

    public Object getAttribute(String key, Object defaultValue) {
        if (this.attributes.containsKey(key)) {
            return this.attributes.get(key);
        }
        return defaultValue;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public String toString() {
        return this.getMount() + " on " + this.getRoot();
    }

    public String getUsername() {
        return this.username;
    }

    public String getGroup() {
        return this.group;
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }
}

