/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualFileObject;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.files.vfs.VirtualMountManager;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VirtualMountFile
extends VirtualFileObject {
    private VirtualMount mount;
    private String name;
    private String path;
    private AbstractFile file;
    Map<String, AbstractFile> cachedChildren;

    public VirtualMountFile(String path, VirtualMount mount, VirtualFileFactory fileFactory) throws PermissionDeniedException, IOException {
        super(fileFactory);
        this.mount = mount;
        int idx = path.lastIndexOf(47);
        this.name = idx > -1 ? path.substring(idx + 1) : path;
        this.path = path;
    }

    private AbstractFile resolveFile() throws PermissionDeniedException, IOException {
        if (Objects.nonNull(this.file)) {
            return this.file;
        }
        this.file = this.mount.getActualFileFactory().getFile(this.mount.getResolvePath(this.path));
        return this.file;
    }

    public boolean exists() throws IOException, PermissionDeniedException {
        return this.resolveFile().exists();
    }

    public boolean createFolder() throws PermissionDeniedException, IOException {
        return this.resolveFile().createFolder();
    }

    public long lastModified() throws IOException, PermissionDeniedException {
        return this.resolveFile().lastModified();
    }

    public String getName() {
        return this.name;
    }

    public long length() throws IOException, PermissionDeniedException {
        return this.resolveFile().length();
    }

    public SftpFileAttributes getAttributes() throws FileNotFoundException, IOException, PermissionDeniedException {
        return this.resolveFile().getAttributes();
    }

    public boolean isHidden() throws IOException, PermissionDeniedException {
        return this.resolveFile().isHidden();
    }

    public boolean isDirectory() throws IOException, PermissionDeniedException {
        return this.resolveFile().isDirectory();
    }

    public synchronized List<AbstractFile> getChildren() throws IOException, PermissionDeniedException {
        if (Objects.isNull(this.cachedChildren)) {
            HashMap<String, AbstractFile> files = new HashMap<String, AbstractFile>(this.getVirtualMounts());
            String currentPath = FileUtils.checkEndsWithSlash((String)this.path);
            VirtualMountManager mgr = this.fileFactory.getMountManager();
            AbstractFile file = this.resolveFile();
            if (file.exists()) {
                VirtualMount actualMount = mgr.getMount(currentPath);
                for (AbstractFile child : file.getChildren()) {
                    files.put(currentPath + child.getName(), new VirtualMountFile(currentPath + child.getName(), actualMount, this.fileFactory));
                }
            }
            this.cachedChildren = files;
        }
        return new ArrayList<AbstractFile>(this.cachedChildren.values());
    }

    public boolean isFile() throws IOException, PermissionDeniedException {
        return this.resolveFile().isFile();
    }

    public String getAbsolutePath() throws IOException, PermissionDeniedException {
        return this.path;
    }

    public InputStream getInputStream() throws IOException, PermissionDeniedException {
        return this.resolveFile().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException, PermissionDeniedException {
        return this.resolveFile().getOutputStream();
    }

    public boolean isReadable() throws IOException, PermissionDeniedException {
        return this.resolveFile().isReadable();
    }

    public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        this.resolveFile().copyFrom(src);
    }

    public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        this.resolveFile().moveTo(target);
    }

    public boolean delete(boolean recursive) throws IOException, PermissionDeniedException {
        return this.resolveFile().delete(recursive);
    }

    @Override
    public synchronized void refresh() {
        try {
            this.cachedChildren = null;
            super.refresh();
            this.resolveFile().refresh();
        }
        catch (PermissionDeniedException | IOException throwable) {
            // empty catch block
        }
    }

    public boolean isWritable() throws IOException, PermissionDeniedException {
        return this.resolveFile().isWritable();
    }

    public boolean createNewFile() throws PermissionDeniedException, IOException {
        return this.resolveFile().createNewFile();
    }

    public void truncate() throws PermissionDeniedException, IOException {
        this.resolveFile().truncate();
    }

    public void setAttributes(SftpFileAttributes attrs) throws IOException {
        this.file.setAttributes(attrs);
    }

    public String getCanonicalPath() throws IOException, PermissionDeniedException {
        return this.path;
    }

    public boolean supportsRandomAccess() {
        try {
            return this.resolveFile().supportsRandomAccess();
        }
        catch (PermissionDeniedException | IOException e) {
            return false;
        }
    }

    public AbstractFileRandomAccess openFile(boolean writeAccess) throws IOException, PermissionDeniedException {
        return this.resolveFile().openFile(writeAccess);
    }

    public OutputStream getOutputStream(boolean append) throws IOException, PermissionDeniedException {
        return this.resolveFile().getOutputStream(append);
    }

    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        if (child.startsWith("/")) {
            return this.fileFactory.getFile(child);
        }
        return this.fileFactory.getFile(this.path + (this.path.equals("/") || this.path.endsWith("/") ? "" : "/") + child);
    }

    public AbstractFileFactory<VirtualFile> getFileFactory() {
        return this.mount.getVirtualFileFactory();
    }

    public int hashCode() {
        return Objects.hash(this.mount, this.path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualMountFile other = (VirtualMountFile)this.getClass().cast(obj);
        return Objects.equals(other.path, this.path) && Objects.equals(other.mount, this.mount);
    }

    public void symlinkTo(String target) throws IOException, PermissionDeniedException {
        this.resolveFile().symlinkTo(target);
    }

    public String readSymbolicLink() throws IOException, PermissionDeniedException {
        return this.resolveFile().readSymbolicLink();
    }
}

