/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.files.vfs.VirtualMountManager;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class VirtualMountFile
implements VirtualFile {
    private VirtualMount mount;
    private VirtualFileFactory fileFactory;
    private String name;
    private String path;
    private AbstractFile file;

    public VirtualMountFile(String path, VirtualMount mount, VirtualFileFactory fileFactory) throws PermissionDeniedException, IOException {
        this.mount = mount;
        this.fileFactory = fileFactory;
        int idx = path.lastIndexOf(47);
        this.name = idx > -1 ? path.substring(idx + 1) : path;
        this.path = path;
        this.file = mount.getActualFileFactory().getFile(mount.getResolvePath(path));
    }

    public boolean exists() throws IOException, PermissionDeniedException {
        return this.file.exists();
    }

    public boolean createFolder() throws PermissionDeniedException, IOException {
        return this.file.createFolder();
    }

    public long lastModified() throws IOException, PermissionDeniedException {
        return this.file.lastModified();
    }

    public String getName() {
        return this.name;
    }

    public long length() throws IOException, PermissionDeniedException {
        return this.file.length();
    }

    public SftpFileAttributes getAttributes() throws FileNotFoundException, IOException, PermissionDeniedException {
        return this.file.getAttributes();
    }

    public boolean isHidden() throws IOException, PermissionDeniedException {
        return this.file.isHidden();
    }

    public boolean isDirectory() throws IOException, PermissionDeniedException {
        return this.file.isDirectory();
    }

    public List<AbstractFile> getChildren() throws IOException, PermissionDeniedException {
        ArrayList<AbstractFile> files = new ArrayList<AbstractFile>();
        String currentPath = FileUtils.checkEndsWithSlash((String)this.path);
        VirtualMountManager mgr = this.fileFactory.getMountManager();
        for (VirtualMount m : mgr.getMounts()) {
            String mpath = FileUtils.checkEndsWithSlash((String)m.getMount());
            if (!mpath.startsWith(currentPath) || mpath.equals(currentPath)) continue;
            String child = m.getMount().substring(currentPath.length());
            if (child.indexOf(47) > -1) {
                child = child.substring(0, child.indexOf(47));
            }
            files.add(new VirtualMountFile(currentPath + child, m, this.fileFactory));
        }
        VirtualMount actualMount = mgr.getMount(currentPath);
        for (AbstractFile child : this.file.getChildren()) {
            files.add(new VirtualMountFile(currentPath + child.getName(), actualMount, this.fileFactory));
        }
        return files;
    }

    public boolean isFile() throws IOException, PermissionDeniedException {
        return this.file.isFile();
    }

    public String getAbsolutePath() throws IOException, PermissionDeniedException {
        return this.path;
    }

    public InputStream getInputStream() throws IOException, PermissionDeniedException {
        return this.file.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException, PermissionDeniedException {
        return this.file.getOutputStream();
    }

    public boolean isReadable() throws IOException, PermissionDeniedException {
        return this.file.isReadable();
    }

    public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        this.file.copyFrom(src);
    }

    public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        this.file.moveTo(target);
    }

    public boolean delete(boolean recursive) throws IOException, PermissionDeniedException {
        return this.file.delete(recursive);
    }

    public void refresh() {
        this.file.refresh();
    }

    public boolean isWritable() throws IOException, PermissionDeniedException {
        return this.file.isWritable();
    }

    public boolean createNewFile() throws PermissionDeniedException, IOException {
        return this.file.createNewFile();
    }

    public void truncate() throws PermissionDeniedException, IOException {
        this.file.truncate();
    }

    public void setAttributes(SftpFileAttributes attrs) throws IOException {
        this.file.setAttributes(attrs);
    }

    public String getCanonicalPath() throws IOException, PermissionDeniedException {
        return this.path;
    }

    public boolean supportsRandomAccess() {
        return this.file.supportsRandomAccess();
    }

    public AbstractFileRandomAccess openFile(boolean writeAccess) throws IOException, PermissionDeniedException {
        return this.file.openFile(writeAccess);
    }

    public OutputStream getOutputStream(boolean append) throws IOException, PermissionDeniedException {
        return this.file.getOutputStream(append);
    }

    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        if (child.startsWith("/")) {
            return this.fileFactory.getFile(child);
        }
        return this.fileFactory.getFile(this.path + (this.path.equals("/") || this.path.endsWith("/") ? "" : "/") + child);
    }

    public AbstractFileFactory<VirtualFile> getFileFactory() {
        return this.mount.getVirtualFileFactory();
    }

    public int hashCode() {
        return Objects.hash(this.mount, this.path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualMountFile other = (VirtualMountFile)this.getClass().cast(obj);
        return Objects.equals(other.path, this.path) && Objects.equals(other.mount, this.mount);
    }
}

