/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.util;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExpiringConcurrentHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 4825825094828550762L;
    private Map<K, Long> entryTime = new ConcurrentHashMap<K, Long>();
    private ExpiryConfiguration expiryConfig;

    public ExpiringConcurrentHashMap(final long expiryInMillis) {
        this.expiryConfig = new ExpiryConfiguration(){

            @Override
            public long expiresInMillis() {
                return expiryInMillis;
            }
        };
    }

    public long getExpiryTime() {
        return this.expiryConfig.expiresInMillis();
    }

    public ExpiringConcurrentHashMap(ExpiryConfiguration expiryConfig) {
        this.expiryConfig = expiryConfig;
    }

    @Override
    public V put(K key, V value) {
        this.purgeEntries();
        return this.doPut(key, value);
    }

    private V doPut(K key, V value) {
        Long date = this.entryTime.getOrDefault(key, new Long(System.currentTimeMillis()));
        this.entryTime.put(key, date);
        V returnVal = super.put(key, value);
        return returnVal;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.purgeEntries();
        for (K key : m.keySet()) {
            this.doPut(key, m.get(key));
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.purgeEntries();
        if (!this.containsKey(key)) {
            return this.doPut(key, value);
        }
        return this.get(key);
    }

    @Override
    public V get(Object key) {
        this.purgeEntries();
        return super.get(key);
    }

    private void purgeEntries() {
        long currentTime = new Date().getTime();
        for (K key : this.entryTime.keySet()) {
            if (currentTime <= this.entryTime.get(key) + this.expiryConfig.expiresInMillis()) continue;
            this.remove(key);
            this.entryTime.remove(key);
        }
    }

    public static interface ExpiryConfiguration {
        public long expiresInMillis();
    }
}

