/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.util;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class Version {
    static String version;

    public static String getVersion() {
        return Version.getVersion("maverick-base");
    }

    public static String getVersion(String artifactId) {
        Package aPackage;
        String fakeVersion = System.getProperty("maverick.development.version");
        if (fakeVersion != null) {
            return fakeVersion;
        }
        if (version != null) {
            return version;
        }
        try {
            Properties p = new Properties();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/META-INF/maven/com.sshtools/" + artifactId + "/pom.properties");
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "");
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        if (version == null && (aPackage = Version.class.getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(new File("pom.xml"));
                version = doc.getDocumentElement().getElementsByTagName("version").item(0).getTextContent();
            }
            catch (Exception e) {
                version = "DEV_VERSION";
            }
        }
        return version;
    }

    public static String getProductId() {
        return System.getProperty("hypersocket.id", "hypersocket-one");
    }

    public static String getBrandId() {
        String id = Version.getProductId();
        int idx = id.indexOf(45);
        if (idx == -1) {
            throw new IllegalStateException("Product id must consist of string formatted like <brand>-<product>");
        }
        return id.substring(0, idx);
    }
}

