/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.components;

import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.server.SshServerContext;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.math.BigInteger;

public abstract class SshKeyExchangeServer
implements SshKeyExchange<SshServerContext> {
    protected BigInteger secret;
    protected byte[] exchangeHash;
    protected byte[] hostKey;
    protected byte[] signature;
    protected String clientId;
    protected String serverId;
    protected byte[] clientKexInit;
    protected byte[] serverKexInit;
    protected SshPrivateKey prvkey;
    protected SshPublicKey pubkey;
    protected boolean firstPacketFollows;
    protected boolean useFirstPacket;
    boolean sentNewKeys = false;
    boolean receivedNewKeys = false;
    protected SshTransport<SshServerContext> transport;
    String hashAlgorithm;
    private final SecurityLevel securityLevel;
    final int priority;

    public SshKeyExchangeServer(String hashAlgorithm, SecurityLevel securityLevel, int priority) {
        this.hashAlgorithm = hashAlgorithm;
        this.securityLevel = securityLevel;
        this.priority = priority;
    }

    public SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setReceivedNewKeys(boolean receivedNewKeys) {
        this.receivedNewKeys = receivedNewKeys;
    }

    public void setSentNewKeys(boolean sentNewKeys) {
        this.sentNewKeys = sentNewKeys;
    }

    public boolean hasSentNewKeys() {
        return this.sentNewKeys;
    }

    public boolean hasReceivedNewKeys() {
        return this.receivedNewKeys;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public abstract String getAlgorithm();

    public byte[] getExchangeHash() {
        return this.exchangeHash;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public BigInteger getSecret() {
        return this.secret;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public abstract boolean processMessage(byte[] var1) throws SshException, IOException;

    public void reset() {
        this.exchangeHash = null;
        this.hostKey = null;
        this.signature = null;
        this.secret = null;
    }
}

