/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.auth.AuthenticationMechanismFactory;
import com.sshtools.common.auth.DefaultAuthenticationMechanismFactory;
import com.sshtools.common.auth.DefaultPublicKeyAuthenticationVerifier;
import com.sshtools.common.auth.PublicKeyAuthenticationVerifier;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SshKeyPairGenerator;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.publickey.SshPrivateKeyFileFactory;
import com.sshtools.common.publickey.SshPublicKeyFile;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.ssh.components.ComponentInstanceFactory;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.SshCertificate;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.ssh.components.jce.OpenSshRsaCertificate;
import com.sshtools.common.ssh.components.jce.OpenSshRsaSha256Certificate;
import com.sshtools.common.ssh.components.jce.OpenSshRsaSha512Certificate;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKey;
import com.sshtools.server.DefaultServerChannelFactory;
import com.sshtools.server.RemoteForwardingChannelFactoryImpl;
import com.sshtools.server.ServerConnectionStateListener;
import com.sshtools.server.TransportProtocolServer;
import com.sshtools.server.components.SshKeyExchangeServer;
import com.sshtools.server.components.SshKeyExchangeServerFactory;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.ssh.ChannelFactory;
import com.sshtools.synergy.ssh.ConnectionManager;
import com.sshtools.synergy.ssh.ForwardingManager;
import com.sshtools.synergy.ssh.GlobalRequestHandler;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class SshServerContext
extends SshContext {
    Map<String, SshKeyPair> hostkeys = new ConcurrentHashMap<String, SshKeyPair>(8, 0.9f, 1);
    boolean ensureGracefulDisconnect = false;
    ForwardingManager<SshServerContext> forwardingManager;
    ConnectionManager<SshServerContext> connectionManager;
    static ForwardingManager<SshServerContext> globalForwardingManager = new ForwardingManager();
    static ConnectionManager<SshServerContext> globalConnectionManager = new ConnectionManager("server");
    Collection<ServerConnectionStateListener> stateListeners = new ArrayList<ServerConnectionStateListener>();
    ChannelFactory<SshServerContext> channelFactory = new DefaultServerChannelFactory();
    Map<String, GlobalRequestHandler<SshServerContext>> globalRequestHandlers = Collections.synchronizedMap(new HashMap());
    int maxDHGroupSize = 2048;
    private boolean forceServerPreferences = false;
    private static ComponentFactory<SshKeyExchange<SshServerContext>> verifiedKeyExchanges;

    public SshServerContext(SshEngine engine) throws IOException, SshException {
        this(engine, SecurityLevel.STRONG);
    }

    public SshServerContext(SshEngine engine, ComponentManager componentManager) throws IOException, SshException {
        this(engine, componentManager, SecurityLevel.STRONG);
    }

    public SshServerContext(SshEngine engine, ComponentManager componentManager, SecurityLevel securityLevel) throws IOException, SshException {
        super(engine, componentManager, securityLevel);
        this.setAuthenicationMechanismFactory((AuthenticationMechanismFactory<SshServerContext>)new DefaultAuthenticationMechanismFactory());
        this.setPolicy(PublicKeyAuthenticationVerifier.class, new DefaultPublicKeyAuthenticationVerifier());
    }

    public SshServerContext(SshEngine engine, SecurityLevel securityLevel) throws IOException, SshException {
        this(engine, ComponentManager.getDefaultInstance(), securityLevel);
    }

    public ConnectionManager<SshServerContext> getConnectionManager() {
        return Objects.isNull(this.connectionManager) ? globalConnectionManager : this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager<SshServerContext> connectionManager) {
        this.connectionManager = connectionManager;
    }

    public ProtocolEngine createEngine(ConnectRequestFuture connectFuture) throws IOException {
        return new TransportProtocolServer(this, connectFuture);
    }

    public void addStateListener(ServerConnectionStateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public Collection<ServerConnectionStateListener> getStateListeners() {
        return this.stateListeners;
    }

    public void addGlobalRequestHandler(GlobalRequestHandler<SshServerContext> handler) {
        for (int i = 0; i < handler.supportedRequests().length; ++i) {
            this.globalRequestHandlers.put(handler.supportedRequests()[i], handler);
        }
    }

    public GlobalRequestHandler<SshServerContext> getGlobalRequestHandler(String name) {
        return this.globalRequestHandlers.get(name);
    }

    public String getPreferredPublicKey() {
        if (this.hostkeys.containsKey(this.prefPublicKey)) {
            return this.prefPublicKey;
        }
        if (this.hostkeys.entrySet().isEmpty()) {
            throw new RuntimeException("No host keys loaded!!");
        }
        Map.Entry<String, SshKeyPair> e = this.hostkeys.entrySet().iterator().next();
        return e.getKey();
    }

    public String getSupportedPublicKeys() {
        Object list = "";
        for (String alg : this.supportedPublicKeys().order()) {
            if (!this.isHostKeySupported(alg)) continue;
            list = (String)list + (((String)list).length() == 0 ? "" : ",") + alg;
        }
        return list;
    }

    private boolean isHostKeySupported(String alg) {
        return this.hostkeys.containsKey(alg);
    }

    public void setPreferredPublicKey(String name) throws IOException, SshException {
        if (!this.publicKeys.contains(name)) {
            throw new IOException(name + " is not supported");
        }
        this.prefPublicKey = name;
        this.setPublicKeyPreferredPosition(name, 0);
    }

    public SshKeyPair[] getHostKeys() {
        SshKeyPair[] keys = new SshKeyPair[this.hostkeys.size()];
        this.hostkeys.values().toArray(keys);
        return keys;
    }

    public SshKeyPair getHostKey(String algorithm) throws IOException {
        if (!this.hostkeys.containsKey(algorithm)) {
            throw new IOException("The server does not have a " + algorithm + " key configured");
        }
        return this.hostkeys.get(algorithm);
    }

    public void addHostKey(SshKeyPair keyPair) throws IOException {
        if (keyPair instanceof SshCertificate) {
            SshKeyPair converted = new SshKeyPair();
            converted.setPrivateKey(keyPair.getPrivateKey());
            converted.setPublicKey((SshPublicKey)((SshCertificate)keyPair).getCertificate());
            if (this.hostkeys.containsKey(converted.getPublicKey().getAlgorithm())) {
                Log.warn((String)("The server already has a " + keyPair.getPublicKey().getAlgorithm() + " certificate configured."), (Object[])new Object[0]);
            }
            this.hostkeys.put(converted.getPublicKey().getAlgorithm(), converted);
            if (converted.getPublicKey() instanceof OpenSshRsaCertificate) {
                SshKeyPair upgraded;
                if (this.supportedPublicKeys().contains("rsa-sha2-256-cert-v01@openssh.com") && !this.hostkeys.containsKey("rsa-sha2-256-cert-v01@openssh.com")) {
                    try {
                        upgraded = new SshKeyPair();
                        upgraded.setPrivateKey(converted.getPrivateKey());
                        upgraded.setPublicKey(new OpenSshRsaSha256Certificate().init(converted.getPublicKey().getEncoded()));
                        this.hostkeys.put("rsa-sha2-256-cert-v01@openssh.com", upgraded);
                    }
                    catch (SshException e) {
                        Log.error((String)"Could not upgrade RSA SHA1 certificate to SHA2 based", (Throwable)e, (Object[])new Object[0]);
                    }
                }
                if (this.supportedPublicKeys().contains("rsa-sha2-512-cert-v01@openssh.com") && !this.hostkeys.containsKey("rsa-sha2-512-cert-v01@openssh.com")) {
                    try {
                        upgraded = new SshKeyPair();
                        upgraded.setPrivateKey(converted.getPrivateKey());
                        upgraded.setPublicKey(new OpenSshRsaSha512Certificate().init(converted.getPublicKey().getEncoded()));
                        this.hostkeys.put("rsa-sha2-512-cert-v01@openssh.com", upgraded);
                    }
                    catch (SshException e) {
                        Log.error((String)"Could not upgrade RSA SHA1 certificate to SHA2 based", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
        } else {
            if (this.hostkeys.containsKey(keyPair.getPublicKey().getAlgorithm())) {
                Log.warn((String)("The server already has a " + keyPair.getPublicKey().getAlgorithm() + " key configured."), (Object[])new Object[0]);
            }
            this.hostkeys.put(keyPair.getPublicKey().getAlgorithm(), keyPair);
            if (keyPair.getPublicKey() instanceof Ssh2RsaPublicKey && keyPair.getPublicKey().getAlgorithm().equals("ssh-rsa") && this.supportedPublicKeys().contains("rsa-sha2-256") && !this.hostkeys.containsKey("rsa-sha2-256")) {
                this.hostkeys.put("rsa-sha2-256", SshKeyUtils.makeRSAWithSHA256Signature((SshKeyPair)keyPair));
            }
            if (keyPair.getPublicKey() instanceof Ssh2RsaPublicKey && keyPair.getPublicKey().getAlgorithm().equals("ssh-rsa") && this.supportedPublicKeys().contains("rsa-sha2-512") && !this.hostkeys.containsKey("rsa-sha2-512")) {
                this.hostkeys.put("rsa-sha2-512", SshKeyUtils.makeRSAWithSHA512Signature((SshKeyPair)keyPair));
            }
        }
    }

    public void addHostKeys(Collection<SshKeyPair> keys) throws IOException {
        for (SshKeyPair key : keys) {
            this.addHostKey(key);
        }
    }

    public void generateTemporaryHostKey(String algorithm, int bitlength) throws IOException, SshException {
        this.addHostKey(SshServerContext.generateKey(algorithm, bitlength));
    }

    public ChannelFactory<SshServerContext> getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory<SshServerContext> channelFactory) {
        this.channelFactory = channelFactory;
    }

    public ForwardingManager<SshServerContext> getForwardingManager() {
        return this.forwardingManager == null ? globalForwardingManager : this.forwardingManager;
    }

    public void setForwardingManager(ForwardingManager<SshServerContext> forwardingManager) {
        this.forwardingManager = forwardingManager;
    }

    public boolean hasPublicKey(String algorithm) {
        return this.hostkeys.containsKey(algorithm);
    }

    public SshKeyPair loadOrGenerateHostKey(File key, String type, int bitlength) throws IOException, InvalidPassphraseException, SshException {
        return this.loadOrGenerateHostKey(key, type, bitlength, 1, "");
    }

    public SshKeyPair loadOrGenerateHostKey(File key, String type, int bitlength, String passPhrase) throws IOException, InvalidPassphraseException, SshException {
        return this.loadOrGenerateHostKey(key, type, bitlength, 1, passPhrase);
    }

    public void loadHostKey(InputStream in) throws IOException, InvalidPassphraseException, SshException {
        this.loadHostKey(in, "");
    }

    public SshKeyPair loadOrGenerateHostKey(File key, String type, int bitlength, int publicKeyFormat, String passPhrase) throws IOException, InvalidPassphraseException, SshException {
        SshKeyPair pair = !key.exists() ? SshServerContext.generateKeyFiles(key, type, bitlength, publicKeyFormat) : this.loadKey(key, passPhrase);
        this.addHostKey(pair);
        return pair;
    }

    public void loadHostKey(InputStream in, String passPhrase) throws IOException, InvalidPassphraseException, SshException {
        this.addHostKey(this.loadKey(in, passPhrase));
    }

    public SshKeyPair loadKey(File key, String passphrase) throws IOException, InvalidPassphraseException {
        return this.loadKey(new FileInputStream(key), passphrase);
    }

    public SshKeyPair loadKey(InputStream in, String passphrase) throws IOException, InvalidPassphraseException {
        SshKeyPair pair = SshPrivateKeyFileFactory.parse((InputStream)in).toKeyPair(passphrase);
        in.close();
        return pair;
    }

    public static SshKeyPair generateKeyFiles(File keyFilename, String type, int bitlength, int publicKeyFormat) throws IOException, SshException {
        SshKeyPair pair = SshServerContext.generateKey(type, bitlength);
        SshPrivateKeyFile prvfile = SshPrivateKeyFileFactory.create((SshKeyPair)pair, (String)"");
        FileOutputStream fout = new FileOutputStream(keyFilename);
        fout.write(prvfile.getFormattedKey());
        fout.close();
        SshPublicKeyFile pubfile = SshPublicKeyFileFactory.create((SshPublicKey)pair.getPublicKey(), (String)(type + " host key"), (int)publicKeyFormat);
        fout = new FileOutputStream(keyFilename.getAbsolutePath() + ".pub");
        fout.write(pubfile.getFormattedKey());
        fout.close();
        return pair;
    }

    public static SshKeyPair generateKey(String type, int bitLength) throws IOException, SshException {
        return SshKeyPairGenerator.generateKeyPair((String)type, (int)bitLength);
    }

    public void loadSshCertificate(File keyFile, String passphrase, File certFile) throws IOException, InvalidPassphraseException {
        SshKeyPair pair = this.loadKey(keyFile, passphrase);
        pair.setPublicKey(SshPublicKeyFileFactory.parse((InputStream)new FileInputStream(certFile)).toPublicKey());
        this.addHostKey(pair);
    }

    public void loadSshCertificate(SshCertificate cert) throws IOException, InvalidPassphraseException {
        this.addHostKey((SshKeyPair)cert);
    }

    public void setAuthenicationMechanismFactory(AuthenticationMechanismFactory<SshServerContext> authFactory) {
        this.setPolicy(AuthenticationMechanismFactory.class, authFactory);
    }

    public AuthenticationMechanismFactory<SshServerContext> getAuthenticationMechanismFactory() {
        return (AuthenticationMechanismFactory)this.getPolicy(AuthenticationMechanismFactory.class, new DefaultAuthenticationMechanismFactory());
    }

    public boolean isEnsureGracefulDisconnect() {
        return this.ensureGracefulDisconnect;
    }

    public void setEnsureGracefulDisconnect(boolean ensureGracefulDisconnect) {
        this.ensureGracefulDisconnect = ensureGracefulDisconnect;
    }

    protected synchronized void configureKeyExchanges() {
        if (Objects.nonNull(verifiedKeyExchanges)) {
            this.keyExchanges = (ComponentFactory)verifiedKeyExchanges.clone();
            return;
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing server key exchanges", (Object[])new Object[0]);
        }
        verifiedKeyExchanges = new ComponentFactory(this.componentManager);
        for (SshKeyExchangeServerFactory kex : ServiceLoader.load(SshKeyExchangeServerFactory.class, SshKeyExchangeServerFactory.class.getClassLoader())) {
            if (!this.testServerKeyExchangeAlgorithm(kex)) continue;
            verifiedKeyExchanges.add((ComponentInstanceFactory)kex);
        }
        this.keyExchanges = (ComponentFactory)verifiedKeyExchanges.clone();
    }

    private boolean testServerKeyExchangeAlgorithm(SshKeyExchangeServerFactory<? extends SshKeyExchangeServer> cls) {
        String name = cls.getKeys()[0];
        SshKeyExchange c = null;
        try {
            c = (SshKeyExchange)cls.create();
            if (!JCEComponentManager.getDefaultInstance().supportedDigests().contains(c.getHashAlgorithm())) {
                throw new Exception("Hash algorithm " + c.getHashAlgorithm() + " is not supported");
            }
            c.test();
        }
        catch (Exception e) {
            if (Log.isInfoEnabled()) {
                Log.info((String)("   " + name + " (server) will not be supported: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)("   " + name + " (server) will be supported using JCE Provider " + c.getProvider()), (Object[])new Object[0]);
        }
        return true;
    }

    public void setMaxDHGroupExchangeSize(int maxDHGroupSize) {
        this.maxDHGroupSize = maxDHGroupSize;
    }

    public int getMaxDHGroupExchangeKeySize() {
        return this.maxDHGroupSize;
    }

    public boolean isForceServerPreferences() {
        return this.forceServerPreferences;
    }

    public void setForceServerPreferences(boolean serverControlledKeyExchange) {
        this.forceServerPreferences = serverControlledKeyExchange;
    }

    static {
        globalForwardingManager.setForwardingFactory((h, p) -> RemoteForwardingChannelFactoryImpl.INSTANCE);
    }
}

