/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.WriteOperationRequest;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.SessionChannelServer;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.server.SshServerContext;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.ChannelOutputStream;
import com.sshtools.synergy.ssh.Connection;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class AgentForwardingChannel
extends ChannelNG<SshServerContext>
implements Closeable {
    PipedInputStream in = new PipedInputStream();
    PipedOutputStream out = new PipedOutputStream(this.in);
    boolean active = false;
    Object agent;
    SessionChannelServer session;
    public static final String SSH_AGENT_CLIENT = "ssh-agent";

    public AgentForwardingChannel(String type, SessionChannelServer session) throws IOException {
        this(type, session, null);
    }

    public AgentForwardingChannel(String type, SessionChannelServer session, ChannelEventListener listener) throws IOException {
        super(type, 32768, 1024000, 1024000, 65536);
        this.session = session;
        if (listener != null) {
            this.addEventListener(listener);
        }
    }

    protected void onChannelFree() {
    }

    protected byte[] createChannel() throws IOException {
        return null;
    }

    protected byte[] openChannel(byte[] requestdata) throws WriteOperationRequest, ChannelOpenException {
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void onChannelOpenConfirmation() {
        ((SshServerContext)this.getContext()).getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> clz = Class.forName("com.maverick.agent.client.SshAgentClient");
                    Constructor<?> c = clz.getConstructor(Boolean.TYPE, String.class, Closeable.class, InputStream.class, OutputStream.class, Boolean.TYPE);
                    Connection con = AgentForwardingChannel.this.getConnection();
                    AgentForwardingChannel.this.agent = c.newInstance(true, "MaverickSSHD", AgentForwardingChannel.this, AgentForwardingChannel.this.in, new ChannelOutputStream((ChannelNG)AgentForwardingChannel.this), AgentForwardingChannel.this.getChannelType().equals("auth-agent"));
                    con.setProperty(AgentForwardingChannel.SSH_AGENT_CLIENT, AgentForwardingChannel.this.agent);
                    AgentForwardingChannel.this.active = true;
                    AgentForwardingChannel.this.onAgentConnected((SshConnection)con, AgentForwardingChannel.this.agent);
                }
                catch (Exception e) {
                    Log.error((String)"Could not start agent", (Throwable)e, (Object[])new Object[0]);
                    AgentForwardingChannel.this.close();
                }
            }
        });
    }

    protected void onAgentConnected(SshConnection con, Object agent) {
    }

    protected void onChannelClosed() {
        try {
            Method m = this.agent.getClass().getMethod("close", new Class[0]);
            m.invoke(this.agent, new Object[0]);
        }
        catch (Throwable e) {
            Log.error((String)"Could not invoke close method on SshAgentClient", (Object[])new Object[0]);
        }
    }

    protected void onChannelOpen() {
    }

    protected void onChannelClosing() {
    }

    protected void onChannelRequest(String type, boolean wantreply, byte[] requestdata) {
    }

    protected void onRemoteEOF() {
    }

    protected void onLocalEOF() {
    }

    protected void onChannelData(ByteBuffer data) {
        try {
            byte[] t = new byte[data.remaining()];
            data.get(t);
            this.out.write(t);
        }
        catch (IOException e) {
            Log.error((String)"Error passing incoming data to agent InputStream", (Throwable)e, (Object[])new Object[0]);
            this.close();
        }
    }

    protected void onExtendedData(ByteBuffer data, int type) {
    }

    protected boolean checkWindowSpace() {
        throw new UnsupportedOperationException();
    }
}

