/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.jdk16;

import com.sshtools.client.SshClientContext;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.GlobalRequest;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.RemoteForwardRequestHandler;
import java.io.IOException;
import java.nio.file.Paths;

public class UnixDomainSocketRemoteForwardRequestHandler
implements RemoteForwardRequestHandler<SshClientContext> {
    public boolean isHandled(String hostToBind, int portToBind, String destinationHost, int destinationPort, ConnectionProtocol<SshClientContext> conn) {
        if (portToBind != 0 || destinationPort == 0) {
            return false;
        }
        return Paths.get(hostToBind, new String[0]).isAbsolute() && Paths.get(hostToBind, new String[0]).isAbsolute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int startRemoteForward(String hostToBind, int portToBind, String destinationHost, int destinationPort, ConnectionProtocol<SshClientContext> conn) throws SshException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(hostToBind);
            msg.writeString("");
            GlobalRequest request = new GlobalRequest("streamlocal-forward@openssh.com", (SshConnection)conn.getConnection(), msg.toByteArray());
            conn.sendGlobalRequestAndWait(request, 60000L);
            if (!request.isSuccess()) throw new SshException("Remote domain socket forwarding on interface " + hostToBind + ":" + portToBind + " failed", 14);
            if (Log.isInfoEnabled()) {
                Log.info((String)("Remote domain socket forwarding is now active on remote interface " + hostToBind + " forwarding to " + destinationHost), (Object[])new Object[0]);
            }
            int n = 0;
            return n;
        }
        catch (IOException e) {
            throw new SshException(5, (Throwable)e);
        }
    }

    public void stopRemoteForward(String hostToBind, int portToBind, String destinationHost, int destinationPort, ConnectionProtocol<SshClientContext> conn) throws SshException {
        block9: {
            try (ByteArrayWriter msg = new ByteArrayWriter();){
                msg.writeString(hostToBind);
                GlobalRequest request = new GlobalRequest("cancel-streamlocal-forward@openssh.com", (SshConnection)conn.getConnection(), msg.toByteArray());
                conn.sendGlobalRequestAndWait(request, 60000L);
                if (request.isSuccess()) {
                    if (Log.isInfoEnabled()) {
                        Log.info((String)("Remote domain socket forwarding cancelled on remote interface " + hostToBind), (Object[])new Object[0]);
                    }
                    break block9;
                }
                throw new SshException("Cancel remote domain socket forwarding on interface " + hostToBind + " failed", 14);
            }
            catch (IOException e) {
                throw new SshException(5, (Throwable)e);
            }
        }
    }
}

