/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.WriteOperationRequest;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.nio.ClientConnector;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.ssh.SocketForwardingChannel;
import com.sshtools.synergy.ssh.SshContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class LocalForwardingChannel<T extends SshContext>
extends SocketForwardingChannel<T>
implements ClientConnector {
    boolean hasConnected = false;

    public LocalForwardingChannel(String channelType, SshConnection con) {
        super(channelType, con);
    }

    public LocalForwardingChannel(String channelType, SshConnection con, String hostToConnect, int portToConnect, SocketChannel socketChannel) {
        super(channelType, con);
        this.socketChannel = socketChannel;
        this.hostToConnect = hostToConnect;
        this.portToConnect = portToConnect;
    }

    @Override
    protected byte[] createChannel() throws IOException {
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            baw.writeString(this.hostToConnect);
            baw.writeInt(this.portToConnect);
            this.originatingHost = ((InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress()).getAddress().getHostAddress();
            baw.writeString(this.originatingHost);
            this.originatingPort = ((InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress()).getPort();
            baw.writeInt(this.originatingPort);
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }

    @Override
    protected byte[] openChannel(byte[] requestdata) throws WriteOperationRequest, ChannelOpenException {
        try (ByteArrayReader bar = new ByteArrayReader(requestdata);){
            this.readForwarding(bar);
            boolean success = this.checkPermissions();
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Forwarding policy has " + (success ? "authorized" : "denied") + " " + this.connection.getUsername() + (success ? " to open" : " from opening") + " a " + this.getChannelType() + " forwarding channel to " + this.hostToConnect + ":" + this.portToConnect), (Object[])new Object[0]);
            }
            if (!success) {
                throw new ChannelOpenException("User does not have permission", 1);
            }
            this.socketChannel = this.createSocketChannel();
            if (this.socketChannel.connect(this.createSocketAddress())) {
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Local forwarding socket to {}:{} has connected channel={}", (Object[])new Object[]{this.hostToConnect, this.portToConnect, this.getLocalId()});
                }
                this.hasConnected = true;
                byte[] byArray = null;
                return byArray;
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Deferring socket connection on {}:{} channel={}", (Object[])new Object[]{this.hostToConnect, this.portToConnect, this.getLocalId()});
            }
            this.connection.getContext().getEngine().registerConnector(this, this.socketChannel);
        }
        throw new WriteOperationRequest();
    }

    protected void readForwarding(ByteArrayReader bar) throws IOException {
        this.hostToConnect = bar.readString();
        this.portToConnect = (int)bar.readInt();
        this.originatingHost = bar.readString();
        this.originatingPort = (int)bar.readInt();
    }

    protected SocketAddress createSocketAddress() {
        return new InetSocketAddress(this.hostToConnect, this.portToConnect);
    }

    protected SocketChannel createSocketChannel() throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        return socketChannel;
    }

    protected boolean checkPermissions() {
        return this.getContext().getForwardingPolicy().checkHostPermitted(this.getConnectionProtocol().getTransport().getConnection(), this.hostToConnect, this.portToConnect);
    }

    @Override
    protected synchronized void onRegistrationComplete() {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Registration Complete", (Object[])new Object[0]);
        }
    }

    @Override
    public synchronized boolean finishConnect(SelectionKey key) {
        if (this.socketChannel == null) {
            return true;
        }
        if (this.hasConnected) {
            if (Log.isWarnEnabled()) {
                Log.warn((String)"Duplicate finishConnect call to {}:{} channel={}", (Object[])new Object[]{this.hostToConnect, this.portToConnect, this.getLocalId()});
            }
            return true;
        }
        this.hasConnected = true;
        try {
            while (!this.socketChannel.finishConnect()) {
            }
            if (Log.isInfoEnabled()) {
                Log.info((String)"Local forwarding socket to {}:{} has connected channel={}", (Object[])new Object[]{this.hostToConnect, this.portToConnect, this.getLocalId()});
            }
            this.onConnectionComplete();
            this.connection.sendChannelOpenConfirmation(this, null);
        }
        catch (IOException ex) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Local forwarding socket to {}:{} has failed: {} channel={}", (Object[])new Object[]{this.hostToConnect, this.portToConnect, ex.getMessage(), this.getLocalId()});
            }
            this.onConnectionError(ex);
            this.connection.sendChannelOpenFailure(this, 2, "Connection failed.");
        }
        return true;
    }

    protected void onConnectionError(IOException ex) {
    }

    protected void onConnectionComplete() {
    }

    @Override
    protected synchronized void onChannelOpenConfirmation() {
        try {
            this.connection.getContext().getEngine().registerHandler(this, this.socketChannel);
        }
        catch (IOException ex) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Failed to register the protocol handler for local forwarding channel", (Throwable)ex, (Object[])new Object[0]);
            }
            this.close();
        }
    }

    @Override
    protected void onChannelOpenFailure() {
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void initialize(ProtocolEngine engine, SshEngine daemon, SelectableChannel channel) {
    }
}

