/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.ForwardingChannelFactory;
import com.sshtools.synergy.ssh.ForwardingFactory;
import com.sshtools.synergy.ssh.RemoteForward;
import com.sshtools.synergy.ssh.RemoteForwardRequestHandler;
import com.sshtools.synergy.ssh.SshContext;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ForwardingManager<T extends SshContext> {
    static final String REMOTE_FORWARDS_KEY = "remoteForwards";
    private ForwardingFactory<T, ForwardingChannelFactory<T>> forwardingFactory;
    private Map<Connection<T>, List<String>> portsByConnection = new HashMap<Connection<T>, List<String>>();
    private List<RemoteForwardRequestHandler<T>> remoteForwardRequestHandlers = Collections.synchronizedList(new ArrayList());
    protected Map<String, ForwardingChannelFactory<T>> listeningPorts = Collections.synchronizedMap(new HashMap());

    public ForwardingChannelFactory<T> getFactory(String addressToBind, int portToBind) {
        return this.listeningPorts.get(addressToBind + ":" + portToBind);
    }

    public ForwardingFactory<T, ForwardingChannelFactory<T>> getForwardingFactory() {
        return this.forwardingFactory;
    }

    public void setForwardingFactory(ForwardingFactory<T, ForwardingChannelFactory<T>> forwardingFactory) {
        this.forwardingFactory = forwardingFactory;
    }

    public void addRemoteForwardRequestHandler(RemoteForwardRequestHandler<T> handler) {
        this.remoteForwardRequestHandlers.add(handler);
    }

    public void removeRemoteForwardRequestHandler(RemoteForwardRequestHandler<T> handler) {
        this.remoteForwardRequestHandlers.remove(handler);
    }

    public List<RemoteForwardRequestHandler<T>> getRemoteForwardRequestHandlers() {
        return Collections.unmodifiableList(this.remoteForwardRequestHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isListening(int port) {
        Map<String, ForwardingChannelFactory<T>> map = this.listeningPorts;
        synchronized (map) {
            return this.listeningPorts.containsKey(String.valueOf(port)) || this.listeningPorts.containsKey("0.0.0.0:" + port) || this.listeningPorts.containsKey("::" + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRemoteForwarding(ConnectionProtocol<T> con) throws SshException {
        List<RemoteForwardRequestHandler<T>> list = this.remoteForwardRequestHandlers;
        synchronized (list) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Canceling all remote forwarding for connection", (Object[])new Object[0]);
            }
            SshException exception = null;
            Map remoteForwards = (Map)con.getConnection().getProperty(REMOTE_FORWARDS_KEY);
            if (remoteForwards != null) {
                for (Map.Entry m : remoteForwards.entrySet()) {
                    String[] a = ((String)m.getKey()).split(":");
                    String addressToBind = a[0];
                    int portToBind = a.length > 1 ? Integer.parseInt(a[1]) : 0;
                    for (RemoteForwardRequestHandler<T> handler : this.remoteForwardRequestHandlers) {
                        if (!handler.isHandled(addressToBind, portToBind, ((RemoteForward)m.getValue()).getHostToConnect(), ((RemoteForward)m.getValue()).getPortToConnect(), con)) continue;
                        try {
                            handler.stopRemoteForward(addressToBind, portToBind, ((RemoteForward)m.getValue()).getHostToConnect(), ((RemoteForward)m.getValue()).getPortToConnect(), con);
                        }
                        catch (SshException e) {
                            exception = e;
                        }
                    }
                }
            }
            remoteForwards.clear();
            con.getConnection().removeProperty(REMOTE_FORWARDS_KEY);
            if (exception != null) {
                throw exception;
            }
        }
    }

    public void stopRemoteForwarding(String addressToBind, int portToBind, ConnectionProtocol<T> connection) throws SshException {
        List<RemoteForwardRequestHandler<T>> list = this.remoteForwardRequestHandlers;
        synchronized (list) {
            if (Log.isInfoEnabled()) {
                Log.info((String)("Canceling remote forwarding from " + addressToBind + ":" + portToBind), (Object[])new Object[0]);
            }
            Map remoteForwards = (Map)connection.getConnection().getProperty(REMOTE_FORWARDS_KEY);
            String remoteForwardKey = addressToBind + ":" + portToBind;
            if (remoteForwards == null || !remoteForwards.containsKey(remoteForwardKey)) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("No known remote forward for " + addressToBind + ":" + portToBind), (Object[])new Object[0]);
                }
                return;
            }
            RemoteForward remoteForward = (RemoteForward)remoteForwards.get(remoteForwardKey);
            for (RemoteForwardRequestHandler<T> handler : this.remoteForwardRequestHandlers) {
                if (!handler.isHandled(addressToBind, portToBind, remoteForward.getHostToConnect(), remoteForward.getPortToConnect(), connection)) continue;
                handler.stopRemoteForward(addressToBind, portToBind, remoteForward.getHostToConnect(), remoteForward.getPortToConnect(), connection);
                remoteForwards.remove(addressToBind + ":" + portToBind);
                if (remoteForwards.isEmpty()) {
                    connection.getConnection().removeProperty(REMOTE_FORWARDS_KEY);
                }
                return;
            }
            throw new SshException(5, "Nothing handled closing the remote forward.");
        }
    }

    public int startRemoteForwarding(String addressToBind, int portToBind, String destinationHost, int destinationPort, ConnectionProtocol<T> con) throws SshException {
        List<RemoteForwardRequestHandler<T>> list = this.remoteForwardRequestHandlers;
        synchronized (list) {
            for (RemoteForwardRequestHandler<T> handler : this.remoteForwardRequestHandlers) {
                if (!handler.isHandled(addressToBind, portToBind, destinationHost, destinationPort, con)) continue;
                portToBind = handler.startRemoteForward(addressToBind, portToBind, destinationHost, destinationPort, con);
                HashMap<CallSite, RemoteForward> remoteForwards = (HashMap<CallSite, RemoteForward>)con.getConnection().getProperty(REMOTE_FORWARDS_KEY);
                if (remoteForwards == null) {
                    remoteForwards = new HashMap<CallSite, RemoteForward>();
                    con.getConnection().setProperty(REMOTE_FORWARDS_KEY, remoteForwards);
                }
                remoteForwards.put((CallSite)((Object)(addressToBind + ":" + portToBind)), new RemoteForward(destinationHost, destinationPort));
                return portToBind;
            }
            throw new SshException(5, "Nothing handled the remote forwarding request.");
        }
    }

    public synchronized int startListening(String addressToBind, int portToBind, Connection<T> con, String destinationHost, int destinationPort) throws SshException {
        block7: {
            String key = addressToBind + ":" + portToBind;
            if (portToBind > 0 && this.isListening(portToBind)) {
                throw new SshException("Port " + portToBind + " already in use", 14);
            }
            ForwardingChannelFactory<T> forwardingChannelFactory = this.forwardingFactory.createChannelFactory(destinationHost, destinationPort);
            try {
                portToBind = forwardingChannelFactory.bindInterface(addressToBind, portToBind, con.getConnectionProtocol(), forwardingChannelFactory.getChannelType());
                key = addressToBind + ":" + portToBind;
                this.listeningPorts.put(key, forwardingChannelFactory);
                if (!this.portsByConnection.containsKey(con)) {
                    this.portsByConnection.put(con, new ArrayList());
                }
                this.portsByConnection.get(con).add(key);
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, forwardingChannelFactory.getStartedEventCode(), true).addAttribute("CONNECTION", con).addAttribute("FORWARDING_TUNNEL_ENTRANCE", (Object)(addressToBind + ":" + portToBind)));
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Listening for new connections on " + addressToBind + ":" + portToBind), (Object[])new Object[0]);
                }
                return portToBind;
            }
            catch (IOException ex) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Exception caught on socket bind", (Throwable)ex, (Object[])new Object[0]);
                }
            }
            catch (Throwable t) {
                if (!Log.isDebugEnabled()) break block7;
                Log.debug((String)"Could not instantiate forwarding channel factory", (Throwable)t, (Object[])new Object[0]);
            }
        }
        throw new SshException("Failed to start listening socket on " + addressToBind + (String)(portToBind > 0 ? ":" + portToBind : ""), 14);
    }

    public void stopForwarding(Connection<T> con) {
        if (this.portsByConnection.containsKey(con)) {
            ArrayList keys = new ArrayList(this.portsByConnection.get(con));
            for (String key : keys) {
                this.stopListening(key, true, con);
            }
        }
    }

    public void stopForwarding(String key, Connection<T> con) {
        List<String> keys;
        if (this.portsByConnection.containsKey(con) && (keys = this.portsByConnection.get(con)).contains(key)) {
            this.stopListening(key, true, con);
        }
    }

    public synchronized boolean stopListening(String addressToBind, int portToBind, boolean dropActiveTunnels, Connection<T> connection) {
        String key = addressToBind + ":" + String.valueOf(portToBind);
        return this.stopListening(key, dropActiveTunnels, connection);
    }

    public synchronized boolean stopListening(String key, boolean dropActiveTunnels, Connection<T> connection) {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Forwarding cancelled for address " + key), (Object[])new Object[0]);
        }
        if (this.listeningPorts.containsKey(key)) {
            ForwardingChannelFactory<T> ff = this.listeningPorts.get(key);
            if (ff.belongsTo(connection.getConnectionProtocol())) {
                ff.stopListening(dropActiveTunnels);
                this.portsByConnection.get(connection).remove(key);
                this.listeningPorts.remove(key);
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, ff.getStoppedEventCode(), true).addAttribute("CONNECTION", connection).addAttribute("FORWARDING_TUNNEL_ENTRANCE", (Object)key));
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Stopped listening on " + key), (Object[])new Object[0]);
                }
            }
            return true;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Failed to stop listening on " + key), (Object[])new Object[0]);
        }
        return false;
    }

    public boolean startX11Forwarding(boolean singleConnection, String protocol, byte[] cookie, int screen, ConnectionProtocol<T> connection) {
        return false;
    }

    public static interface Listener {
    }
}

