/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.util.UnsignedInteger32;

public class ChannelDataWindow {
    UnsignedInteger32 maximumWindowSpace;
    UnsignedInteger32 minimumWindowSpace;
    int maximumPacketSize;
    UnsignedInteger32 windowSpace;

    public ChannelDataWindow(UnsignedInteger32 initialWindowSpace, UnsignedInteger32 maximumWindowSpace, UnsignedInteger32 minimumWindowSpace, int maximumPacketSize) {
        this.maximumWindowSpace = maximumWindowSpace;
        this.minimumWindowSpace = minimumWindowSpace;
        this.maximumPacketSize = maximumPacketSize;
        this.windowSpace = initialWindowSpace;
    }

    public synchronized void consume(long count) {
        this.windowSpace = UnsignedInteger32.deduct((UnsignedInteger32)this.windowSpace, (long)count);
    }

    public synchronized void adjust(UnsignedInteger32 count) {
        this.windowSpace = UnsignedInteger32.add((UnsignedInteger32)this.windowSpace, (UnsignedInteger32)count);
        this.notifyAll();
    }

    public synchronized UnsignedInteger32 getWindowSpace() {
        return this.windowSpace;
    }

    public synchronized boolean isAdjustRequired() {
        return this.windowSpace.longValue() < this.minimumWindowSpace.longValue();
    }

    public synchronized UnsignedInteger32 getAdjustCount() {
        return UnsignedInteger32.deduct((UnsignedInteger32)this.maximumWindowSpace, (UnsignedInteger32)this.windowSpace);
    }

    public synchronized UnsignedInteger32 getMaximumWindowSpace() {
        return this.maximumWindowSpace;
    }

    public synchronized void setMaximumWindowSpace(UnsignedInteger32 maximumWindowSpace) {
        this.maximumWindowSpace = maximumWindowSpace;
    }

    public synchronized UnsignedInteger32 getMinimumWindowSpace() {
        return this.minimumWindowSpace;
    }

    public synchronized void setMinimumWindowSpace(UnsignedInteger32 minimumWindowSpace) {
        this.minimumWindowSpace = minimumWindowSpace;
    }

    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public void setMaxiumPacketSize(int maximumPacketSize) {
        this.maximumPacketSize = maximumPacketSize;
    }

    public synchronized void close() {
        this.notifyAll();
    }
}

