/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.nio;

import com.sshtools.common.net.ProxyType;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.DefaultSocketConnectionFactory;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SocketConnectionFactory;
import java.io.IOException;
import java.util.Map;

public abstract class ProtocolContext {
    protected boolean keepAlive = false;
    protected boolean tcpNoDelay = false;
    protected boolean reuseAddress = true;
    protected int receiveBufferSize = 0;
    protected int sendBufferSize = 0;
    private String proxyHostname;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private boolean resolveLocally;
    private String userAgent;
    private Map<String, String> optionalHeaders;
    private ProxyType proxyType = ProxyType.NONE;
    private SocketConnectionFactory socketConnectionFactory = new DefaultSocketConnectionFactory();

    protected abstract ProtocolEngine createEngine(ConnectRequestFuture var1) throws IOException;

    public boolean getSocketOptionKeepAlive() {
        return this.keepAlive;
    }

    public boolean getSocketOptionReuseAddress() {
        return this.reuseAddress;
    }

    public void setSocketOptionReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public void setSocketOptionKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean getSocketOptionTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setSocketOptionTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public SocketConnectionFactory getSocketConnectionFactory() {
        return this.socketConnectionFactory;
    }

    public void setSocketConnectionFactory(SocketConnectionFactory socketConnectionFactory) {
        this.socketConnectionFactory = socketConnectionFactory;
    }

    public abstract void shutdown();

    public void enableSocks4Proxy(String proxyHostname, int proxyPort, String proxyUsername) {
        this.proxyType = ProxyType.SOCKS4;
        this.proxyHostname = proxyHostname;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
    }

    public void enableSocks5Proxy(String proxyHostname, int proxyPort, String proxyUsername, String proxyPassword, boolean localLookup) {
        this.proxyType = ProxyType.SOCKS5;
        this.proxyHostname = proxyHostname;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.resolveLocally = localLookup;
    }

    public void enableHTTPProxy(String proxyHostname, int proxyPort) {
        this.enableHTTPProxy(proxyHostname, proxyPort, null, null, null, null);
    }

    public void enableHTTPProxy(String proxyHostname, int proxyPort, String proxyUsername, String proxyPassword) {
        this.enableHTTPProxy(proxyHostname, proxyPort, proxyUsername, proxyPassword, null, null);
    }

    public void enableHTTPProxy(String proxyHostname, int proxyPort, String proxyUsername, String proxyPassword, String userAgent) {
        this.enableHTTPProxy(proxyHostname, proxyPort, proxyUsername, proxyPassword, userAgent, null);
    }

    public void enableHTTPProxy(String proxyHostname, int proxyPort, String proxyUsername, String proxyPassword, String userAgent, Map<String, String> optionalHeaders) {
        this.proxyType = ProxyType.HTTP;
        this.proxyHostname = proxyHostname;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.userAgent = userAgent;
        this.optionalHeaders = optionalHeaders;
    }

    public boolean isProxyEnabled() {
        return this.proxyType != ProxyType.NONE;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public boolean isResolveLocally() {
        return this.resolveLocally;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Map<String, String> getOptionalHeaders() {
        return this.optionalHeaders;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }
}

