/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.nio;

import com.sshtools.common.logger.Log;
import com.sshtools.synergy.nio.ClientAcceptor;
import com.sshtools.synergy.nio.SelectorThread;
import com.sshtools.synergy.nio.SelectorThreadImpl;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;

public class SelectorThreadPool {
    SelectorThreadImpl impl;
    ArrayList<SelectorThread> threads = new ArrayList();
    int permanentThreads;
    int maximumChannels;
    int nextAvailable;
    int idleServicePeriod;
    int inactivePeriodsPerIdleEvent;
    SelectorProvider selectorProvider;
    boolean isShuttingDown = false;
    boolean verbose = Boolean.getBoolean("maverick.verbose");

    public SelectorThreadPool(SelectorThreadImpl impl, int permanentThreads, int maximumChannels, int idleServicePeriod, int inactivePeriodsPerIdleEvent, SelectorProvider selectorProvider) throws IOException {
        this.impl = impl;
        this.permanentThreads = permanentThreads;
        this.maximumChannels = maximumChannels;
        this.idleServicePeriod = idleServicePeriod;
        this.inactivePeriodsPerIdleEvent = inactivePeriodsPerIdleEvent;
        this.selectorProvider = selectorProvider;
        if (this.verbose && Log.isDebugEnabled()) {
            Log.debug((String)("Creating " + impl.getName() + " thread pool with " + permanentThreads + " permanent threads each with a maximum of " + maximumChannels + " channels"), (Object[])new Object[0]);
        }
        for (int i = 0; i < permanentThreads; ++i) {
            this.createThread();
        }
        this.nextAvailable = 0;
    }

    public void closeAllChannels() {
        this.isShuttingDown = true;
        for (SelectorThread t : this.threads) {
            t.closeAllChannels();
        }
    }

    public synchronized void shutdown() {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Shutting down {} thread pool", (Object[])new Object[]{this.impl.getName()});
        }
        this.isShuttingDown = true;
        for (SelectorThread t : this.threads) {
            t.shutdown();
        }
        this.threads.clear();
    }

    void removeThread(SelectorThread thread) {
        if (!this.isShuttingDown) {
            this.threads.remove(thread);
            if (thread.isPermanent()) {
                try {
                    this.createThread();
                    if (Log.isWarnEnabled()) {
                        Log.warn((String)"A permanent thread was re-created because {} shutdown", (Object[])new Object[]{thread.getName()});
                    }
                }
                catch (IOException e) {
                    Log.error((String)"Failed to create replacement thread", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
    }

    private synchronized SelectorThread createThread() throws IOException {
        SelectorThread thread = new SelectorThread(this, this.impl, this.threads.size() < this.permanentThreads, this.maximumChannels, this.threads.size() + 1, this.idleServicePeriod, this.inactivePeriodsPerIdleEvent, this.selectorProvider);
        this.threads.add(thread);
        thread.start();
        return thread;
    }

    public synchronized int getCurrentLoad() {
        int count = 0;
        for (int i = 0; i < this.threads.size(); ++i) {
            SelectorThread t = this.threads.get(i);
            count += t.getThreadLoad();
        }
        return count;
    }

    public synchronized SelectorThread selectNextThread() throws IOException {
        SelectorThread t;
        int index = -1;
        int highestAvailableLoad = 0;
        for (int i = 0; i < this.threads.size(); ++i) {
            t = this.threads.get(i);
            int currentThreadsAvailableLoad = t.getMaximumLoad() - t.getThreadLoad();
            if (currentThreadsAvailableLoad == t.getMaximumLoad()) {
                if (this.verbose && Log.isDebugEnabled()) {
                    Log.debug((String)("An idle thread has been selected id=" + t.getSelectorId()), (Object[])new Object[0]);
                }
                return t;
            }
            if (this.verbose && Log.isDebugEnabled()) {
                Log.debug((String)("Thread id " + t.getSelectorId() + " has a current load of " + t.getThreadLoad() + " channels"), (Object[])new Object[0]);
            }
            if (currentThreadsAvailableLoad <= 0 || currentThreadsAvailableLoad <= highestAvailableLoad) continue;
            highestAvailableLoad = currentThreadsAvailableLoad;
            index = i;
        }
        if (index > -1) {
            t = this.threads.get(index);
            if (this.verbose && Log.isDebugEnabled()) {
                Log.debug((String)("Existing thread id " + t.getSelectorId() + " selected with current load of " + t.getThreadLoad() + " channels"), (Object[])new Object[0]);
            }
            return this.threads.get(index);
        }
        if (this.verbose && Log.isDebugEnabled()) {
            Log.debug((String)"All threads are at maximum capacity", (Object[])new Object[0]);
        }
        return this.createThread();
    }

    public void register(ServerSocketChannel socketChannel, int ops, ClientAcceptor acceptor, boolean wakeup) throws ClosedChannelException {
        for (SelectorThread t : this.threads) {
            if (!t.isPermanent()) continue;
            t.register(socketChannel, ops, acceptor, wakeup);
        }
    }
}

