/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.nio;

import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.IdleStateManager;
import com.sshtools.synergy.nio.SelectionKeyAware;
import com.sshtools.synergy.nio.SelectorRegistrationListener;
import com.sshtools.synergy.nio.SelectorThreadImpl;
import com.sshtools.synergy.nio.SelectorThreadPool;
import com.sshtools.synergy.nio.SocketConnection;
import com.sshtools.synergy.nio.SocketHandler;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class SelectorThread
extends Thread {
    Selector selector;
    boolean running;
    LinkedList<Registration> pendingRegistrations;
    LinkedList<Runnable> pendingOperations;
    int maximumNumOfChannels;
    SelectorThreadImpl impl;
    SelectorThreadPool pool;
    boolean isPermanent;
    int id;
    static final int MAX_INACTIVITY = 1000;
    Object shutdownLock = new Object();
    SelectorProvider selectorProvider;
    IdleStateManager idleStates;
    boolean hasOperations = false;

    public SelectorThread(SelectorThreadPool pool, SelectorThreadImpl impl, boolean isPermanent, int maximumNumOfChannels, int id, int idleServicePeriod, int inactivePeriodsPerIdleEvent, SelectorProvider selectorProvider) throws IOException {
        this.pool = pool;
        this.impl = impl;
        this.isPermanent = isPermanent;
        this.id = id;
        this.maximumNumOfChannels = maximumNumOfChannels;
        this.selectorProvider = selectorProvider;
        this.idleStates = new IdleStateManager(idleServicePeriod, inactivePeriodsPerIdleEvent);
        this.pendingRegistrations = new LinkedList();
        this.pendingOperations = new LinkedList();
        this.openSelector();
        this.setName(impl.getName() + "-" + id);
        this.setDaemon(true);
    }

    private void openSelector() throws IOException {
        if (this.selector != null) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Opening new selector and transferring " + this.selector.keys().size() + " keys"), (Object[])new Object[0]);
            }
            AbstractSelector newSelector = this.selectorProvider.openSelector();
            for (SelectionKey key : this.selector.keys()) {
                if (key.isValid()) {
                    SelectionKey newKey = key.channel().register(newSelector, key.interestOps());
                    newKey.attach(key.attachment());
                    if (newKey.attachment() instanceof SelectionKeyAware) {
                        ((SelectionKeyAware)newKey.attachment()).setSelectionKey(newKey);
                    }
                }
                key.cancel();
            }
            try {
                this.selector.select(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.selector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.selector = newSelector;
        } else {
            this.selector = this.selectorProvider.openSelector();
        }
    }

    IdleStateManager getIdleStates() {
        return this.idleStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean register(SelectableChannel sc, int ops, Object attachment, boolean wakeUp) throws ClosedChannelException {
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Adding registration request to queue", (Object[])new Object[0]);
        }
        LinkedList<Registration> linkedList = this.pendingRegistrations;
        synchronized (linkedList) {
            this.pendingRegistrations.addLast(new Registration(sc, ops, attachment));
        }
        if (wakeUp) {
            this.selector.wakeup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performPendingRegistrations() {
        if (this.pendingRegistrations.isEmpty()) return false;
        boolean bl = true;
        boolean hasRegistrations = bl;
        if (!hasRegistrations) {
            return false;
        }
        LinkedList<Registration> linkedList = this.pendingRegistrations;
        synchronized (linkedList) {
            while (!this.pendingRegistrations.isEmpty()) {
                try {
                    Registration reg = this.pendingRegistrations.removeFirst();
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)("Registering channel with interested ops " + reg.getInterestedOps()), (Object[])new Object[0]);
                    }
                    if (reg.getChannel().isOpen()) {
                        if (Log.isTraceEnabled()) {
                            Log.trace((String)"Channel is open", (Object[])new Object[0]);
                        }
                        SelectionKey key = reg.getChannel().register(this.selector, reg.getInterestedOps(), reg.getAttachment());
                        if (Log.isTraceEnabled()) {
                            Log.trace((String)"Channel is registered", (Object[])new Object[0]);
                        }
                        if (reg.getAttachment() instanceof SelectorRegistrationListener) {
                            ((SocketHandler)reg.getAttachment()).registrationCompleted(reg.getChannel(), key, this);
                        }
                        if (!Log.isTraceEnabled()) continue;
                        Log.trace((String)"Registration complete", (Object[])new Object[0]);
                        continue;
                    }
                    if (!Log.isTraceEnabled()) continue;
                    Log.trace((String)"Cannot register channel because it is closed!", (Object[])new Object[0]);
                }
                catch (IOException ex) {
                    if (!Log.isTraceEnabled()) continue;
                    Log.trace((String)"Failed to register channel as it is closed", (Object[])new Object[0]);
                }
            }
            return hasRegistrations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllChannels() {
        if (Log.isTraceEnabled()) {
            Log.trace((String)(this.getName() + " closing all channels"), (Object[])new Object[0]);
        }
        for (SelectionKey key : new ArrayList<SelectionKey>(this.selector.keys())) {
            Object obj = key.attachment();
            if (obj instanceof SocketConnection) {
                try {
                    ((SocketConnection)obj).socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ((SocketConnection)obj).protocolEngine.onSocketClose();
            }
            SelectableChannel channel = key.channel();
            try {
                SelectableChannel selectableChannel = channel;
                synchronized (selectableChannel) {
                    if (channel.isOpen()) {
                        channel.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                key.cancel();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectorOperation(Runnable r) {
        LinkedList<Runnable> linkedList = this.pendingOperations;
        synchronized (linkedList) {
            this.pendingOperations.addLast(r);
            this.hasOperations = true;
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performPendingOperations() {
        if (!this.hasOperations) {
            return false;
        }
        boolean hasRemaining = false;
        LinkedList ops = null;
        LinkedList<Runnable> linkedList = this.pendingOperations;
        synchronized (linkedList) {
            if (!this.pendingOperations.isEmpty()) {
                hasRemaining = true;
                ops = (LinkedList)this.pendingOperations.clone();
                this.pendingOperations.clear();
                this.hasOperations = false;
            }
        }
        if (ops != null) {
            while (!ops.isEmpty()) {
                Runnable r = (Runnable)ops.removeFirst();
                try {
                    r.run();
                }
                catch (Throwable t) {
                    if (!Log.isErrorEnabled()) continue;
                    Log.error((String)"Consumed exception in pending operation", (Throwable)t, (Object[])new Object[0]);
                }
            }
        }
        return hasRemaining;
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public synchronized int getThreadLoad() {
        return this.selector.keys().size() + this.pendingRegistrations.size();
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public void flagShutdown() {
        this.running = false;
        if (!Thread.currentThread().equals(this)) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Waiting for " + this.getName() + " to shutdown"), (Object[])new Object[0]);
            }
            this.flagShutdown();
            try {
                this.shutdownLock.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)(this.getName() + " has shutdown"), (Object[])new Object[0]);
            }
        }
    }

    public int getSelectorId() {
        return this.id;
    }

    public int getMaximumLoad() {
        return this.maximumNumOfChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.running = true;
            int n = 0;
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Starting " + (this.isPermanent ? "permanent " : "temporary ") + this.impl.getName() + " thread id=" + this.id), (Object[])new Object[0]);
            }
            long tmpTime = System.currentTimeMillis();
            boolean simulateEpollBug = Boolean.getBoolean("maverick.simulateEpollBug");
            boolean workaroundEpollBug = Boolean.getBoolean("maverick.workaroundEpollBug");
            int numberOfZeroSelects = 0;
            while (this.running) {
                try {
                    this.performPendingOperations();
                    try {
                        if (!workaroundEpollBug) {
                            n = this.selector.select(1000L);
                        } else {
                            long lastSelectStarted = System.currentTimeMillis();
                            n = this.selector.select(1000L);
                            if (n == 0 && System.currentTimeMillis() - lastSelectStarted < 100L) {
                                if (++numberOfZeroSelects > 10) {
                                    this.openSelector();
                                    continue;
                                }
                            } else {
                                numberOfZeroSelects = 0;
                            }
                            if (simulateEpollBug && System.currentTimeMillis() - tmpTime > 60000L) {
                                this.openSelector();
                                tmpTime = System.currentTimeMillis();
                                continue;
                            }
                        }
                    }
                    catch (Exception csx) {
                        if (this.selector.isOpen()) continue;
                        csx.printStackTrace();
                        if (!Log.isTraceEnabled()) break;
                        Log.trace((String)"Failed to select", (Throwable)csx, (Object[])new Object[0]);
                        break;
                    }
                    if (this.idleStates.isReady()) {
                        this.idleStates.service();
                    }
                    this.performPendingOperations();
                    this.performPendingRegistrations();
                    if (n == 0) {
                        if (this.selector.keys().size() != 0 || this.pendingRegistrations.size() != 0 || this.isPermanent) continue;
                        this.flagShutdown();
                        continue;
                    }
                    Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                    while (it.hasNext()) {
                        SelectionKey key = it.next();
                        it.remove();
                        if (!key.isValid()) {
                            if (!Log.isTraceEnabled()) continue;
                            Log.trace((String)"Selector is not valid", (Object[])new Object[0]);
                            continue;
                        }
                        if (Log.isTraceEnabled()) {
                            Log.trace((String)"Selected key", (Object[])new Object[0]);
                        }
                        this.impl.processSelectionKey(key, this);
                    }
                }
                catch (Throwable ex) {
                    if (!Log.isErrorEnabled()) continue;
                    Log.error((String)"Selector thread encountered an error", (Throwable)ex, (Object[])new Object[0]);
                }
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Shutting down " + (this.isPermanent ? "permanent " : "temporary ") + this.impl.getName() + " thread id=" + this.id), (Object[])new Object[0]);
            }
            this.pool.removeThread(this);
            this.closeAllChannels();
            try {
                if (Log.isTraceEnabled()) {
                    Log.trace((String)(this.impl.getName() + " performing final select to cancel all keys"), (Object[])new Object[0]);
                }
                this.selector.select(50L);
                if (Log.isTraceEnabled()) {
                    Log.trace((String)(this.impl.getName() + " completed final select"), (Object[])new Object[0]);
                }
            }
            catch (Throwable t) {
                if (Log.isTraceEnabled()) {
                    Log.trace((String)(this.impl.getName() + " exception occured in final select"), (Throwable)t, (Object[])new Object[0]);
                }
            }
        }
        finally {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {}
            Object object = this.shutdownLock;
            synchronized (object) {
                this.shutdownLock.notifyAll();
            }
        }
    }

    public void cancelKey(SelectionKey key) {
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Selection key is being cancelled", (Object[])new Object[0]);
        }
        key.cancel();
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Cancelled key", (Object[])new Object[0]);
        }
    }

    class Registration {
        SelectableChannel channel;
        int interestedOps;
        Object attachment;

        Registration(SelectableChannel channel, int interestedOps, Object attachment) {
            this.channel = channel;
            this.interestedOps = interestedOps;
            this.attachment = attachment;
        }

        public SelectableChannel getChannel() {
            return this.channel;
        }

        public int getInterestedOps() {
            return this.interestedOps;
        }

        public Object getAttachment() {
            return this.attachment;
        }
    }
}

