/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventListener;
import com.sshtools.common.logger.FileLoggingContext;
import com.sshtools.common.logger.Log;
import com.sshtools.common.logger.LoggerContext;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.Utils;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionManager;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class ConnectionLoggingContext
implements LoggerContext,
EventListener {
    Log.Level defaultLevel;
    Map<SshConnection, FileLoggingContext> activeLoggers = new HashMap<SshConnection, FileLoggingContext>();
    ConnectionManager<?> cm;

    ConnectionLoggingContext(Log.Level level, ConnectionManager<?> cm) {
        this.defaultLevel = level;
        this.cm = cm;
    }

    public boolean isLogging(Log.Level level) {
        SshConnection currentConnection = this.cm.getCurrentConnection();
        if (this.activeLoggers.containsKey(currentConnection)) {
            return this.activeLoggers.get(currentConnection).getLevel().ordinal() >= level.ordinal();
        }
        return false;
    }

    public void log(Log.Level level, String msg, Throwable e, Object ... args) {
        FileLoggingContext ctx;
        SshConnection currentConnection = this.cm.getCurrentConnection();
        if (!Objects.isNull(currentConnection) && !Objects.isNull(ctx = this.activeLoggers.get(currentConnection))) {
            ctx.log(level, msg, e, args);
        }
    }

    private boolean isLoggingRemoteAddress(SshConnection con) {
        return this.lookup(".remoteAddr", con.getRemoteAddress().getHostAddress(), con);
    }

    private boolean isLoggingLocalAddress(SshConnection con) {
        return this.lookup(".localAddr", con.getLocalAddress().getHostAddress(), con);
    }

    private boolean isLoggingRemotePort(SshConnection con) {
        return this.lookup(".remotePort", String.valueOf(con.getRemotePort()), con);
    }

    private boolean isLoggingLocalPort(SshConnection con) {
        return this.lookup(".localPort", String.valueOf(con.getLocalPort()), con);
    }

    private boolean lookup(String key, String value, SshConnection con) {
        String v = this.getProperty(key, "");
        if ("".equals(v)) {
            return true;
        }
        HashSet<String> addr = new HashSet<String>(Arrays.asList(v.split(",")));
        return addr.isEmpty() || addr.contains(value);
    }

    public void open(Connection<?> con) throws IOException {
        con.addEventListener(this);
        if (this.isLoggingConnection(con)) {
            this.startLogging(con);
        }
    }

    public void startLogging(SshConnection con) throws IOException {
        this.startLogging(con, Log.Level.valueOf((String)this.getProperty(".level", this.defaultLevel.name())));
    }

    public void startLogging(SshConnection con, Log.Level level) throws IOException {
        if (this.activeLoggers.containsKey(con)) {
            return;
        }
        String filenameFormat = this.getProperty(".filenameFormat", "${timestamp}__${uuid}.log");
        Integer maxFiles = Integer.parseInt(this.getProperty(".maxFiles", "10"));
        Long maxSize = IOUtils.fromByteSize((String)this.getProperty(".maxSize", "20MB"));
        String defaultTimestamp = this.getProperty(".timestampFormat", "yyyy-MM-dd-HH-mm-ss-SSS");
        String filename = filenameFormat.replace("${timestamp}", LocalDateTime.now().format(DateTimeFormatter.ofPattern(this.getProperty(this.getPropertyKey(".timestampPattern"), defaultTimestamp)))).replace("${uuid}", con.getUUID()).replace("${remotePort}", String.valueOf(con.getRemotePort())).replace("${remoteAddr}", con.getRemoteAddress().getHostAddress()).replace("${localPort}", String.valueOf(con.getLocalPort())).replace("${localAddr}", con.getLocalAddress().getHostAddress()).replace("${ident}", Utils.defaultString((String)con.getRemoteIdentification().trim(), (String)"")).replace("${user}", Utils.defaultString((String)con.getUsername(), (String)""));
        this.activeLoggers.put(con, new FileLoggingContext(level, new File(filename), maxFiles.intValue(), maxSize.longValue()));
    }

    private boolean isLoggingConnection(Connection<?> con) {
        if (!"true".equalsIgnoreCase(Log.getDefaultContext().getProperty(this.getPropertyKey(""), String.valueOf(!this.defaultLevel.equals((Object)Log.Level.NONE))))) {
            return false;
        }
        return this.isLoggingRemoteAddress(con) && this.isLoggingRemotePort(con) && this.isLoggingLocalAddress(con) && this.isLoggingLocalPort(con) && this.isLoggingIdentifier(con) && this.isLoggingUser(con);
    }

    private boolean isLoggingUser(Connection<?> con) {
        String v = this.getProperty(".user", "");
        if ("".equals(v)) {
            return true;
        }
        HashSet<String> users = new HashSet<String>(Arrays.asList(v.split(",")));
        if (!Objects.isNull(con.getUsername())) {
            return users.contains(con.getUsername());
        }
        return users.isEmpty();
    }

    private boolean isLoggingIdentifier(Connection<?> con) {
        String v = this.getProperty(".ident", "");
        if ("".equals(v)) {
            return true;
        }
        if (v.startsWith("SSH-2.0-")) {
            v = v.substring(8);
        }
        HashSet<String> identifications = new HashSet<String>(Arrays.asList(v.split(",")));
        if (con.getRemoteIdentification().length() > 0) {
            for (String ident : identifications) {
                if (!con.getRemoteIdentification().contains(ident)) continue;
                return true;
            }
            return false;
        }
        return identifications.isEmpty();
    }

    private String getProperty(String key, String defaultValue) {
        defaultValue = Log.getDefaultContext().getProperty(String.format("maverick.log.connection%s", key), defaultValue);
        return Log.getDefaultContext().getProperty(this.getPropertyKey(key), defaultValue);
    }

    private String getPropertyKey(String key) {
        return String.format("maverick.log.connection.%s%s", this.cm.getName(), key);
    }

    public void close(Connection<?> con) {
        FileLoggingContext ctx = this.activeLoggers.remove(con);
        if (!Objects.isNull(ctx)) {
            ctx.close();
        }
    }

    public void raw(Log.Level level, String msg) {
        FileLoggingContext ctx;
        SshConnection currentConnection = this.cm.getCurrentConnection();
        if (!Objects.isNull(currentConnection) && !Objects.isNull(ctx = this.activeLoggers.get(currentConnection))) {
            ctx.raw(level, msg);
        }
    }

    public void close() {
    }

    public void newline() {
        FileLoggingContext ctx;
        SshConnection currentConnection = this.cm.getCurrentConnection();
        if (!Objects.isNull(currentConnection) && !Objects.isNull(ctx = this.activeLoggers.get(currentConnection))) {
            ctx.newline();
        }
    }

    public void processEvent(Event evt) {
        switch (evt.getId()) {
            case -16777206: 
            case -16777197: {
                Connection con = (Connection)evt.getAttribute("CONNECTION");
                if (this.activeLoggers.containsKey(con) || !this.isLoggingConnection(con)) break;
                try {
                    this.startLogging(con);
                }
                catch (IOException iOException) {}
                break;
            }
        }
    }
}

