/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.IdleStateListener;
import com.sshtools.common.nio.WriteOperationRequest;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.ChannelRequestFuture;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.synergy.ssh.CachingDataWindow;
import com.sshtools.synergy.ssh.ChannelDataWindow;
import com.sshtools.synergy.ssh.ChannelOutputStream;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.TransportProtocol;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ChannelNG<T extends SshContext>
implements Channel {
    static final int CHANNEL_UNINITIALIZED = 0;
    static final int CHANNEL_OPEN = 1;
    static final int CHANNEL_CLOSED = 2;
    long lastActivity = System.currentTimeMillis();
    int timeout = 0;
    protected ConnectionProtocol<T> connection;
    String channeltype;
    int channelid;
    int remoteid;
    protected ChannelDataWindow localWindow;
    protected ChannelDataWindow remoteWindow;
    protected CachingDataWindow cache;
    AtomicBoolean isLocalEOF = new AtomicBoolean();
    AtomicBoolean isRemoteEOF = new AtomicBoolean();
    AtomicBoolean sentEOF = new AtomicBoolean();
    AtomicBoolean sentClose = new AtomicBoolean();
    AtomicBoolean receivedClose = new AtomicBoolean();
    AtomicBoolean completedClose = new AtomicBoolean();
    AtomicBoolean haltIncomingData = new AtomicBoolean();
    int state = 0;
    Vector<ChannelEventListener> eventListeners = new Vector();
    ChannelRequestFuture openFuture = new ChannelRequestFuture();
    LinkedList<ChannelRequestFuture> requests = new LinkedList();
    ChannelRequestFuture closeFuture;
    protected SshConnection con;
    private ChannelInputStream channelIn;
    private ChannelOutputStream channelOut = new ChannelOutputStream(this);
    static int sequence = 0;

    public ChannelNG(String channelType, int maximumPacketSize, int initialWindowSize, int maximumWindowSpace, int minimumWindowSpace, ChannelRequestFuture closeFuture, boolean autoConsume) {
        this.channeltype = channelType;
        this.localWindow = new ChannelDataWindow(initialWindowSize, maximumWindowSpace, minimumWindowSpace, maximumPacketSize);
        ChannelRequestFuture channelRequestFuture = this.closeFuture = closeFuture != null ? closeFuture : new ChannelRequestFuture();
        if (!autoConsume) {
            this.cache = this.createCache(maximumWindowSpace);
        }
    }

    protected CachingDataWindow createCache(int maximumWindowSpace) {
        return new CachingDataWindow(maximumWindowSpace, true);
    }

    public InputStream getInputStream() {
        if (Objects.nonNull(this.channelIn)) {
            return this.channelIn;
        }
        if (Objects.isNull(this.cache)) {
            throw new IllegalStateException("Channel is configured to auto consume input, therefore, ChannelInputStream is not available");
        }
        this.channelIn = new ChannelInputStream(this.cache);
        return this.channelIn;
    }

    public OutputStream getOutputStream() {
        return this.channelOut;
    }

    public ChannelNG(String channelType, int maximumPacketSize, int initialWindowSize, int maximumWindowSpace, int minimumWindowSpace) {
        this(channelType, maximumPacketSize, initialWindowSize, maximumWindowSpace, minimumWindowSpace, new ChannelRequestFuture(), false);
    }

    public boolean isClosed() {
        return this.state == 2;
    }

    public boolean isConnected() {
        return !this.isClosed();
    }

    public int getMaxiumRemoteWindowSize() {
        return this.remoteWindow.getMaximumWindowSpace();
    }

    public int getMaxiumRemotePacketSize() {
        return this.remoteWindow.getMaximumPacketSize();
    }

    void init(ConnectionProtocol<T> connection) {
        this.connection = connection;
        this.con = connection.getConnection();
    }

    public void resetIdleState(IdleStateListener listener) {
        this.connection.transport.getSocketConnection().getIdleStates().register(listener);
    }

    public void clearIdleState(IdleStateListener listener) {
        this.connection.transport.getSocketConnection().getIdleStates().remove(listener);
    }

    public void addEventListener(ChannelEventListener listener) {
        if (listener != null) {
            this.eventListeners.add(listener);
        }
    }

    public String getChannelType() {
        return this.channeltype;
    }

    public ChannelRequestFuture getOpenFuture() {
        return this.openFuture;
    }

    public ChannelRequestFuture getCloseFuture() {
        return this.closeFuture;
    }

    public int getRemoteWindow() {
        return this.remoteWindow.getWindowSpace();
    }

    public int getLocalWindow() {
        return this.localWindow.getWindowSpace();
    }

    public int getLocalPacket() {
        return this.localWindow.getMaximumPacketSize();
    }

    public int getRemotePacket() {
        return this.remoteWindow.getMaximumPacketSize();
    }

    public int getLocalId() {
        return this.channelid;
    }

    public int getRemoteId() {
        return this.remoteid;
    }

    byte[] open(int channelid, int remoteid, int remotepacket, int remotewindow, byte[] requestdata) throws WriteOperationRequest, ChannelOpenException {
        this.channelid = channelid;
        this.remoteid = remoteid;
        this.remoteWindow = new ChannelDataWindow(remotewindow, remotewindow, 0, remotepacket);
        return this.openChannel(requestdata);
    }

    void confirmOpen() {
        this.state = 1;
        this.openFuture.done(true);
        this.onChannelOpenConfirmation();
        for (ChannelEventListener listener : this.eventListeners) {
            listener.onChannelOpen((Channel)this);
        }
    }

    void confirmOpen(int remoteid, int remotewindow, int remotepacket) {
        this.remoteid = remoteid;
        this.remoteWindow = new ChannelDataWindow(remotewindow, remotewindow, 0, remotepacket);
        this.confirmOpen();
    }

    public String getSessionIdentifier() {
        return this.connection.getSessionIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustWindow(int count) {
        this.remoteWindow.adjust(count);
        ChannelNG channelNG = this;
        synchronized (channelNG) {
            this.notifyAll();
        }
        this.onWindowAdjust(count);
        for (ChannelEventListener listener : this.eventListeners) {
            listener.onWindowAdjust((Channel)this, (long)this.remoteWindow.getWindowSpace());
        }
    }

    protected void registerExtendedDataType(Integer type) {
    }

    protected void onWindowAdjust(int count) {
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Connection<T> getConnection() {
        return this.connection.getConnection();
    }

    public ConnectionProtocol<T> getConnectionProtocol() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consumeWindowSpace(int length) throws IOException {
        ChannelDataWindow channelDataWindow = this.localWindow;
        synchronized (channelDataWindow) {
            if (this.localWindow.getWindowSpace() < length) {
                throw new IOException("Data length of " + String.valueOf(length) + " bytes exceeded available window space of " + String.valueOf(this.localWindow.getWindowSpace()) + " bytes.");
            }
            if (Log.isTraceEnabled()) {
                this.log("Consuming", length + " bytes local window space before=" + this.localWindow.getWindowSpace() + " after=" + (this.localWindow.getWindowSpace() - length));
            }
            this.localWindow.consume(length);
        }
    }

    protected void onChannelData(ByteBuffer data) {
        for (ChannelEventListener listener : this.eventListeners) {
            listener.onChannelDataIn((Channel)this, data);
        }
        if (Objects.nonNull(this.cache)) {
            this.cache.put(data);
        }
    }

    void processChannelData(ByteBuffer data) throws IOException {
        this.lastActivity = System.currentTimeMillis();
        this.consumeWindowSpace(data.remaining());
        if (Log.isDebugEnabled()) {
            this.log("Received", String.format("SSH_MSG_CHANNEL_DATA len=%d", data.remaining()));
        }
        this.onChannelData(data);
    }

    public void sendChannelDataAndBlock(byte[] data) throws IOException {
        this.sendChannelDataAndBlock(data, null);
    }

    public void sendChannelDataAndBlock(byte[] data, Runnable r) throws IOException {
        this.sendChannelDataAndBlock(data, 0, data.length, r);
    }

    public void sendData(byte[] data, int off, int len) throws IOException {
        this.sendChannelDataAndBlock(data, off, len, null);
    }

    public void sendChannelDataAndBlock(byte[] data, int off, int len, Runnable r) throws IOException {
        this.lastActivity = System.currentTimeMillis();
        this.sendChannelDataAndBlock(ByteBuffer.wrap(data, off, len), r);
    }

    public void sendChannelDataAndBlock(ByteBuffer buf) throws IOException {
        this.sendChannelDataAndBlock(buf, 0, null);
    }

    public void sendChannelDataAndBlock(ByteBuffer buf, Runnable r) throws IOException {
        this.sendChannelDataAndBlock(buf, 0, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChannelDataAndBlock(ByteBuffer buf, int type, Runnable r) throws IOException {
        if (this.getConnectionProtocol().getTransport().getSocketConnection().isSelectorThread()) {
            throw new IllegalStateException("You appear to be calling sendChannelData on a selector thread. Use TransportProtocol.addOutgoingTask to place on the outgoing message queue.");
        }
        this.lastActivity = System.currentTimeMillis();
        ChannelData lastMessage = null;
        if (Log.isTraceEnabled()) {
            Log.debug((String)"Queue Buffer rem={} pos={} limit={} capacity={}", (Object[])new Object[]{buf.remaining(), buf.position(), buf.limit(), buf.capacity()});
        }
        ChannelNG channelNG = this;
        synchronized (channelNG) {
            do {
                if (this.isLocalEOF.get() || this.isClosed()) {
                    throw new IOException("Channel has been closed");
                }
                int count = Math.min(this.remoteWindow.getMaximumPacketSize(), Math.min(this.remoteWindow.getWindowSpace(), buf.remaining()));
                if (count == 0) {
                    if (Log.isDebugEnabled()) {
                        this.log("Waiting", String.format("for %d bytes of remote window", buf.remaining()));
                    }
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.remoteWindow.consume(count);
                if (buf.remaining() > count) {
                    ByteBuffer processedBuffer = buf.slice();
                    processedBuffer.limit(count);
                    buf.position(buf.position() + count);
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)"Sliced Buffer rem={} pos={} limit={} capacity={}", (Object[])new Object[]{processedBuffer.remaining(), processedBuffer.position(), processedBuffer.limit(), processedBuffer.capacity()});
                    }
                    for (ChannelEventListener listener : this.eventListeners) {
                        listener.onChannelDataOut((Channel)this, processedBuffer);
                    }
                    this.connection.sendMessage(new ChannelData(processedBuffer, type, this.remoteWindow.getWindowSpace()));
                    continue;
                }
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Final Buffer rem={} pos={} limit={}, capacity={}", (Object[])new Object[]{buf.remaining(), buf.position(), buf.limit(), buf.capacity()});
                }
                for (ChannelEventListener listener : this.eventListeners) {
                    listener.onChannelDataOut((Channel)this, buf);
                }
                lastMessage = new ChannelData(buf, type, this.remoteWindow.getWindowSpace());
                this.connection.sendMessage(lastMessage);
            } while (Objects.isNull(lastMessage));
        }
        if (!Objects.isNull(lastMessage)) {
            channelNG = lastMessage;
            synchronized (channelNG) {
                long t = System.currentTimeMillis();
                while (!this.isClosed() && !lastMessage.isMessageSent() && System.currentTimeMillis() - t < 120000L) {
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)"Waiting for sent data notification", (Object[])new Object[0]);
                    }
                    try {
                        lastMessage.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!lastMessage.isMessageSent()) {
                    throw new IOException("Timeout waiting for data to be sent on channel " + this.getLocalId());
                }
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Received sent data notification", (Object[])new Object[0]);
                }
            }
        }
        if (r != null) {
            this.getConnectionProtocol().addTask(ExecutorOperationSupport.CALLBACKS, new ConnectionTaskWrapper(this.getConnection(), r));
        }
    }

    public T getContext() {
        return (T)this.connection.getContext();
    }

    protected void sendExtendedData(byte[] data, int type) throws IOException {
        this.sendExtendedData(data, 0, data.length, type);
    }

    protected void sendExtendedData(byte[] data, int off, int len, int type) throws IOException {
        this.sendChannelDataAndBlock(ByteBuffer.wrap(data, off, len), type, null);
    }

    void processExtendedData(int type, ByteBuffer data) throws IOException {
        if (Log.isDebugEnabled()) {
            this.log("Received", String.format("SSH_MSG_CHANNEL_EXTENDED_DATA len=%d type=%d", data.remaining(), type));
        }
        this.consumeWindowSpace(data.remaining());
        this.onExtendedData(data, type);
    }

    protected void onExtendedData(ByteBuffer data, int type) {
        for (ChannelEventListener listener : this.eventListeners) {
            listener.onChannelExtendedData((Channel)this, data, type);
        }
    }

    void processChannelEOF() {
        for (ChannelEventListener listener : this.eventListeners) {
            listener.onChannelEOF((Channel)this);
        }
        this.isRemoteEOF.set(true);
        this.onRemoteEOF();
    }

    void processChannelClose() {
        this.receivedClose.set(true);
        this.onRemoteClose();
    }

    public void sendChannelRequest(String type, boolean wantreply, byte[] requestdata, ChannelRequestFuture future) {
        if (!wantreply) {
            future.done(true);
        } else {
            this.requests.addLast(future);
        }
        this.connection.sendMessage(new ChannelRequest(type, wantreply, requestdata));
    }

    public void sendChannelRequest(String type, boolean wantreply, byte[] requestdata) {
        if (wantreply) {
            this.requests.addLast(new ChannelRequestFuture());
        }
        this.connection.sendMessage(new ChannelRequest(type, wantreply, requestdata));
    }

    protected void processChannelRequestResponse(boolean success) {
        ChannelRequestFuture future = this.requests.removeFirst();
        if (Log.isDebugEnabled()) {
            this.log("Received", success ? "SSH_MSG_CHANNEL_SUCCESS" : "SSH_MSG_CHANNEL_FAILURE");
        }
        future.done(success);
    }

    void fail() {
        this.openFuture.done(false);
        this.onChannelOpenFailure();
    }

    protected void onChannelOpenFailure() {
    }

    protected void onRemoteClose() {
        this.close();
    }

    public boolean isClosing() {
        return this.sentClose.get();
    }

    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean forceClose) {
        if (Log.isTraceEnabled()) {
            this.log("Checking", "close state force=" + forceClose + " channelType=" + this.getChannelType());
        }
        boolean doSend = false;
        ChannelNG channelNG = this;
        synchronized (channelNG) {
            boolean canClose;
            boolean bl = canClose = forceClose || this.canClose();
            if (!this.sentClose.get() && canClose) {
                this.sentClose.set(true);
                doSend = true;
                for (ChannelEventListener listener : this.eventListeners) {
                    listener.onChannelClosing((Channel)this);
                }
                this.onChannelClosing();
                if (Log.isTraceEnabled()) {
                    this.log("Adding", "our close message to queue");
                }
                this.state = 2;
                this.notifyAll();
            }
        }
        if (doSend && this.connection.isConnected()) {
            this.connection.sendMessage(new ChannelClose(this.receivedClose.get()));
        }
        if (!this.connection.isConnected() || forceClose) {
            if (Log.isTraceEnabled()) {
                this.log("Requesting", "to complete the close operation connected=" + this.connection.isConnected() + " forceClose=" + forceClose);
            }
            if (forceClose) {
                for (ChannelEventListener listener : this.eventListeners) {
                    listener.onChannelError((Channel)this, (Throwable)new IOException("Channel has been forced to close"));
                }
                this.onChannelError(new IOException("Channel has been forced to close"));
            }
            this.completeClose();
        } else if (this.receivedClose.get()) {
            if (Log.isTraceEnabled()) {
                this.log("We've", "already received the remote close message");
            }
            if (this.sentClose.get()) {
                if (Log.isTraceEnabled()) {
                    this.log("We've", "already sent our close message");
                }
                this.completeClose();
            }
        }
    }

    private void completeClose() {
        this.connection.addTask(ExecutorOperationSupport.CALLBACKS, new ConnectionTaskWrapper(this.getConnection(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean hasPerformedClose = false;
                ChannelNG channelNG = ChannelNG.this;
                synchronized (channelNG) {
                    boolean bl = hasPerformedClose = !ChannelNG.this.completedClose.get();
                    if (!ChannelNG.this.completedClose.get()) {
                        if (Log.isTraceEnabled()) {
                            ChannelNG.this.log("Completing", "the close operation");
                        }
                        for (ChannelEventListener listener : ChannelNG.this.eventListeners) {
                            listener.onChannelClose((Channel)ChannelNG.this);
                        }
                        try {
                            if (Objects.nonNull(ChannelNG.this.channelIn)) {
                                ChannelNG.this.channelIn.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ChannelNG.this.onChannelClosed();
                        ChannelNG.this.completedClose.set(true);
                        ChannelNG.this.notifyAll();
                    }
                }
                if (hasPerformedClose) {
                    ChannelNG.this.closeFuture.done(true);
                    ChannelNG.this.connection.freeChannel(ChannelNG.this);
                    ChannelNG.this.free();
                }
            }
        }));
    }

    protected abstract void onChannelFree();

    private void free() {
        if (this.connection != null && Log.isTraceEnabled()) {
            this.log("Freeing", "channel");
        }
        if (this.eventListeners != null) {
            this.eventListeners.clear();
        }
        this.onChannelFree();
    }

    byte[] create(int channelid) throws IOException {
        this.channelid = channelid;
        return this.createChannel();
    }

    protected abstract byte[] createChannel() throws IOException;

    protected abstract byte[] openChannel(byte[] var1) throws WriteOperationRequest, ChannelOpenException;

    protected abstract void onChannelOpenConfirmation();

    protected abstract void onChannelClosed();

    protected abstract void onChannelOpen();

    protected abstract void onChannelClosing();

    protected abstract void onChannelRequest(String var1, boolean var2, byte[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateWindowSpace() {
        ChannelDataWindow channelDataWindow = this.localWindow;
        synchronized (channelDataWindow) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Checking window space on channel=" + this.getLocalId() + " window=" + this.localWindow.getWindowSpace() + (Objects.nonNull(this.cache) ? " cached=" + this.cache.remaining() : "")), (Object[])new Object[0]);
            }
            if (this.localWindow.isAdjustRequired() && this.isOpen() && !this.haltIncomingData.get()) {
                this.sendWindowAdjust();
            }
        }
    }

    protected abstract void onRemoteEOF();

    public void sendEOF() {
        if (this.isOpen() && !this.sentClose.get() && !this.isLocalEOF.get()) {
            this.isLocalEOF.set(true);
            this.remoteWindow.close();
            this.connection.sendMessage(new ChannelEOF());
            this.onLocalEOF();
        }
    }

    protected synchronized boolean canClose() {
        return true;
    }

    protected abstract void onLocalEOF();

    protected boolean isOpen() {
        return this.state == 1;
    }

    protected void sendRequestResponse(boolean succeeded) {
        if (succeeded) {
            this.connection.sendMessage(new RequestSuccess());
        } else {
            this.connection.sendMessage(new RequestFailure());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendWindowAdjust() {
        ChannelDataWindow channelDataWindow = this.localWindow;
        synchronized (channelDataWindow) {
            int count = this.localWindow.getAdjustCount();
            this.sendWindowAdjust(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWindowAdjust(int count) {
        ChannelDataWindow channelDataWindow = this.localWindow;
        synchronized (channelDataWindow) {
            if (Log.isTraceEnabled()) {
                this.log("Increasing", "window space by " + String.valueOf(count) + " bytes");
            }
            this.connection.sendMessage(new WindowAdjust(this, count, this.localWindow.getWindowSpace()));
            this.localWindow.adjust(count);
        }
    }

    protected void logMessage(String message) {
        this.log("Sent", message);
    }

    protected void log(String action, String message) {
        Log.debug((String)"{} {} channel={} remote={} localWindow={} remoteWindow={}", (Object[])new Object[]{action, message, this.channelid, this.remoteid, this.localWindow.getWindowSpace(), this.remoteWindow == null ? "<null>" : Integer.valueOf(this.remoteWindow.getWindowSpace())});
    }

    protected void log(String message) {
        Log.debug((String)"{} channel={} remote={} localWindow={} remoteWindow={}", (Object[])new Object[]{message, this.channelid, this.remoteid, this.localWindow.getWindowSpace(), this.remoteWindow == null ? "<null>" : Integer.valueOf(this.remoteWindow.getWindowSpace())});
    }

    protected void log(String message, Throwable t) {
        Log.debug((String)"{} channel={} remote={} localWindow={} remoteWindow={}", (Throwable)t, (Object[])new Object[]{message, this.channelid, this.remoteid, this.localWindow.getWindowSpace(), this.remoteWindow == null ? "<null>" : Integer.valueOf(this.remoteWindow.getWindowSpace())});
    }

    public boolean isLocalEOF() {
        return this.isLocalEOF.get();
    }

    public boolean isRemoteEOF() {
        return this.isRemoteEOF.get();
    }

    void log() {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Channel id={} type={} localEOF={} remoteEOF={} sentClose={} receivedClose={} completedClose={} remoteWindow={} localWindow={}", (Object[])new Object[]{this.getLocalId(), this.getChannelType(), this.isLocalEOF, this.isRemoteEOF, this.sentClose, this.receivedClose, this.completedClose, this.getRemoteWindow(), this.getLocalWindow()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIncomingDataHalted() {
        ChannelDataWindow channelDataWindow = this.localWindow;
        synchronized (channelDataWindow) {
            return this.haltIncomingData.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void haltIncomingData() {
        ChannelDataWindow channelDataWindow = this.localWindow;
        synchronized (channelDataWindow) {
            this.haltIncomingData.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeIncomingData() {
        ChannelDataWindow channelDataWindow = this.localWindow;
        synchronized (channelDataWindow) {
            this.haltIncomingData.set(false);
            this.evaluateWindowSpace();
        }
    }

    protected boolean checkWindowSpace() {
        if (Log.isTraceEnabled()) {
            Log.trace((String)("Checking window space on channel=" + this.getLocalId() + " window=" + this.localWindow.getWindowSpace() + (Objects.nonNull(this.cache) ? " cached=" + this.cache.remaining() : "")), (Object[])new Object[0]);
        }
        return this.localWindow.getWindowSpace() + (Objects.nonNull(this.cache) ? this.cache.remaining() : 0) <= this.localWindow.getMinimumWindowSpace();
    }

    protected void onChannelError(Throwable e) {
    }

    protected class ChannelInputStream
    extends InputStream {
        boolean streamClosed;
        CachingDataWindow streamCache;

        public ChannelInputStream(CachingDataWindow streamCache) {
            this.streamCache = streamCache;
        }

        @Override
        public int available() throws IOException {
            if (this.streamClosed || ChannelNG.this.isClosed() || ChannelNG.this.isRemoteEOF()) {
                throw new EOFException();
            }
            return this.streamCache.remaining();
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int r = this.read(b);
            if (r > 0) {
                int res = b[0] & 0xFF;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Read returning {}", (Object[])new Object[]{res});
                }
                return res;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.streamClosed) {
                this.streamClosed = true;
                this.streamCache.close();
                CachingDataWindow cachingDataWindow = this.streamCache;
                synchronized (cachingDataWindow) {
                    this.streamCache.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r;
            long start = System.currentTimeMillis();
            ChannelDataWindow channelDataWindow = ChannelNG.this.localWindow;
            synchronized (channelDataWindow) {
                if (ChannelNG.this.checkWindowSpace()) {
                    ChannelNG.this.sendWindowAdjust();
                }
            }
            Object object = this.streamCache;
            synchronized (object) {
                while (!(this.streamCache.hasRemaining() || ChannelNG.this.timeout != 0 && System.currentTimeMillis() - start >= (long)ChannelNG.this.timeout)) {
                    if (this.streamClosed || ChannelNG.this.isClosed() || ChannelNG.this.isRemoteEOF()) {
                        return -1;
                    }
                    try {
                        this.streamCache.waitFor(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.streamCache.hasRemaining()) {
                    if (this.streamClosed || ChannelNG.this.isClosed() || ChannelNG.this.isRemoteEOF()) {
                        return -1;
                    }
                    throw new InterruptedIOException("No data received within the timeout threshold");
                }
                r = this.streamCache.get(ByteBuffer.wrap(b, off, len));
            }
            object = ChannelNG.this.localWindow;
            synchronized (object) {
                if (ChannelNG.this.checkWindowSpace()) {
                    ChannelNG.this.sendWindowAdjust();
                }
            }
            return r;
        }
    }

    class ChannelEOF
    implements SshMessage {
        ChannelEOF() {
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)96);
            buf.putInt(ChannelNG.this.remoteid);
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                ChannelNG.this.logMessage("SSH_MSG_CHANNEL_EOF");
            }
        }
    }

    class ChannelClose
    implements SshMessage {
        boolean finish;

        ChannelClose(boolean finish) {
            this.finish = finish;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)97);
            buf.putInt(ChannelNG.this.remoteid);
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (this.finish) {
                ChannelNG.this.completeClose();
            }
            if (Log.isDebugEnabled()) {
                ChannelNG.this.logMessage("SSH_MSG_CHANNEL_CLOSE");
            }
        }
    }

    class ChannelData
    implements SshMessage {
        int sequenceNo = sequence++;
        ByteBuffer msg;
        int type;
        int count;
        int remoteWindow;
        boolean sent;

        ChannelData(ByteBuffer msg, int type, int remoteWindow) {
            this.msg = msg;
            this.type = type;
            this.remoteWindow = remoteWindow;
            this.count = msg.remaining();
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            if (this.type >= 1) {
                buf.put((byte)95);
                buf.putInt(ChannelNG.this.remoteid);
                buf.putInt(this.type);
            } else {
                buf.put((byte)94);
                buf.putInt(ChannelNG.this.remoteid);
            }
            buf.putInt(this.count);
            buf.put(this.msg);
            this.msg = null;
            return true;
        }

        public synchronized void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                ChannelNG.this.logMessage(String.format("%s seq=%d len=%d", this.type > 0 ? "SSH_MSG_CHANNEL_EXTENDED_DATA" : "SSH_MSG_CHANNEL_DATA", sequenceNo, this.count));
            }
            this.sent = true;
            this.notifyAll();
        }

        public synchronized boolean isMessageSent() {
            return this.sent;
        }
    }

    class RequestFailure
    implements SshMessage {
        RequestFailure() {
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)100);
            buf.putInt(ChannelNG.this.remoteid);
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                ChannelNG.this.logMessage("SSH_MSG_CHANNEL_FAILURE");
            }
        }
    }

    class RequestSuccess
    implements SshMessage {
        RequestSuccess() {
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)99);
            buf.putInt(ChannelNG.this.remoteid);
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                ChannelNG.this.logMessage("SSH_MSG_CHANNEL_SUCCESS");
            }
        }
    }

    class WindowAdjust
    implements SshMessage {
        long count;
        ChannelNG<T> channel;
        long window;

        WindowAdjust(ChannelNG<T> channel, long count, long window) {
            this.channel = channel;
            this.count = count;
            this.window = window;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)93);
            buf.putInt(ChannelNG.this.remoteid);
            buf.putInt((int)this.count);
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                ChannelNG.this.logMessage(String.format("SSH_MSG_CHANNEL_WINDOW_ADJUST count=%d window=%d", this.count, this.window));
            }
        }
    }

    class ChannelRequest
    implements SshMessage {
        String type;
        boolean wantreply;
        byte[] requestdata;

        ChannelRequest(String type, boolean wantreply, byte[] requestdata) {
            this.type = type;
            this.wantreply = wantreply;
            this.requestdata = requestdata;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            try {
                buf.put((byte)98);
                buf.putInt(ChannelNG.this.remoteid);
                buf.putInt(this.type.length());
                buf.put(this.type.getBytes(TransportProtocol.CHARSET_ENCODING));
                buf.put((byte)(this.wantreply ? 1 : 0));
                if (this.requestdata != null) {
                    buf.put(this.requestdata);
                }
            }
            catch (UnsupportedEncodingException ex) {
                ChannelNG.this.connection.close(2, "Could not encode string using " + TransportProtocol.CHARSET_ENCODING + " charset");
            }
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                ChannelNG.this.logMessage(String.format("SSH_MSG_CHANNEL_REQUEST request=%s wantReply=%s", this.type, String.valueOf(this.wantreply)));
            }
        }
    }
}

