/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.scp;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClient;
import com.sshtools.client.scp.ScpClientIO;
import com.sshtools.client.sftp.GlobRegExpMatching;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.direct.NioFileFactory;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ScpClient
extends ScpClientIO {
    AbstractFile lcwd;
    AbstractFileFactory<?> fileFactory;
    long windowSpace = Integer.MAX_VALUE;
    int packetSize = 32768;

    public ScpClient(SshClient ssh) throws PermissionDeniedException, IOException {
        this((AbstractFileFactory<?>)NioFileFactory.NioFileFactoryBuilder.create().build(), ssh);
    }

    public ScpClient(File cwd, SshClient ssh) throws PermissionDeniedException, IOException {
        this((AbstractFileFactory<?>)NioFileFactory.NioFileFactoryBuilder.create().withHome(cwd).build(), ssh);
    }

    public ScpClient(AbstractFileFactory<?> fileFactory, SshClient ssh) throws PermissionDeniedException, IOException {
        super(ssh);
        this.lcwd = fileFactory.getFile("");
    }

    private AbstractFile resolveLocalPath(String path) throws IOException, PermissionDeniedException {
        return this.lcwd.resolveFile(path);
    }

    public void setWindowSpace(int windowSpace) {
        this.windowSpace = windowSpace;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize;
    }

    public void put(String localFile, String remoteFile, boolean recursive) throws SshException, ChannelOpenException, SftpStatusException, IOException, PermissionDeniedException {
        this.put(localFile, remoteFile, recursive, null);
    }

    public void putFile(String localFile, String remoteFile, boolean recursive, FileTransferProgress progress, boolean remoteIsDir) throws SshException, ChannelOpenException, IOException, PermissionDeniedException {
        this.put(localFile, remoteFile, recursive, progress, remoteIsDir);
    }

    public void put(String localFile, String remoteFile, boolean recursive, FileTransferProgress progress, boolean remoteIsDir) throws SshException, ChannelOpenException, IOException, PermissionDeniedException {
        AbstractFile lf = this.resolveLocalPath(localFile);
        if (!lf.exists()) {
            throw new SshException(localFile + " does not exist", 6);
        }
        if (!lf.isFile() && !lf.isDirectory()) {
            throw new SshException(localFile + " is not a regular file or directory", 6);
        }
        if (lf.isDirectory() && !recursive) {
            throw new SshException(localFile + " is a directory, use recursive mode", 6);
        }
        if (remoteFile == null || remoteFile.equals("")) {
            remoteFile = ".";
        }
        ScpEngine scp = new ScpEngine("scp " + (lf.isDirectory() | remoteIsDir ? "-d " : "") + "-t " + (recursive ? "-r " : "") + remoteFile, this.ssh.openSessionChannel(30000L, false));
        try {
            scp.waitForResponse();
            scp.writeFileToRemote(lf, recursive, progress);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException("localfile=" + localFile + " remotefile=" + remoteFile, 6, (Throwable)ex);
        }
        finally {
            try {
                scp.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void put(String localFileRegExp, String remoteFile, boolean recursive, FileTransferProgress progress) throws SshException, ChannelOpenException, SftpStatusException, IOException, PermissionDeniedException {
        AbstractFile f;
        List fileListing;
        String[] matchedFiles;
        GlobRegExpMatching globMatcher = new GlobRegExpMatching();
        Object parentDir = this.lcwd.getAbsolutePath();
        String relativePath = "";
        int fileSeparatorIndex = localFileRegExp.lastIndexOf(System.getProperty("file.separator"));
        if (fileSeparatorIndex > -1 || (fileSeparatorIndex = localFileRegExp.lastIndexOf(47)) > -1) {
            relativePath = localFileRegExp.substring(0, fileSeparatorIndex + 1);
            File rel = new File(relativePath);
            parentDir = rel.isAbsolute() ? relativePath : (String)parentDir + System.getProperty("file.separator") + relativePath;
        }
        if ((matchedFiles = globMatcher.matchFileNamesWithPattern((fileListing = (f = this.resolveLocalPath((String)parentDir)).getChildren()).toArray(new AbstractFile[0]), localFileRegExp.substring(fileSeparatorIndex + 1))).length == 0) {
            throw new SshException(localFileRegExp + "No file matches/File does not exist", 6);
        }
        this.put(matchedFiles, remoteFile, recursive, progress);
    }

    public void put(String[] localFiles, String remoteFile, boolean recursive) throws SshException, ChannelOpenException, IOException, PermissionDeniedException {
        this.put(localFiles, remoteFile, recursive, null);
    }

    public void put(String[] localFiles, String remoteFile, boolean recursive, FileTransferProgress progress) throws SshException, ChannelOpenException, IOException, PermissionDeniedException {
        for (int i = 0; i < localFiles.length; ++i) {
            this.putFile(localFiles[i], remoteFile, recursive, progress, true);
        }
    }

    public void get(String localDir, String[] remoteFiles, boolean recursive) throws SshException, ChannelOpenException, IOException, PermissionDeniedException {
        this.get(localDir, remoteFiles, recursive, null);
    }

    public void get(String localFile, String[] remoteFiles, boolean recursive, FileTransferProgress progress) throws SshException, ChannelOpenException, IOException, PermissionDeniedException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < remoteFiles.length; ++i) {
            buf.append("\"");
            buf.append(remoteFiles[i]);
            buf.append("\" ");
        }
        String remoteFile = buf.toString();
        this.get(localFile, remoteFile, recursive, progress);
    }

    public void get(String localFile, String remoteFile, boolean recursive) throws SshException, ChannelOpenException, IOException, PermissionDeniedException {
        this.get(localFile, remoteFile, recursive, null);
    }

    public void get(String localFile, String remoteFile, boolean recursive, FileTransferProgress progress) throws SshException, ChannelOpenException, IOException, PermissionDeniedException {
        AbstractFile lf;
        if (localFile == null || localFile.equals("")) {
            localFile = ".";
        }
        if ((lf = this.resolveLocalPath(localFile)).exists() && !lf.isFile() && !lf.isDirectory()) {
            throw new SshException(localFile + " is not a regular file or directory", 6);
        }
        ScpEngine scp = new ScpEngine("scp -f " + (recursive ? "-r " : "") + remoteFile, this.ssh.openSessionChannel(30000L, false));
        scp.readFromRemote(lf, progress, recursive);
        try {
            scp.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void exit() throws SshException, IOException {
    }

    protected class ScpEngine
    extends ScpClientIO.ScpEngineIO {
        protected ScpEngine(String cmd, SessionChannelNG session) throws SshException {
            super(ScpClient.this, cmd, session);
        }

        private boolean writeDirToRemote(AbstractFile dir, boolean recursive, FileTransferProgress progress) throws SshException, PermissionDeniedException {
            try {
                if (!recursive) {
                    this.writeError("File " + dir.getName() + " is a directory, use recursive mode");
                    return false;
                }
                String cmd = "D0755 0 " + dir.getName() + "\n";
                this.out.write(cmd.getBytes());
                this.waitForResponse();
                List list = dir.getChildren();
                for (AbstractFile f : list) {
                    this.writeFileToRemote(f, recursive, progress);
                }
                this.out.write("E\n".getBytes());
                return true;
            }
            catch (IOException ex) {
                this.close();
                throw new SshException((Throwable)ex, 6);
            }
        }

        private void writeFileToRemote(AbstractFile file, boolean recursive, FileTransferProgress progress) throws SshException, PermissionDeniedException {
            try {
                if (file.isDirectory()) {
                    if (!this.writeDirToRemote(file, recursive, progress)) {
                        return;
                    }
                } else if (file.isFile()) {
                    String cmd = "C0644 " + file.length() + " " + file.getName() + "\n";
                    this.out.write(cmd.getBytes());
                    if (progress != null) {
                        progress.started(file.length(), file.getName());
                    }
                    this.waitForResponse();
                    InputStream fi = file.getInputStream();
                    this.writeCompleteFile(fi, file.length(), progress);
                    if (progress != null) {
                        progress.completed();
                    }
                    this.writeOk();
                } else {
                    throw new SshException(file.getName() + " not valid for SCP", 6);
                }
                this.waitForResponse();
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                this.close();
                throw new SshException((Throwable)ex, 6);
            }
        }

        private void readFromRemote(AbstractFile file, FileTransferProgress progress, boolean isDir) throws SshException, PermissionDeniedException {
            try {
                String cmd;
                String[] cmdParts = new String[3];
                this.writeOk();
                block13: while (true) {
                    try {
                        cmd = this.readString();
                        if (Log.isInfoEnabled()) {
                            Log.info((String)"SCP returned {}", (Object[])new Object[]{cmd});
                        }
                    }
                    catch (EOFException e) {
                        return;
                    }
                    catch (SshIOException e2) {
                        return;
                    }
                    char cmdChar = cmd.charAt(0);
                    switch (cmdChar) {
                        case 'E': {
                            this.writeOk();
                            return;
                        }
                        case 'T': {
                            continue block13;
                        }
                        case 'C': 
                        case 'D': {
                            AbstractFile targetFile;
                            Object targetName = file.getAbsolutePath();
                            this.parseCommand(cmd, cmdParts);
                            if (file.isDirectory()) {
                                targetName = (String)targetName + File.separator + cmdParts[2];
                            }
                            if (!(targetFile = ScpClient.this.resolveLocalPath((String)targetName)).getAbsolutePath().startsWith(file.getAbsolutePath())) {
                                throw new IOException(String.format("Unexpected path that is outside of the target directory %s", targetFile.getAbsolutePath()));
                            }
                            if (cmdChar == 'D') {
                                if (!isDir) {
                                    throw new IOException("Unexpected 'D' directive received from remote during file request");
                                }
                                if (targetFile.exists()) {
                                    if (!targetFile.isDirectory()) {
                                        String msg = "Invalid target " + targetFile.getName() + ", must be a directory";
                                        this.writeError(msg);
                                        throw new IOException(msg);
                                    }
                                } else if (!targetFile.createFolder()) {
                                    String msg = "Could not create directory: " + targetFile.getName();
                                    this.writeError(msg);
                                    throw new IOException(msg);
                                }
                                this.readFromRemote(targetFile, progress, true);
                                continue block13;
                            }
                            long len = Long.parseLong(cmdParts[1]);
                            OutputStream fo = targetFile.getOutputStream();
                            this.writeOk();
                            if (progress != null) {
                                progress.started(len, (String)targetName);
                            }
                            this.readCompleteFile(fo, len, progress);
                            if (progress != null) {
                                progress.completed();
                            }
                            try {
                                this.waitForResponse();
                                this.writeOk();
                            }
                            catch (SshIOException ex) {
                                if (ex.getRealException().getReason() == 1 && !isDir) {
                                    return;
                                }
                                throw ex;
                            }
                        }
                        continue block13;
                    }
                    break;
                }
                if (Log.isInfoEnabled()) {
                    Log.error((String)"Unexpected command {}", (Object[])new Object[]{cmd});
                }
                this.writeError("Unexpected cmd: " + cmd);
                throw new IOException("SCP unexpected cmd: " + cmd);
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                this.close();
                throw new SshException((Throwable)ex, 6);
            }
        }
    }
}

