/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.PasswordAuthenticator;
import com.sshtools.client.SshClient;
import com.sshtools.client.SshClientContext;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.synergy.ssh.Connection;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SshCompatibilityUtils {
    public static String[] getSupportedHostKeyAlgorithms(String hostname, int port) throws SshException, IOException {
        try (SshClient ssh = SshClient.SshClientBuilder.create().withTarget(hostname, port).build();){
            String[] stringArray = ssh.getRemotePublicKeys();
            return stringArray;
        }
    }

    public static SshPublicKey getHostKey(String hostname, int port) throws SshException, IOException {
        return SshCompatibilityUtils.getHostKey(hostname, port, null);
    }

    public static Set<SshPublicKey> getSupportedHostKeys(String hostname, int port) throws SshException, IOException {
        HashSet<SshPublicKey> hostkeys = new HashSet<SshPublicKey>();
        for (String algorithm : SshCompatibilityUtils.getSupportedHostKeyAlgorithms(hostname, port)) {
            hostkeys.add(SshCompatibilityUtils.getHostKey(hostname, port, algorithm));
        }
        return hostkeys;
    }

    public static SshPublicKey getHostKey(String hostname, int port, String algorithm) throws SshException, IOException {
        try (SshClient ssh = SshClient.SshClientBuilder.create().withTarget(hostname, port).onConfigure(ctx -> ctx.setPreferredPublicKey(algorithm)).build();){
            SshPublicKey sshPublicKey = ssh.getConnection().getHostKey();
            return sshPublicKey;
        }
    }

    public static SshConnection getRemoteConfiguration(String hostname, int port) throws IOException, SshException {
        try (SshClient ssh = SshClient.SshClientBuilder.create().withTarget(hostname, port).build();){
            Connection<SshClientContext> connection = ssh.getConnection();
            return connection;
        }
    }

    public static SshClient getRemoteClient(String hostname, int port, String username, String password, boolean tcpNoDelay) throws SshException, IOException {
        SshClient ssh = SshClient.SshClientBuilder.create().withTarget(hostname, port).withUsername(username).withPassword(password).onConfigure(ctx -> ctx.setSocketOptionTcpNoDelay(tcpNoDelay)).build();
        ssh.authenticate(new PasswordAuthenticator(password), 30000L);
        if (!ssh.isAuthenticated()) {
            throw new IOException("Bas username or password");
        }
        return ssh;
    }

    static class ConfigurationCollector {
        SshConnection con;

        ConfigurationCollector() {
        }

        public String getRemoteIdentification() {
            return this.con.getRemoteIdentification();
        }

        public Set<String> getSupportedHostKeys() {
            return new HashSet<String>(Arrays.asList(this.con.getRemotePublicKeys()));
        }

        public Set<String> getSupportedKeyExchanges() {
            return new HashSet<String>(Arrays.asList(this.con.getRemoteKeyExchanges()));
        }

        public Set<String> getSupportedCompressions() {
            HashSet<String> tmp = new HashSet<String>();
            tmp.addAll(Arrays.asList(this.con.getRemoteCompressionsCS()));
            tmp.addAll(Arrays.asList(this.con.getRemoteCompressionsSC()));
            return tmp;
        }

        public Set<String> getSupportedCiphers() {
            HashSet<String> tmp = new HashSet<String>();
            tmp.addAll(Arrays.asList(this.con.getRemoteCiphersCS()));
            tmp.addAll(Arrays.asList(this.con.getRemoteCiphersSC()));
            return tmp;
        }

        public Set<String> getSupportedMacs() {
            HashSet<String> tmp = new HashSet<String>();
            tmp.addAll(Arrays.asList(this.con.getRemoteMacsCS()));
            tmp.addAll(Arrays.asList(this.con.getRemoteMacsSC()));
            return tmp;
        }

        public SshPublicKey getKey() {
            return this.con.getHostKey();
        }

        public String getNegotiatedKeyExchange() {
            return this.con.getKeyExchangeInUse();
        }

        public String getNegotiatedHostKey() {
            return this.con.getHostKeyInUse();
        }

        public String getNegotiatedCipherCS() {
            return this.con.getCipherInUseCS();
        }

        public String getNegotiatedCipherSC() {
            return this.con.getCipherInUseSC();
        }

        public String getNegotiatedMacCS() {
            return this.con.getMacInUseCS();
        }

        public String getNegotiatedMacSC() {
            return this.con.getMacInUseSC();
        }

        public String getNegotiatedCompressionCS() {
            return this.con.getCompressionInUseCS();
        }

        public String getNegotiatedCompressionSC() {
            return this.con.getCompressionInUseSC();
        }
    }
}

