/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.AuthenticationMessage;
import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.SimpleClientAuthenticator;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.logger.Log;
import com.sshtools.common.policy.SignaturePolicy;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SignatureGenerator;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshRsaPublicKey;
import com.sshtools.common.ssh.components.jce.OpenSshRsaCertificate;
import com.sshtools.common.ssh.components.jce.OpenSshRsaSha256Certificate;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKeySHA256;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKeySHA512;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.Utils;
import com.sshtools.synergy.ssh.Connection;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class PublicKeyAuthenticator
extends SimpleClientAuthenticator
implements ClientAuthenticator {
    public static final int SSH_MSG_USERAUTH_PK_OK = 60;
    boolean isAuthenticating = false;
    TransportProtocolClient transport;
    String username;
    SignatureGenerator signatureGenerator;
    SshPublicKey currentKey;
    String signingAlgorithm;

    private boolean setupNextKey() throws IOException, SshException {
        do {
            this.currentKey = this.getNextKey();
            this.signingAlgorithm = this.currentKey.getSigningAlgorithm();
            SignaturePolicy policy = (SignaturePolicy)((SshClientContext)this.transport.getContext()).getPolicy(SignaturePolicy.class);
            if (!policy.getSupportedSignatures().isEmpty()) {
                if (this.currentKey instanceof SshRsaPublicKey && this.currentKey.getBitLength() >= 1024) {
                    if (policy.getSupportedSignatures().contains("rsa-sha2-512")) {
                        this.signingAlgorithm = "rsa-sha2-512";
                        this.currentKey = new Ssh2RsaPublicKeySHA512((SshRsaPublicKey)this.currentKey);
                    } else if (policy.getSupportedSignatures().contains("rsa-sha2-256")) {
                        this.signingAlgorithm = "rsa-sha2-256";
                        this.currentKey = new Ssh2RsaPublicKeySHA256((SshRsaPublicKey)this.currentKey);
                    } else {
                        Log.debug((String)"Server does not support {} signature for key {}", (Object[])new Object[]{this.currentKey.getSigningAlgorithm(), SshKeyUtils.getOpenSSHFormattedKey((SshPublicKey)this.currentKey)});
                        continue;
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Upgrading key {} to use {} signature", (Object[])new Object[]{this.currentKey.getAlgorithm(), this.signingAlgorithm});
                    }
                } else if (this.currentKey instanceof OpenSshRsaCertificate && this.currentKey.getBitLength() >= 1024) {
                    if (policy.getSupportedSignatures().contains("rsa-sha2-512")) {
                        this.signingAlgorithm = "rsa-sha2-512";
                        this.currentKey = new OpenSshRsaSha256Certificate().init(this.currentKey.getEncoded());
                    } else if (policy.getSupportedSignatures().contains("rsa-sha2-256")) {
                        this.signingAlgorithm = "rsa-sha2-256";
                        this.currentKey = new OpenSshRsaSha256Certificate().init(this.currentKey.getEncoded());
                    } else {
                        Log.debug((String)"Server does not support {} signature for key {}", (Object[])new Object[]{this.currentKey.getSigningAlgorithm(), SshKeyUtils.getOpenSSHFormattedKey((SshPublicKey)this.currentKey)});
                        continue;
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Upgrading certificate {} to use {} signature", (Object[])new Object[]{this.currentKey.getAlgorithm(), this.signingAlgorithm});
                    }
                } else if (!policy.getSupportedSignatures().contains(this.signingAlgorithm)) {
                    Log.debug((String)"Server does not support {} signature for key {}", (Object[])new Object[]{this.currentKey.getSigningAlgorithm(), SshKeyUtils.getOpenSSHFormattedKey((SshPublicKey)this.currentKey)});
                    continue;
                }
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Authenticating with {}", (Object[])new Object[]{SshKeyUtils.getOpenSSHFormattedKey((SshPublicKey)this.currentKey)});
            }
            return true;
        } while (this.hasCredentialsRemaining());
        return false;
    }

    @Override
    public void authenticate(TransportProtocolClient transport, String username) throws IOException, SshException {
        this.onStartAuthentication((Connection<SshClientContext>)transport.getConnection());
        this.transport = transport;
        this.username = username;
        if (this.hasCredentialsRemaining()) {
            this.setupNextKey();
            this.doPublicKeyAuth();
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"No more credentials", (Object[])new Object[]{this.getName()});
            }
            this.done(false);
        }
    }

    protected void onStartAuthentication(Connection<SshClientContext> con) {
    }

    void doPublicKeyAuth() throws SshException, IOException {
        try {
            final byte[] msg = this.generateAuthenticationRequest(this.generateSignatureData());
            this.transport.postMessage(new AuthenticationMessage(this.username, "ssh-connection", "publickey"){

                @Override
                public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                    super.writeMessageIntoBuffer(buf);
                    buf.put(msg);
                    return true;
                }
            });
        }
        catch (IOException e) {
            Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
            this.failure();
        }
        catch (SshException e) {
            Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
            this.failure();
        }
        catch (InvalidPassphraseException e) {
            Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
            this.failure();
        }
    }

    byte[] generateSignatureData() throws IOException, SshException, InvalidPassphraseException {
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            baw.writeBinaryString(this.transport.getSessionKey());
            baw.write(50);
            baw.writeString(this.username);
            baw.writeString("ssh-connection");
            baw.writeString("publickey");
            baw.writeBoolean(this.isAuthenticating);
            this.writePublicKey(baw, this.currentKey);
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }

    protected abstract SshPublicKey getNextKey() throws IOException;

    protected abstract SshKeyPair getAuthenticatingKey() throws IOException, InvalidPassphraseException;

    protected abstract boolean hasCredentialsRemaining();

    private void writePublicKey(ByteArrayWriter baw, SshPublicKey key) throws IOException, SshException {
        baw.writeString(key.getAlgorithm());
        baw.writeBinaryString(key.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] generateAuthenticationRequest(byte[] data) throws IOException, SshException, InvalidPassphraseException {
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            baw.writeBoolean(this.isAuthenticating);
            if (!this.isAuthenticating && Log.isDebugEnabled()) {
                Log.debug((String)"Verifying key {}", (Object[])new Object[]{this.currentKey.getAlgorithm()});
                Log.debug((String)"Encoded key{}{}", (Object[])new Object[]{System.lineSeparator(), Utils.bytesToHex((byte[])this.currentKey.getEncoded(), (int)32, (boolean)true, (boolean)true)});
            }
            this.writePublicKey(baw, this.currentKey);
            if (this.isAuthenticating) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Signing authentication request with {}", (Object[])new Object[]{this.signingAlgorithm});
                }
                byte[] signature = this.getSignatureGenerator().sign(this.currentKey, this.signingAlgorithm, data);
                baw.writeBinaryString(signature);
            }
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }

    protected SignatureGenerator getSignatureGenerator() throws IOException, InvalidPassphraseException {
        return this.getAuthenticatingKey();
    }

    @Override
    public boolean processMessage(ByteArrayReader msg) throws IOException, SshException {
        switch (msg.read()) {
            case 60: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Received SSH_MSG_USERAUTH_PK_OK", (Object[])new Object[0]);
                    Log.debug((String)"Server accepts {} {}", (Object[])new Object[]{this.currentKey.getAlgorithm(), SshKeyUtils.getFingerprint((SshPublicKey)this.currentKey)});
                }
                this.isAuthenticating = true;
                try {
                    this.doPublicKeyAuth();
                }
                catch (SshException | IOException e) {
                    Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
                    this.failure();
                }
                return true;
            }
            case 51: {
                if (this.hasCredentialsRemaining()) {
                    this.setupNextKey();
                    this.isAuthenticating = false;
                    this.doPublicKeyAuth();
                    return true;
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"No more credentials", (Object[])new Object[]{this.getName()});
                }
                this.done(false);
            }
        }
        return false;
    }

    public byte[] sign(SshPrivateKey prv, String signingAlgorithm, byte[] data) throws SshException {
        try {
            return prv.sign(data, signingAlgorithm);
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "publickey";
    }
}

