/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.AuthenticationMessage;
import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.SimpleClientAuthenticator;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.SignatureGenerator;
import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshCertificate;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.Connection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class PublicKeyAuthenticator
extends SimpleClientAuthenticator
implements ClientAuthenticator {
    public static final int SSH_MSG_USERAUTH_PK_OK = 60;
    boolean isAuthenticating = false;
    TransportProtocolClient transport;
    String username;
    Collection<SshKeyPair> keypairs;
    SignatureGenerator signatureGenerator;
    SshKeyPair authenticatingPair = null;
    SshPrivateKeyFile authenticatingFile = null;

    public PublicKeyAuthenticator() {
    }

    public PublicKeyAuthenticator(SshKeyPair ... keys) {
        this.keypairs = new ArrayList<SshKeyPair>();
        this.keypairs.addAll(Arrays.asList(keys));
    }

    public void setKeyPair(SshKeyPair ... keys) {
        this.keypairs = new ArrayList<SshKeyPair>();
        this.keypairs.addAll(Arrays.asList(keys));
    }

    @Override
    public void authenticate(TransportProtocolClient transport, String username) throws IOException, SshException {
        this.onStartAuthentication((Connection<SshClientContext>)transport.getConnection());
        this.transport = transport;
        this.username = username;
        this.doPublicKeyAuth();
    }

    protected void onStartAuthentication(Connection<SshClientContext> con) {
    }

    void doPublicKeyAuth() throws SshException, IOException {
        try {
            final byte[] msg = this.generateAuthenticationRequest(this.generateSignatureData());
            this.transport.postMessage(new AuthenticationMessage(this.username, "ssh-connection", "publickey"){

                @Override
                public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                    super.writeMessageIntoBuffer(buf);
                    buf.put(msg);
                    return true;
                }
            });
        }
        catch (IOException e) {
            Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
            this.failure();
        }
        catch (SshException e) {
            Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
            this.failure();
        }
    }

    byte[] generateSignatureData() throws IOException, SshException {
        if (Objects.isNull(this.authenticatingPair) && !this.keypairs.isEmpty()) {
            this.authenticatingPair = this.keypairs.iterator().next();
        }
        if (Objects.isNull(this.authenticatingPair)) {
            throw new IOException("No suitable key found");
        }
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            baw.writeBinaryString(this.transport.getSessionKey());
            baw.write(50);
            baw.writeString(this.username);
            baw.writeString("ssh-connection");
            baw.writeString("publickey");
            baw.writeBoolean(this.isAuthenticating);
            this.writePublicKey(baw, this.getPublicKey(this.authenticatingPair));
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }

    private void writePublicKey(ByteArrayWriter baw, SshPublicKey key) throws IOException, SshException {
        baw.writeString(key.getAlgorithm());
        baw.writeBinaryString(key.getEncoded());
    }

    private SshPublicKey getPublicKey(SshKeyPair pair) {
        if (pair instanceof SshCertificate) {
            return ((SshCertificate)pair).getCertificate();
        }
        return pair.getPublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] generateAuthenticationRequest(byte[] data) throws IOException, SshException {
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            baw.writeBoolean(this.isAuthenticating);
            this.writePublicKey(baw, this.getPublicKey(this.authenticatingPair));
            if (this.isAuthenticating) {
                byte[] signature = this.sign(this.authenticatingPair.getPrivateKey(), this.authenticatingPair.getPublicKey().getSigningAlgorithm(), data);
                try (ByteArrayWriter sig = new ByteArrayWriter();){
                    sig.writeString(this.authenticatingPair.getPublicKey().getSigningAlgorithm());
                    sig.writeBinaryString(signature);
                    baw.writeBinaryString(sig.toByteArray());
                }
            }
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }

    @Override
    public boolean processMessage(ByteArrayReader msg) throws IOException, SshException {
        switch (msg.read()) {
            case 60: {
                this.isAuthenticating = true;
                try {
                    this.doPublicKeyAuth();
                }
                catch (SshException | IOException e) {
                    Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
                    this.failure();
                }
                return true;
            }
            case 51: {
                if (this.isAuthenticating) break;
                this.keypairs.remove(this.authenticatingPair);
                this.authenticatingPair = null;
                if (this.keypairs.isEmpty()) break;
                this.doPublicKeyAuth();
                return true;
            }
        }
        return false;
    }

    public byte[] sign(SshPrivateKey prv, String signingAlgorithm, byte[] data) throws SshException {
        try {
            return prv.sign(data, signingAlgorithm);
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "publickey";
    }
}

