/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.AuthenticationMessage;
import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.SimpleClientAuthenticator;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.SignatureGenerator;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.Connection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class ExternalKeyAuthenticator
extends SimpleClientAuthenticator
implements ClientAuthenticator,
SignatureGenerator {
    public static final int SSH_MSG_USERAUTH_PK_OK = 60;
    boolean isAuthenticating = false;
    TransportProtocolClient transport;
    String username;
    Collection<SshPublicKey> publicKeys;
    SignatureGenerator signatureGenerator;
    SshPublicKey authenticatingKey = null;

    public ExternalKeyAuthenticator(SignatureGenerator signatureGenerator) {
        this.signatureGenerator = signatureGenerator;
    }

    public ExternalKeyAuthenticator() {
    }

    @Override
    public void authenticate(TransportProtocolClient transport, String username) throws SshException, IOException {
        this.onStartAuthentication((Connection<SshClientContext>)transport.getConnection());
        this.transport = transport;
        this.username = username;
        this.publicKeys = new ArrayList<SshPublicKey>(this.getSignatureGenerator((Connection<SshClientContext>)transport.getConnection()).getPublicKeys());
        this.doPublicKeyAuth();
    }

    protected void onStartAuthentication(Connection<SshClientContext> con) {
    }

    void doPublicKeyAuth() throws SshException, IOException {
        try {
            final byte[] msg = this.generateAuthenticationRequest(this.generateSignatureData());
            this.transport.postMessage(new AuthenticationMessage(this.username, "ssh-connection", "publickey"){

                @Override
                public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                    super.writeMessageIntoBuffer(buf);
                    buf.put(msg);
                    return true;
                }
            });
        }
        catch (IOException e) {
            Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
            this.failure();
        }
        catch (SshException e) {
            Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
            this.failure();
        }
    }

    byte[] generateSignatureData() throws IOException, SshException {
        if (Objects.isNull(this.authenticatingKey) && !this.publicKeys.isEmpty()) {
            this.authenticatingKey = this.publicKeys.iterator().next();
        }
        if (Objects.isNull(this.authenticatingKey)) {
            throw new IOException("No suitable key found");
        }
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            baw.writeBinaryString(this.transport.getSessionKey());
            baw.write(50);
            baw.writeString(this.username);
            baw.writeString("ssh-connection");
            baw.writeString("publickey");
            baw.writeBoolean(this.isAuthenticating);
            this.writePublicKey(baw, this.authenticatingKey);
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }

    private void writePublicKey(ByteArrayWriter baw, SshPublicKey key) throws IOException, SshException {
        baw.writeString(key.getAlgorithm());
        baw.writeBinaryString(key.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] generateAuthenticationRequest(byte[] data) throws IOException, SshException {
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            baw.writeBoolean(this.isAuthenticating);
            this.writePublicKey(baw, this.authenticatingKey);
            if (this.isAuthenticating) {
                byte[] signature = this.signatureGenerator.sign(this.authenticatingKey, this.authenticatingKey.getSigningAlgorithm(), data);
                baw.writeBinaryString(signature);
            }
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }

    @Override
    public boolean processMessage(ByteArrayReader msg) throws IOException {
        switch (msg.read()) {
            case 60: {
                this.isAuthenticating = true;
                try {
                    this.doPublicKeyAuth();
                }
                catch (SshException | IOException e) {
                    Log.error((String)"Public key operation failed", (Throwable)e, (Object[])new Object[0]);
                    this.failure();
                }
                return true;
            }
            case 51: {
                if (this.isAuthenticating) break;
                this.publicKeys.remove(this.authenticatingKey);
                this.authenticatingKey = null;
                if (this.publicKeys.isEmpty()) break;
                try {
                    this.doPublicKeyAuth();
                }
                catch (SshException | IOException e) {
                    this.failure();
                }
                return true;
            }
        }
        return false;
    }

    public SignatureGenerator getSignatureGenerator(Connection<SshClientContext> con) {
        return Objects.isNull(this.signatureGenerator) ? this : this.signatureGenerator;
    }

    public byte[] sign(SshPublicKey key, String signingAlgorithm, byte[] data) throws SshException {
        return this.getSignatureGenerator((Connection<SshClientContext>)this.transport.getConnection()).sign(key, signingAlgorithm, data);
    }

    @Override
    public String getName() {
        return "publickey";
    }

    public Collection<SshPublicKey> getPublicKeys() throws IOException {
        return Collections.emptyList();
    }
}

