/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.Task;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import java.io.File;
import java.io.IOException;

public class UploadFileTask
extends Task {
    Connection<SshClientContext> con;
    String path;
    File localFile = null;

    public UploadFileTask(Connection<SshClientContext> con, File localFile, String path) {
        super((SshConnection)con);
        this.con = con;
        this.path = path;
        this.localFile = localFile;
    }

    public UploadFileTask(Connection<SshClientContext> con, File localFile) {
        this(con, localFile, null);
    }

    public void doTask() {
        SftpClientTask task = new SftpClientTask((SshConnection)this.con){

            @Override
            protected void doSftp() {
                try {
                    if (UploadFileTask.this.path == null) {
                        this.put(UploadFileTask.this.localFile.getAbsolutePath());
                    } else {
                        this.put(UploadFileTask.this.localFile.getAbsolutePath(), UploadFileTask.this.path);
                    }
                }
                catch (TransferCancelledException | PermissionDeniedException | SftpStatusException | SshException | IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        };
        try {
            this.con.addTask((ConnectionAwareTask)new ConnectionTaskWrapper(this.con, (Runnable)task));
            task.waitForever();
        }
        catch (Throwable throwable) {
            this.done(task.isDone() && task.isSuccess());
            throw throwable;
        }
        this.done(task.isDone() && task.isSuccess());
    }
}

