/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.ClientStateListener;
import com.sshtools.client.SshClientContext;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.net.HttpRequest;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.LicenseException;
import com.sshtools.synergy.nio.SocketConnection;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.Service;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.TransportProtocol;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class TransportProtocolClient
extends TransportProtocol<SshClientContext> {
    Service pendingService;
    boolean proxyDone;

    public TransportProtocolClient(SshClientContext sshContext, ConnectRequestFuture connectFuture) throws LicenseException {
        super((SshContext)sshContext, connectFuture);
    }

    protected boolean canConnect(SocketConnection connection) {
        return true;
    }

    public void onSocketConnect(SocketConnection connection) {
        block6: {
            block5: {
                this.socketConnection = connection;
                if (!((SshClientContext)this.sshContext).isProxyEnabled()) break block5;
                switch (((SshClientContext)this.sshContext).getProxyType()) {
                    case HTTP: {
                        this.sendHTTPProxyRequest();
                        break block6;
                    }
                    case SOCKS4: {
                        break block6;
                    }
                    case SOCKS5: {
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException("Proxy NONE should not mean that a isProxyEnabled returns true");
                    }
                }
            }
            super.onSocketConnect(connection);
        }
    }

    public boolean onSocketRead(ByteBuffer incomingData) {
        if (((SshClientContext)this.sshContext).isProxyEnabled() && !this.proxyDone) {
            return super.onSocketRead(incomingData);
        }
        return super.onSocketRead(incomingData);
    }

    private void sendHTTPProxyRequest() {
        this.postMessage(new SshMessage(){
            HttpRequest request = new HttpRequest();

            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                this.request.setHeaderBegin("CONNECT " + ((SshClientContext)TransportProtocolClient.this.sshContext).getRemoteHostname() + ":" + ((SshClientContext)TransportProtocolClient.this.sshContext).getRemotePort() + " HTTP/1.0");
                this.request.setHeaderField("User-Agent", ((SshClientContext)TransportProtocolClient.this.sshContext).getUserAgent());
                this.request.setHeaderField("Pragma", "No-Cache");
                this.request.setHeaderField("Host", ((SshClientContext)TransportProtocolClient.this.sshContext).getProxyHostname());
                this.request.setHeaderField("Proxy-Connection", "Keep-Alive");
                if (((SshClientContext)TransportProtocolClient.this.sshContext).getProxyUsername() != null && !"".equals(((SshClientContext)TransportProtocolClient.this.sshContext).getProxyUsername().trim()) && ((SshClientContext)TransportProtocolClient.this.sshContext).getProxyPassword() != null && !"".equals(((SshClientContext)TransportProtocolClient.this.sshContext).getProxyPassword().trim())) {
                    this.request.setBasicAuthentication(((SshClientContext)TransportProtocolClient.this.sshContext).getProxyUsername(), ((SshClientContext)TransportProtocolClient.this.sshContext).getProxyPassword());
                }
                try {
                    buf.put(this.request.toString().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sent HTTP Proxy Request", (Object[])new Object[0]);
                }
                Log.debug((String)this.request.toString(), (Object[])new Object[0]);
            }
        });
    }

    protected void initializeKeyExchange(SshKeyExchange<SshClientContext> keyExchange, boolean firstPacketFollows, boolean useFirstPacket) throws IOException, SshException {
        keyExchange.init((SshTransport)this, this.localIdentification.toString().trim(), this.remoteIdentification.toString().trim(), this.localkex, this.remotekex, null, null, firstPacketFollows, useFirstPacket);
    }

    protected void onKeyExchangeInit() {
    }

    protected void completeKeyExchange(SshKeyExchange<SshClientContext> keyExchange) {
        block7: {
            try {
                this.hostKey = SshPublicKeyFileFactory.decodeSSH2PublicKey((byte[])keyExchange.getHostKey());
                if (((SshClientContext)this.getContext()).getHostKeyVerification() != null) {
                    String host = this.getConnectFuture().getHost();
                    if (!Boolean.getBoolean("maverick.knownHosts.disablePortValidate") && this.getConnectFuture().getPort() != 22) {
                        host = "[" + host + "]:" + this.getConnectFuture().getPort();
                    }
                    if (!((SshClientContext)this.getContext()).getHostKeyVerification().verifyHost(host, this.hostKey)) {
                        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777213, false).addAttribute("CONNECTION", (Object)this.getConnection()).addAttribute("HOST_KEY", (Object)new String(keyExchange.getHostKey())).addAttribute("HOST_PUBLIC_KEY", (Object)this.hostKey));
                        this.disconnect(9, "Host key not accepted");
                        throw new SshException("The host key was not accepted", 8);
                    }
                    if (!this.hostKey.verifySignature(keyExchange.getSignature(), keyExchange.getExchangeHash())) {
                        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777213, false).addAttribute("CONNECTION", (Object)this.getConnection()).addAttribute("HOST_KEY", (Object)new String(keyExchange.getHostKey())).addAttribute("HOST_PUBLIC_KEY", (Object)this.hostKey));
                        this.disconnect(9, "Invalid host key signature");
                        throw new SshException("The host key signature is invalid", 3);
                    }
                }
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777212, true).addAttribute("CONNECTION", (Object)this.getConnection()).addAttribute("HOST_KEY", (Object)new String(keyExchange.getHostKey())).addAttribute("HOST_PUBLIC_KEY", (Object)this.hostKey));
                boolean first = !this.completedFirstKeyExchange;
                super.completeKeyExchange(keyExchange);
                ((SshClientContext)this.sshContext).keysExchanged(first);
            }
            catch (SshException | IOException e) {
                if (Log.isErrorEnabled()) {
                    Log.error((String)"Could not verify host key", (Throwable)e, (Object[])new Object[0]);
                }
                this.getConnectFuture().done(false);
                if (this.disconnectStarted == null) break block7;
                this.disconnect(9, "The host key could not be verified.");
            }
        }
    }

    protected void onNewKeysReceived() {
        this.generateNewKeysClientIn();
    }

    protected void onNewKeysSent() {
        this.generateNewKeysClientOut();
    }

    protected String selectNegotiatedComponent(String remotelist, String locallist) throws IOException {
        return super.selectNegotiatedComponent(locallist, remotelist);
    }

    protected boolean processTransportMessage(int msgid, byte[] msg) throws IOException, SshException {
        switch (msgid) {
            case 6: {
                if (this.pendingService != null) {
                    this.activeService = this.pendingService;
                    this.pendingService = null;
                    this.activeService.start();
                }
                return true;
            }
        }
        return false;
    }

    public void setActiveService(Service service) {
        this.activeService = service;
    }

    public Service getActiveService() {
        return this.activeService;
    }

    public void startService(final Service service) {
        this.pendingService = service;
        this.postMessage(new SshMessage(){
            byte[] serviceNameBytes;
            {
                this.serviceNameBytes = TransportProtocol.getBytes((String)service.getName(), (String)TransportProtocol.CHARSET_ENCODING);
            }

            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                buf.put((byte)5);
                buf.putInt(this.serviceNameBytes.length);
                buf.put(this.serviceNameBytes);
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sent SSH_MSG_SERVICE_REQUEST {}", (Object[])new Object[]{service.getName()});
                }
            }
        });
    }

    protected void disconnected() {
        this.addTask(EVENTS, (ConnectionAwareTask)new ConnectionTaskWrapper((SshConnection)this.getConnection(), new Runnable(){

            @Override
            public void run() {
                for (ClientStateListener stateListener : ((SshClientContext)TransportProtocolClient.this.sshContext).getStateListeners()) {
                    stateListener.disconnected((SshConnection)TransportProtocolClient.this.con);
                }
            }
        }));
    }

    protected void onConnected() {
        this.con = ((SshClientContext)this.getContext()).getConnectionManager().registerTransport((TransportProtocol)this, (SshContext)((SshClientContext)this.sshContext));
    }

    protected void onDisconnected() {
        ((SshClientContext)this.getContext()).getConnectionManager().unregisterTransport((TransportProtocol)this);
    }

    public String getName() {
        return "transport-client";
    }

    protected SocketAddress getConnectionAddress() {
        return this.getLocalAddress();
    }
}

