/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.Task;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.FileUtils;
import com.sshtools.synergy.ssh.Connection;
import java.io.File;
import java.io.IOException;

public class DownloadFileTask
extends Task {
    Connection<SshClientContext> con;
    String path;
    File localFile = null;

    public DownloadFileTask(Connection<SshClientContext> con, String path, File localFile) {
        super((SshConnection)con);
        this.con = con;
        this.path = path;
        this.localFile = localFile;
    }

    public DownloadFileTask(Connection<SshClientContext> con, String path) {
        this(con, path, null);
    }

    public void doTask() {
        SftpClientTask task = new SftpClientTask((SshConnection)this.con){

            @Override
            protected void doSftp() {
                try {
                    if (DownloadFileTask.this.localFile == null) {
                        DownloadFileTask.this.localFile = new File(this.lpwd(), FileUtils.getFilename((String)DownloadFileTask.this.path));
                    }
                    this.get(DownloadFileTask.this.path, DownloadFileTask.this.localFile.getAbsolutePath());
                }
                catch (TransferCancelledException | PermissionDeniedException | SftpStatusException | SshException | IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        };
        try {
            this.con.addTask((ConnectionAwareTask)task);
            task.waitForever();
        }
        catch (Throwable throwable) {
            this.done(task.isDone() && task.isSuccess());
            throw throwable;
        }
        this.done(task.isDone() && task.isSuccess());
    }

    public File getDownloadedFile() {
        return this.localFile;
    }
}

