/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.util.IOUtils;
import com.sshtools.synergy.ssh.ByteArrays;
import com.sshtools.synergy.ssh.PacketPool;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

public abstract class AbstractSubsystemTask
extends ConnectionAwareTask {
    protected long timeout = 60000L;
    DataInputStream in;
    UUID taskUUID = UUID.randomUUID();

    public AbstractSubsystemTask(SshConnection con) {
        super(con);
    }

    protected void doTask() {
        try {
            SessionChannelNG session = this.getSession();
            if (session == null) {
                session = this.createSession();
                this.in = new DataInputStream(session.getInputStream());
            }
            this.doSubsystemTask(session);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected SessionChannelNG createSession() throws SshException {
        SessionChannelNG session = new SessionChannelNG(this.getMaximumPacketSize(), this.getMaximumWindowSize(), this.getMaximumWindowSize(), this.getMinimumWindowSize(), false);
        session.addEventListener(new ChannelEventListener(){

            public void onChannelClose(Channel channel) {
                IOUtils.closeStream((InputStream)AbstractSubsystemTask.this.in);
                AbstractSubsystemTask.this.onCloseSession((SessionChannelNG)channel);
            }
        });
        this.con.openChannel((Channel)session);
        if (!session.getOpenFuture().waitFor(this.timeout).isSuccess()) {
            throw new IllegalStateException("Could not open session channel");
        }
        this.con.setProperty(this.taskUUID.toString(), (Object)session);
        return session;
    }

    protected abstract int getMinimumWindowSize();

    protected abstract int getMaximumWindowSize();

    protected abstract int getMaximumPacketSize();

    protected SessionChannelNG getSession() {
        return (SessionChannelNG)((Object)this.con.getProperty(this.taskUUID.toString()));
    }

    public byte[] nextMessage() throws SshException {
        int len = -1;
        try {
            len = this.in.readInt();
            if (len < 0) {
                throw new SshException("Negative message length in SFTP protocol.", 3);
            }
            if (len > this.con.getContext().getMaximumPacketLength()) {
                throw new SshException("Invalid message length in SFTP protocol [" + len + "]", 3);
            }
            byte[] msg = ByteArrays.getInstance().getByteArray();
            this.in.readFully(msg, 0, len);
            return msg;
        }
        catch (OutOfMemoryError ex) {
            throw new SshException("Invalid message length in SFTP protocol [" + len + "]", 3);
        }
        catch (EOFException ex) {
            this.getSession().close();
            throw new SshException("The channel unexpectedly terminated", 6);
        }
        catch (IOException ex) {
            if (ex instanceof SshIOException) {
                throw ((SshIOException)ex).getRealException();
            }
            this.getSession().close();
            throw new SshException(6, (Throwable)ex);
        }
    }

    protected void onCloseSession(SessionChannelNG session) {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract void doSubsystemTask(SessionChannelNG var1) throws SshException;

    public void sendMessage(Packet msg) throws SshException {
        SessionChannelNG session = this.getSession();
        msg.finish();
        try {
            session.sendChannelDataAndBlock(msg.array(), 0, msg.size(), new PacketReturner(msg));
        }
        catch (IOException e) {
            Log.error((String)"Channel I/O error", (Throwable)e, (Object[])new Object[0]);
        }
    }

    class PacketReturner
    implements Runnable {
        Packet msg;

        PacketReturner(Packet msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            PacketPool.getInstance().putPacket(this.msg);
            this.msg = null;
        }
    }
}

