/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.ConnectionProtocolClient;
import com.sshtools.client.PasswordAuthenticator;
import com.sshtools.client.PublicKeyAuthenticator;
import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.tasks.AbstractCommandTask;
import com.sshtools.client.tasks.DownloadFileTask;
import com.sshtools.client.tasks.Task;
import com.sshtools.client.tasks.UploadFileTask;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventListener;
import com.sshtools.common.forwarding.ForwardingPolicy;
import com.sshtools.common.permissions.UnauthorizedException;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.ProtocolContext;
import com.sshtools.synergy.ssh.Connection;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.Set;

public class SshClient
implements Closeable {
    public static final int EXIT_CODE_NOT_RECEIVED = Integer.MIN_VALUE;
    Connection<SshClientContext> con;
    SshClientContext sshContext;
    String remotePublicKeys = "";
    String hostname;

    public SshClient(String hostname, int port, String username, long connectTimeout, char[] password) throws IOException, SshException {
        this(hostname, port, username, new SshClientContext(), connectTimeout, password, new SshKeyPair[0]);
    }

    public SshClient(String hostname, int port, String username, char[] password) throws IOException, SshException {
        this(hostname, port, username, new SshClientContext(), 30000L, password, new SshKeyPair[0]);
    }

    public SshClient(String hostname, int port, String username, long connectTimeout, File key) throws IOException, SshException, InvalidPassphraseException {
        this(hostname, port, username, connectTimeout, key, null);
    }

    public SshClient(String hostname, int port, String username, File key) throws IOException, SshException, InvalidPassphraseException {
        this(hostname, port, username, 30000L, key, null);
    }

    public SshClient(String hostname, int port, String username, long connectTimeout, File key, String passphrase) throws IOException, SshException, InvalidPassphraseException {
        this(hostname, port, username, connectTimeout, SshKeyUtils.getPrivateKey((File)key, (String)passphrase));
    }

    public SshClient(String hostname, int port, String username, File key, String passphrase) throws IOException, SshException, InvalidPassphraseException {
        this(hostname, port, username, 30000L, SshKeyUtils.getPrivateKey((File)key, (String)passphrase));
    }

    public SshClient(String hostname, int port, String username, long connectTimeout, SshKeyPair ... identities) throws IOException, SshException, InvalidPassphraseException {
        this(hostname, port, username, new SshClientContext(), connectTimeout, identities);
    }

    public SshClient(String hostname, int port, String username, SshKeyPair ... identities) throws IOException, SshException, InvalidPassphraseException {
        this(hostname, port, username, new SshClientContext(), 30000L, identities);
    }

    public SshClient(String hostname, int port, String username, SshClientContext sshContext, long connectTimeout, SshKeyPair ... identities) throws IOException, SshException {
        this(hostname, port, username, sshContext, connectTimeout, (char[])null, identities);
    }

    public SshClient(String hostname, int port, String username, SshClientContext sshContext, SshKeyPair ... identities) throws IOException, SshException {
        this(hostname, port, username, sshContext, 30000L, (char[])null, identities);
    }

    public SshClient(String hostname, int port, String username, long connectTimeout, char[] password, SshKeyPair ... identities) throws IOException, SshException {
        this(hostname, port, username, new SshClientContext(), connectTimeout, password, identities);
    }

    public SshClient(String hostname, int port, String username, char[] password, SshKeyPair ... identities) throws IOException, SshException {
        this(hostname, port, username, new SshClientContext(), 30000L, password, identities);
    }

    public SshClient(String hostname, Integer port, String username, long connectTimeout, char[] password, File key, String passphrase) throws IOException, SshException, InvalidPassphraseException {
        this(hostname, (int)port, username, connectTimeout, password, SshKeyUtils.getPrivateKey((File)key, (String)passphrase));
    }

    public SshClient(String hostname, Integer port, String username, char[] password, File key, String passphrase) throws IOException, SshException, InvalidPassphraseException {
        this(hostname, (int)port, username, 30000L, password, SshKeyUtils.getPrivateKey((File)key, (String)passphrase));
    }

    public SshClient(String hostname, Integer port, String username, long connectTimeout) throws IOException, SshException {
        this(hostname, port, username, new SshClientContext(), connectTimeout);
    }

    public SshClient(String hostname, Integer port, String username) throws IOException, SshException {
        this(hostname, port, username, new SshClientContext(), 30000L);
    }

    public SshClient(String hostname, Integer port, String username, SshClientContext sshContext, long connectTimeout) throws IOException, SshException {
        this(hostname, (int)port, username, sshContext, connectTimeout, (char[])null, new SshKeyPair[0]);
    }

    public SshClient(String hostname, Integer port, String username, SshClientContext sshContext) throws IOException, SshException {
        this(hostname, (int)port, username, sshContext, 30000L, (char[])null, new SshKeyPair[0]);
    }

    public SshClient(String hostname, int port, String username, SshClientContext sshContext, long connectTimeout, char[] password, SshKeyPair ... identities) throws IOException, SshException {
        this.sshContext = sshContext;
        this.hostname = hostname;
        sshContext.setUsername(username);
        this.doConnect(hostname, port, username, sshContext, connectTimeout);
        boolean attempted = false;
        if (!this.isAuthenticated() && identities.length > 0) {
            attempted = true;
            this.authenticate(new PublicKeyAuthenticator(identities), 30000L);
        }
        if (!this.isAuthenticated() && Objects.nonNull(password) && password.length > 0) {
            attempted = true;
            this.authenticate(new PasswordAuthenticator(password), 30000L);
        }
        if (attempted && !this.isAuthenticated()) {
            this.close();
            throw new IOException("Authentication failed");
        }
    }

    protected void doConnect(String hostname, int port, String username, SshClientContext sshContext, long connectTimeout) throws SshException, IOException {
        this.configure(sshContext);
        ConnectRequestFuture future = sshContext.getEngine().connect(hostname, port, (ProtocolContext)sshContext);
        future.waitFor(connectTimeout);
        if (!future.isSuccess()) {
            throw new IOException(String.format("Failed to connect to %s:%d", hostname, port));
        }
        this.con = future.getConnection();
        this.con.addEventListener(new EventListener(){

            public void processEvent(Event evt) {
                switch (evt.getId()) {
                    case -16777211: {
                        SshClient.this.remotePublicKeys = (String)evt.getAttribute("REMOTE_PUBLICKEYS");
                        break;
                    }
                    case -16776961: {
                        SshClient.this.disconnect();
                        break;
                    }
                }
            }
        });
        if (!sshContext.getAuthenticators().isEmpty()) {
            this.con.getAuthenticatedFuture().waitForever();
            if (!this.con.getAuthenticatedFuture().isSuccess()) {
                this.close();
                throw new IOException(String.format("Failed to authenticate user %s at %s:%d", username, hostname, port));
            }
        }
    }

    protected void configure(SshClientContext sshContext) throws SshException, IOException {
    }

    public synchronized void addTask(Task task) throws IOException {
        if (this.con == null) {
            throw new IOException("Client is no longer connected!");
        }
        this.con.addTask((ConnectionAwareTask)task);
    }

    @Override
    public void close() throws IOException {
        this.con.disconnect();
    }

    public SshClientContext getContext() {
        return (SshClientContext)this.con.getContext();
    }

    public Connection<SshClientContext> getConnection() {
        return this.con;
    }

    public ForwardingPolicy getForwardingPolicy() {
        return ((SshClientContext)this.con.getContext()).getForwardingPolicy();
    }

    public int startLocalForwarding(String addressToBind, int portToBind, String destinationHost, int destinationPort) throws UnauthorizedException, SshException {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        return client.startLocalForwarding(addressToBind, portToBind, destinationHost, destinationPort);
    }

    public void stopLocalForwarding(String addressToBind, int portToBind) {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        client.stopLocalForwarding(addressToBind, portToBind);
    }

    public void stopLocalForwarding() {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        client.stopLocalForwarding();
    }

    public int startRemoteForwarding(String addressToBind, int portToBind, String destinationHost, int destinationPort) throws SshException {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        return client.startRemoteForwarding(addressToBind, portToBind, destinationHost, destinationPort);
    }

    public void stopRemoteForwarding(String addressToBind, int portToBind) throws SshException {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        client.stopRemoteForwarding(addressToBind, portToBind);
    }

    public void stopRemoteForwarding() {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        client.stopRemoteForwarding();
    }

    public boolean isConnected() {
        return !this.con.isDisconnected();
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.con.disconnect();
        }
    }

    protected <T extends Task> T doTask(T task, long timeout) throws IOException {
        this.addTask(task);
        if (timeout > 0L) {
            task.waitFor(timeout);
        } else {
            task.waitForever();
        }
        if (!task.isDone()) {
            throw new IOException("Task did not complete before the specified timeout");
        }
        if (!task.isSuccess()) {
            if (!Objects.isNull(task.getLastError())) {
                throw new IOException("Task did not succeed", task.getLastError());
            }
            throw new IOException("Task did not succeed and did not report an error");
        }
        return task;
    }

    public File getFile(String path) throws IOException {
        return this.getFile(path, 0L);
    }

    public File getFile(String path, long timeout) throws IOException {
        return this.doTask(new DownloadFileTask(this.getConnection(), path), timeout).getDownloadedFile();
    }

    public void getFile(String path, File destination) throws IOException {
        this.getFile(path, destination, 0L);
    }

    public void getFile(String path, File destination, long timeout) throws IOException {
        this.doTask(new DownloadFileTask(this.getConnection(), path, destination), timeout);
    }

    public void putFile(File file) throws IOException {
        this.putFile(file, file.getName(), 0L);
    }

    public void putFile(File file, String path) throws IOException {
        this.putFile(file, path, 0L);
    }

    public void putFile(File file, String path, long timeout) throws IOException {
        this.doTask(new UploadFileTask(this.getConnection(), file, path), timeout);
    }

    public String executeCommand(String cmd) throws IOException {
        return this.executeCommand(cmd, 0L, "UTF-8");
    }

    public String executeCommand(String cmd, long timeout) throws IOException {
        return this.executeCommand(cmd, timeout, "UTF-8");
    }

    public String executeCommand(String cmd, String charset) throws IOException {
        return this.executeCommand(cmd, 0L, charset);
    }

    public String executeCommand(String cmd, long timeout, String charset) throws IOException {
        StringBuffer buffer = new StringBuffer();
        this.executeCommandWithResult(cmd, buffer, timeout, charset);
        return buffer.toString();
    }

    public int executeCommandWithResult(String cmd, StringBuffer buffer) throws IOException {
        return this.executeCommandWithResult(cmd, buffer, 0L);
    }

    public int executeCommandWithResult(String cmd, StringBuffer buffer, long timeout) throws IOException {
        return this.executeCommandWithResult(cmd, buffer, timeout, "UTF-8");
    }

    public int executeCommandWithResult(String cmd, StringBuffer buffer, String charset) throws IOException {
        return this.executeCommandWithResult(cmd, buffer, 0L, charset);
    }

    public int executeCommandWithResult(String cmd, final StringBuffer buffer, long timeout, final String charset) throws IOException {
        AbstractCommandTask task = new AbstractCommandTask((SshConnection)this.getConnection(), cmd){

            @Override
            protected void onOpenSession(SessionChannelNG session) throws IOException {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(session.getInputStream(), charset));
                while ((line = reader.readLine()) != null) {
                    if (buffer.length() > 0) {
                        buffer.append(System.lineSeparator());
                    }
                    buffer.append(line);
                }
            }
        };
        this.doTask(task, timeout);
        return task.getExitCode();
    }

    public Set<String> getAuthenticationMethods() {
        return this.sshContext.getAuthenticationClient().getSupportedAuthentications();
    }

    public boolean authenticate(ClientAuthenticator authenticator, long timeout) throws IOException, SshException {
        this.sshContext.getAuthenticationClient().addAuthentication(authenticator);
        authenticator.waitFor(timeout);
        if (authenticator.isCancelled()) {
            throw new SshException("Authentication cancelled.", 8);
        }
        return authenticator.isDone() && authenticator.isSuccess();
    }

    public boolean isAuthenticated() {
        return this.con.getAuthenticatedFuture().isDone() && this.con.getAuthenticatedFuture().isSuccess();
    }

    public <T extends Task> void runTask(T task, long timeout) throws IOException {
        this.doTask(task, timeout);
    }

    public <T extends Task> void runTask(T task) throws IOException {
        this.doTask(task, 0L);
    }

    public String[] getRemotePublicKeys() {
        return this.remotePublicKeys.split(",");
    }

    public String getRemoteIdentification() {
        return this.con.getRemoteIdentification();
    }

    public String getLocalIdentification() {
        return this.con.getLocalIdentification();
    }

    public String getHost() {
        return this.hostname;
    }

    public SshPublicKey getHostKey() {
        return this.con.getHostKey();
    }

    public SessionChannelNG openSessionChannel() throws SshException {
        return this.openSessionChannel(60000L, false);
    }

    public SessionChannelNG openSessionChannel(long timeout) throws SshException {
        return this.openSessionChannel(timeout, false);
    }

    public SessionChannelNG openSessionChannel(boolean autoConsume) throws SshException {
        return this.openSessionChannel(60000L, autoConsume);
    }

    public SessionChannelNG openSessionChannel(long timeout, boolean autoConsume) throws SshException {
        SessionChannelNG session = new SessionChannelNG((SshConnection)this.con, autoConsume);
        this.con.openChannel((Channel)session);
        session.getOpenFuture().waitFor(timeout);
        if (session.getOpenFuture().isSuccess()) {
            return session;
        }
        throw new SshException(String.format("Session was not opened after %d ms timeout threshold", timeout), 19);
    }
}

