/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.client.SshClient;
import com.sshtools.client.sftp.DirectoryOperation;
import com.sshtools.client.sftp.GlobRegExpMatching;
import com.sshtools.client.sftp.NoRegExpMatching;
import com.sshtools.client.sftp.RegExpMatching;
import com.sshtools.client.sftp.RegularExpressionMatching;
import com.sshtools.client.sftp.SftpChannel;
import com.sshtools.client.sftp.SftpFile;
import com.sshtools.client.sftp.SftpFileInputStream;
import com.sshtools.client.sftp.SftpFileOutputStream;
import com.sshtools.client.sftp.SftpMessage;
import com.sshtools.client.sftp.StatVfs;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.direct.DirectFileFactory;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.GlobSftpFileFilter;
import com.sshtools.common.sftp.RegexSftpFileFilter;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.EOLProcessor;
import com.sshtools.common.util.FileUtils;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpClient {
    SftpChannel sftp;
    String cwd;
    AbstractFile lcwd;
    AbstractFileFactory<?> fileFactory;
    private int blocksize = 16384;
    private int asyncRequests = 16;
    private int buffersize = 1024000;
    int umask = 18;
    boolean applyUmask = false;
    public static final int MODE_BINARY = 1;
    public static final int MODE_TEXT = 2;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final int EOL_CR = 3;
    private int outputEOL = 1;
    private int inputEOL = 0;
    private boolean stripEOL = false;
    private boolean forceRemoteEOL;
    private int transferMode = 1;
    private Vector<String> customRoots = new Vector();
    public static final int NoSyntax = 0;
    public static final int GlobSyntax = 1;
    public static final int Perl5Syntax = 2;
    private int RegExpSyntax = 1;

    public SftpClient(SshConnection con) throws SshException, PermissionDeniedException, IOException {
        this(con, (AbstractFileFactory<?>)new DirectFileFactory(new File(System.getProperty("user.home"))));
    }

    public SftpClient(SshConnection con, AbstractFileFactory<?> fileFactory) throws PermissionDeniedException, IOException, SshException {
        this.fileFactory = fileFactory;
        this.cwd = "";
        this.lcwd = fileFactory.getFile("");
        this.sftp = new SftpChannel(con);
    }

    public SftpClient(SshClient ssh) throws SshException, PermissionDeniedException, IOException {
        this((SshConnection)ssh.getConnection());
    }

    public SftpClient(SshClient ssh, AbstractFileFactory<?> fileFactory) throws SshException, PermissionDeniedException, IOException {
        this((SshConnection)ssh.getConnection(), fileFactory);
    }

    public void setBlockSize(int blocksize) {
        if (blocksize < 512) {
            throw new IllegalArgumentException("Block size must be greater than 512");
        }
        this.blocksize = blocksize;
    }

    public SftpChannel getSubsystemChannel() {
        return this.sftp;
    }

    public void setTransferMode(int transferMode) {
        if (transferMode != 1 && transferMode != 2) {
            throw new IllegalArgumentException("Mode can only be either binary or text");
        }
        this.transferMode = transferMode;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Transfer mode set to " + (transferMode == 1 ? "binary" : "text")), (Object[])new Object[0]);
        }
    }

    public void setStripEOL(boolean stripEOL) {
        this.stripEOL = stripEOL;
    }

    public void setRemoteEOL(int eolMode) {
        this.outputEOL = eolMode;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Remote EOL set to " + (eolMode == 1 ? "CRLF" : (eolMode == 3 ? "CR" : "LF"))), (Object[])new Object[0]);
        }
    }

    public void setLocalEOL(int eolMode) {
        this.inputEOL = eolMode;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Input EOL set to " + (eolMode == 1 ? "CRLF" : (eolMode == 3 ? "CR" : "LF"))), (Object[])new Object[0]);
        }
    }

    public void setForceRemoteEOL(boolean forceRemoteEOL) {
        this.forceRemoteEOL = forceRemoteEOL;
    }

    public int getTransferMode() {
        return this.transferMode;
    }

    public void setBufferSize(int buffersize) {
        this.buffersize = buffersize;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Buffer size set to " + buffersize), (Object[])new Object[0]);
        }
    }

    public void setMaxAsyncRequests(int asyncRequests) {
        if (asyncRequests < 1) {
            throw new IllegalArgumentException("Maximum asynchronous requests must be greater or equal to 1");
        }
        this.asyncRequests = asyncRequests;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Max async requests set to " + asyncRequests), (Object[])new Object[0]);
        }
    }

    public int umask(int umask) {
        this.applyUmask = true;
        int old = this.umask;
        this.umask = umask;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("umask " + umask), (Object[])new Object[0]);
        }
        return old;
    }

    public SftpFile openFile(String fileName) throws SftpStatusException, SshException {
        return this.openFile(fileName, 1);
    }

    public SftpFile openFile(String fileName, int flags) throws SftpStatusException, SshException {
        if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
            return this.sftp.openFile(this.resolveRemotePath(fileName), flags | 0x40);
        }
        return this.sftp.openFile(this.resolveRemotePath(fileName), flags);
    }

    public SftpFile openDirectory(String path) throws SftpStatusException, SshException {
        return this.sftp.openDirectory(path);
    }

    public List<SftpFile> readDirectory(SftpFile dir) throws SftpStatusException, SshException {
        ArrayList<SftpFile> results = new ArrayList<SftpFile>();
        if (this.sftp.listChildren(dir, results) == -1) {
            return null;
        }
        return results;
    }

    public void cd(String dir) throws SftpStatusException, SshException {
        SftpFileAttributes attr;
        String actual;
        if (dir == null || dir.equals("")) {
            actual = this.sftp.getDefaultDirectory();
        } else {
            actual = this.resolveRemotePath(dir);
            actual = this.sftp.getAbsolutePath(actual);
        }
        if (!actual.equals("") && !(attr = this.sftp.getAttributes(actual)).isDirectory()) {
            throw new SftpStatusException(4, dir + " is not a directory");
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Changing dir from " + this.cwd + " to " + (actual.equals("") ? "user default dir" : actual)), (Object[])new Object[0]);
        }
        this.cwd = actual;
    }

    public String getDefaultDirectory() throws SftpStatusException, SshException {
        return this.sftp.getDefaultDirectory();
    }

    public void cdup() throws SftpStatusException, SshException {
        SftpFile cd = this.sftp.getFile(this.cwd);
        SftpFile parent = cd.getParent();
        if (parent != null) {
            this.cwd = parent.getAbsolutePath();
        }
    }

    private AbstractFile resolveLocalPath(String path) throws IOException, PermissionDeniedException {
        return this.lcwd.resolveFile(path);
    }

    private boolean isWindowsRoot(String path) {
        return path.length() > 2 && ((path.charAt(0) >= 'a' && path.charAt(0) <= 'z' || path.charAt(0) >= 'A' && path.charAt(0) <= 'Z') && path.charAt(1) == ':' && path.charAt(2) == '/' || path.charAt(2) == '\\');
    }

    public void addCustomRoot(String rootPath) {
        this.customRoots.addElement(rootPath);
    }

    public void removeCustomRoot(String rootPath) {
        this.customRoots.removeElement(rootPath);
    }

    private boolean startsWithCustomRoot(String path) {
        Enumeration<String> it = this.customRoots.elements();
        while (it != null && it.hasMoreElements()) {
            if (!path.startsWith(it.nextElement())) continue;
            return true;
        }
        return false;
    }

    private String resolveRemotePath(String path) throws SftpStatusException, SshException {
        this.verifyConnection();
        String actual = !path.startsWith("/") && !path.startsWith(this.cwd) && !this.isWindowsRoot(path) && !this.startsWithCustomRoot(path) ? this.cwd + (this.cwd.endsWith("/") ? "" : "/") + path : path;
        if (!actual.equals("/") && actual.endsWith("/")) {
            return actual.substring(0, actual.length() - 1);
        }
        return actual;
    }

    private void verifyConnection() throws SshException {
        if (this.sftp.isClosed()) {
            throw new SshException("The SFTP connection has been closed", 2);
        }
    }

    public void mkdir(String dir) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(dir);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Creating dir " + dir), (Object[])new Object[0]);
        }
        SftpFileAttributes attrs = null;
        try {
            attrs = this.sftp.getAttributes(actual);
        }
        catch (SftpStatusException ex) {
            SftpFileAttributes newattrs = new SftpFileAttributes(2, this.sftp.getCharsetEncoding());
            if (this.applyUmask) {
                newattrs.setPermissions(new UnsignedInteger32((long)(0x1FF ^ this.umask)));
            }
            this.sftp.makeDirectory(actual, newattrs);
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("File with name " + dir + " already exists!"), (Object[])new Object[0]);
        }
        throw new SftpStatusException(4, (attrs.isDirectory() ? "Directory" : "File") + " already exists named " + dir);
    }

    public void mkdirs(String dir) throws SftpStatusException, SshException {
        String path;
        StringTokenizer tokens = new StringTokenizer(dir, "/");
        String string = path = dir.startsWith("/") ? "/" : "";
        while (tokens.hasMoreElements()) {
            block5: {
                path = path + (String)tokens.nextElement();
                try {
                    this.stat(path);
                }
                catch (SftpStatusException ex) {
                    try {
                        this.mkdir(path);
                    }
                    catch (SftpStatusException ex2) {
                        if (ex2.getStatus() != 3) break block5;
                        throw ex2;
                    }
                }
            }
            path = path + "/";
        }
    }

    public boolean isDirectoryOrLinkedDirectory(SftpFile file) throws SftpStatusException, SshException {
        return file.isDirectory() || file.isLink() && this.stat(file.getAbsolutePath()).isDirectory();
    }

    public String pwd() throws SftpStatusException, SshException {
        return this.getAbsolutePath(this.cwd);
    }

    public SftpFile[] ls() throws SftpStatusException, SshException {
        return this.ls(this.cwd);
    }

    public SftpFile[] ls(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Listing files for " + actual), (Object[])new Object[0]);
        }
        SftpFile file = this.sftp.openDirectory(actual);
        Vector<SftpFile> children = new Vector<SftpFile>();
        while (this.sftp.listChildren(file, children) > -1) {
        }
        file.close();
        SftpFile[] files = new SftpFile[children.size()];
        int index = 0;
        Enumeration<SftpFile> e = children.elements();
        while (e.hasMoreElements()) {
            files[index++] = e.nextElement();
        }
        return files;
    }

    public SftpFile[] ls(String filter, boolean regexFilter, int maximumFiles) throws SftpStatusException, SshException {
        return this.ls("", filter, regexFilter, maximumFiles);
    }

    public SftpFile[] ls(String path, String filter, boolean regexFilter, int maximumFiles) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Listing files for {} with filter {}", (Object[])new Object[0]);
        }
        ByteArrayWriter msg = new ByteArrayWriter();
        try {
            int pageCount;
            byte[] handle;
            msg.writeString(actual);
            msg.writeString(filter);
            msg.writeBoolean(regexFilter);
            boolean localFiltering = false;
            try {
                handle = this.sftp.getHandleResponse(this.sftp.sendExtensionMessage("open-directory-with-filter@sshtools.com", msg.toByteArray()));
            }
            catch (SftpStatusException e) {
                if (Boolean.getBoolean("maverick.disableLocalFiltering")) {
                    throw new SshException("Remote server does not support server side filtering", 57351);
                }
                handle = this.sftp.openDirectory(actual).getHandle();
            }
            RegexSftpFileFilter f = null;
            if (localFiltering) {
                f = regexFilter ? new RegexSftpFileFilter(filter) : new GlobSftpFileFilter(filter);
            }
            SftpFile file = new SftpFile(actual, this.sftp.getAttributes(actual));
            file.setHandle(handle);
            file.setSFTPSubsystem(this.sftp);
            Vector<SftpFile> children = new Vector<SftpFile>();
            Vector<SftpFile> tmp = new Vector<SftpFile>();
            do {
                if ((pageCount = this.sftp.listChildren(file, tmp)) <= -1) continue;
                if (!localFiltering) {
                    if (pageCount > -1 && Log.isDebugEnabled()) {
                        Log.debug((String)"Got page of {} files for {} with filter {}", (Object[])new Object[]{pageCount, actual, filter, localFiltering});
                    }
                    children.addAll(tmp);
                    continue;
                }
                if (pageCount > -1 && Log.isDebugEnabled()) {
                    Log.debug((String)"Got page of {} files for {} before local filtering", (Object[])new Object[]{pageCount, actual, filter, localFiltering});
                }
                int count = 0;
                for (SftpFile t : tmp) {
                    if (!f.matches(t.getFilename())) continue;
                    children.add(t);
                    ++count;
                }
                if (pageCount <= -1 || !Log.isDebugEnabled()) continue;
                Log.debug((String)"Got page of {} files for {} after local filtering", (Object[])new Object[]{count, actual, filter, localFiltering});
            } while (pageCount > -1 && (maximumFiles == 0 || children.size() < maximumFiles));
            file.close();
            SftpFile[] files = new SftpFile[children.size()];
            int index = 0;
            Enumeration e = children.elements();
            while (e.hasMoreElements()) {
                files[index++] = (SftpFile)e.nextElement();
            }
            SftpFile[] sftpFileArray = files;
            return sftpFileArray;
        }
        catch (IOException e) {
            throw new SshException(5, (Throwable)e);
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Iterator<SftpFile> lsIterator() throws SftpStatusException, SshException {
        return this.lsIterator(this.cwd);
    }

    public Iterator<SftpFile> lsIterator(String path) throws SftpStatusException, SshException {
        return new DirectoryIterator(path);
    }

    public void lcd(String path) throws SftpStatusException, IOException, PermissionDeniedException {
        AbstractFile actual = this.lcwd.resolveFile(path);
        if (!actual.isDirectory()) {
            throw new SftpStatusException(4, path + " is not a directory");
        }
        this.lcwd = actual;
    }

    public String lpwd() throws IOException, PermissionDeniedException {
        return this.lcwd.getAbsolutePath();
    }

    public SftpFileAttributes get(String path, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(path, progress, false);
    }

    public SftpFileAttributes get(String path, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        String localfile = path.lastIndexOf("/") > -1 ? path.substring(path.lastIndexOf("/") + 1) : path;
        return this.get(path, localfile, progress, resume);
    }

    public SftpFileAttributes get(String path, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(path, (FileTransferProgress)null, resume);
    }

    public SftpFileAttributes get(String path) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(path, (FileTransferProgress)null);
    }

    public String getSymbolicLinkTarget(String linkpath) throws SftpStatusException, SshException {
        return this.sftp.getSymbolicLinkTarget(linkpath);
    }

    public SftpFileAttributes get(String remote, String local, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(remote, local, progress, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SftpFileAttributes get(String remote, String local, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        SftpFileAttributes sftpFileAttributes;
        OutputStream out = null;
        SftpFileAttributes attrs = null;
        AbstractFile localPath = this.resolveLocalPath(local);
        if (!localPath.exists()) {
            AbstractFile parent = localPath.resolveFile(FileUtils.getParentPath((String)localPath.getAbsolutePath()));
            parent.createFolder();
        }
        if (localPath.isDirectory()) {
            localPath = localPath.resolveFile(FileUtils.getFilename((String)remote));
        }
        this.stat(remote);
        long position = 0L;
        try {
            if (resume && localPath.exists()) {
                out = localPath.getOutputStream(true);
                position = localPath.length();
            } else {
                out = localPath.getOutputStream();
            }
            sftpFileAttributes = attrs = this.get(remote, out, progress, position);
        }
        catch (IOException ex) {
            try {
                throw new SftpStatusException(4, "Failed to open outputstream to " + local);
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (attrs == null) throw throwable;
                    localPath.setAttributes(attrs);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (out != null) {
                out.close();
            }
            if (attrs == null) return sftpFileAttributes;
            localPath.setAttributes(attrs);
            return sftpFileAttributes;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sftpFileAttributes;
    }

    public String getRemoteNewline() throws SftpStatusException {
        return new String(this.sftp.getCanonicalNewline());
    }

    public int getRemoteEOL() throws SftpStatusException {
        return this.getEOL(this.sftp.getCanonicalNewline());
    }

    public int getEOL(String line) throws SftpStatusException {
        byte[] nl = line.getBytes();
        return this.getEOL(nl);
    }

    public int getEOL(byte[] nl) throws SftpStatusException {
        switch (nl.length) {
            case 1: {
                if (nl[0] == 13) {
                    return 3;
                }
                if (nl[0] == 10) {
                    return 2;
                }
                throw new SftpStatusException(100, "Unsupported text mode: invalid newline character");
            }
            case 2: {
                if (nl[0] == 13 && nl[1] == 10) {
                    return 1;
                }
                throw new SftpStatusException(100, "Unsupported text mode: invalid newline characters");
            }
        }
        throw new SftpStatusException(100, "Unsupported text mode: newline length > 2");
    }

    public SftpFileAttributes get(String remote, String local, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(remote, local, null, resume);
    }

    public SftpFileAttributes get(String remote, String local) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(remote, local, false);
    }

    public SftpFileAttributes get(String remote, OutputStream local, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, progress, 0L);
    }

    public void setRegularExpressionSyntax(int syntax) {
        this.RegExpSyntax = syntax;
    }

    public SftpFile[] matchRemoteFiles(String remote) throws SftpStatusException, SshException {
        SftpFile[] files;
        RegularExpressionMatching matcher;
        String actualSearch;
        String actualDir;
        int fileSeparatorIndex = remote.lastIndexOf("/");
        if (fileSeparatorIndex > -1) {
            actualDir = remote.substring(0, fileSeparatorIndex);
            actualSearch = remote.length() > fileSeparatorIndex + 1 ? remote.substring(fileSeparatorIndex + 1) : "";
        } else {
            actualDir = this.cwd;
            actualSearch = remote;
        }
        switch (this.RegExpSyntax) {
            case 1: {
                matcher = new GlobRegExpMatching();
                files = this.ls(actualDir);
                break;
            }
            case 2: {
                matcher = new RegExpMatching();
                files = this.ls(actualDir);
                break;
            }
            default: {
                matcher = new NoRegExpMatching();
                files = new SftpFile[1];
                String actual = this.resolveRemotePath(remote);
                files[0] = this.getSubsystemChannel().getFile(actual);
            }
        }
        return matcher.matchFilesWithPattern(files, actualSearch);
    }

    private SftpFile[] getFileMatches(String remote, String local, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        SftpFile[] matchedFiles = this.matchRemoteFiles(remote);
        Vector<SftpFile> retrievedFiles = new Vector<SftpFile>();
        for (int i = 0; i < matchedFiles.length; ++i) {
            this.get(matchedFiles[i].getAbsolutePath(), local, progress, resume);
            retrievedFiles.addElement(matchedFiles[i]);
        }
        Object[] retrievedSftpFiles = new SftpFile[retrievedFiles.size()];
        retrievedFiles.copyInto(retrievedSftpFiles);
        return retrievedSftpFiles;
    }

    private String[] matchLocalFiles(String local) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        AbstractFile[] files;
        RegularExpressionMatching matcher;
        String actualSearch;
        AbstractFile actualDir;
        if (FileUtils.hasParents((String)local)) {
            actualDir = this.resolveLocalPath(FileUtils.getParentPath((String)local));
            actualSearch = FileUtils.getFilename((String)local);
        } else {
            actualDir = this.lcwd;
            actualSearch = local;
        }
        switch (this.RegExpSyntax) {
            case 1: {
                matcher = new GlobRegExpMatching();
                files = this.listFiles(actualDir);
                break;
            }
            case 2: {
                matcher = new RegExpMatching();
                files = this.listFiles(actualDir);
                break;
            }
            default: {
                matcher = new NoRegExpMatching();
                files = new AbstractFile[]{this.lcwd.resolveFile(local)};
            }
        }
        return matcher.matchFileNamesWithPattern(files, actualSearch);
    }

    private AbstractFile[] listFiles(AbstractFile f) throws IOException, PermissionDeniedException {
        return f.getChildren().toArray(new AbstractFile[0]);
    }

    private void putFileMatches(String local, String remote, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        String remotePath = this.resolveRemotePath(remote);
        SftpFileAttributes attrs = null;
        try {
            attrs = this.stat(remotePath);
        }
        catch (SftpStatusException ex) {
            throw new SftpStatusException(ex.getStatus(), "Remote path '" + remote + "' does not exist. It must be a valid directory and must already exist!");
        }
        if (!attrs.isDirectory()) {
            throw new SftpStatusException(10, "Remote path '" + remote + "' is not a directory!");
        }
        String[] matchedFiles = this.matchLocalFiles(local);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Matched {} files for {}", (Object[])new Object[]{matchedFiles.length, local});
        }
        for (int i = 0; i < matchedFiles.length; ++i) {
            try {
                this.put(matchedFiles[i], remotePath, progress, resume);
                continue;
            }
            catch (SftpStatusException ex) {
                throw new SftpStatusException(ex.getStatus(), "Failed to put " + matchedFiles[i] + " to " + remote + " [" + ex.getMessage() + "]");
            }
        }
    }

    public SftpFileAttributes get(String remote, OutputStream local, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        String remotePath = this.resolveRemotePath(remote);
        SftpFileAttributes attrs = this.sftp.getAttributes(remotePath);
        if (position > attrs.getSize().longValue()) {
            throw new SftpStatusException(101, "The local file size is greater than the remote file");
        }
        if (progress != null) {
            progress.started(attrs.getSize().longValue() - position, remotePath);
        }
        SftpFile file = this.transferMode == 2 && this.sftp.getVersion() > 3 ? this.sftp.openFile(remotePath, 65) : this.sftp.openFile(remotePath, 1);
        try {
            if (this.transferMode == 2) {
                int inputStyle = this.outputEOL;
                int outputStyle = this.stripEOL ? 4 : this.inputEOL;
                byte[] nl = null;
                if (this.sftp.getVersion() <= 3 && this.sftp.getExtension("newline@vandyke.com") != null) {
                    nl = this.sftp.getExtension("newline@vandyke.com");
                } else if (this.sftp.getVersion() > 3) {
                    nl = this.sftp.getCanonicalNewline();
                }
                if (nl != null && !this.forceRemoteEOL) {
                    inputStyle = this.getEOL(new String(nl));
                }
                local = EOLProcessor.createOutputStream((int)inputStyle, (int)outputStyle, (OutputStream)local);
            }
            this.sftp.performOptimizedRead(remotePath, file.getHandle(), attrs.getSize().longValue(), this.blocksize, local, this.asyncRequests, progress, position);
        }
        catch (IOException ex) {
            throw new SftpStatusException(4, "Failed to open text conversion outputstream");
        }
        catch (TransferCancelledException tce) {
            throw tce;
        }
        finally {
            try {
                local.close();
            }
            catch (Throwable throwable) {}
            try {
                this.sftp.closeFile(file);
            }
            catch (SftpStatusException sftpStatusException) {}
        }
        if (progress != null) {
            progress.completed();
        }
        return attrs;
    }

    public InputStream getInputStream(String remotefile, long position) throws SftpStatusException, SshException {
        String remotePath = this.resolveRemotePath(remotefile);
        this.sftp.getAttributes(remotePath);
        return new SftpFileInputStream(this.sftp.openFile(remotePath, 1), position);
    }

    public InputStream getInputStream(String remotefile) throws SftpStatusException, SshException {
        return this.getInputStream(remotefile, 0L);
    }

    public SftpFileAttributes get(String remote, OutputStream local, long position) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, null, position);
    }

    public SftpFileAttributes get(String remote, OutputStream local) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, null, 0L);
    }

    public boolean isClosed() {
        return this.sftp.isClosed();
    }

    public void put(String local, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        AbstractFile f = this.resolveLocalPath(local);
        this.put(local, f.getName(), progress, resume);
    }

    public void put(String local, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, progress, false);
    }

    public void put(String local) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, false);
    }

    public void put(String local, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, (FileTransferProgress)null, resume);
    }

    public void put(String local, String remote, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, remote, progress, false);
    }

    public void append(InputStream in, String remote) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, null, -1L);
    }

    public void append(InputStream in, String remote, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, progress, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String local, String remote, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        AbstractFile localPath = this.resolveLocalPath(local);
        InputStream in = localPath.getInputStream();
        long position = 0L;
        SftpFileAttributes attrs = null;
        try {
            attrs = this.stat(remote);
            if (attrs.isDirectory()) {
                remote = remote + (remote.endsWith("/") ? "" : "/") + localPath.getName();
                attrs = this.stat(remote);
            }
        }
        catch (SftpStatusException ex) {
            resume = false;
        }
        if (resume) {
            if (localPath.length() <= attrs.getSize().longValue()) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw new SftpStatusException(101, "The remote file size is greater than the local file");
            }
            try {
                position = attrs.getSize().longValue();
                in.skip(position);
            }
            catch (IOException ex) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new SftpStatusException(2, ex.getMessage());
            }
        }
        try {
            this.put(in, remote, progress, position);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void append(String local, String remote) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.append(local, remote, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String local, String remote, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        AbstractFile localPath = this.resolveLocalPath(local);
        String remotePath = this.resolveRemotePath(remote);
        this.stat(remotePath);
        InputStream in = localPath.getInputStream();
        try {
            this.append(in, remotePath, progress);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void put(String local, String remote, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, remote, null, resume);
    }

    public void put(String local, String remote) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, remote, null, false);
    }

    public void put(InputStream in, String remote, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, progress, 0L);
    }

    public void put(InputStream in, String remote, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        String remotePath = this.resolveRemotePath(remote);
        SftpFileAttributes attrs = null;
        if (this.transferMode == 2) {
            int inputStyle = this.stripEOL ? 4 : this.inputEOL;
            int outputStyle = this.outputEOL;
            byte[] nl = null;
            if (this.sftp.getVersion() <= 3 && this.sftp.getExtension("newline@vandyke.com") != null) {
                nl = this.sftp.getExtension("newline@vandyke.com");
            } else if (this.sftp.getVersion() > 3) {
                nl = this.sftp.getCanonicalNewline();
            }
            if (nl != null & !this.forceRemoteEOL) {
                outputStyle = this.getEOL(nl);
            }
            try {
                in = EOLProcessor.createInputStream((int)inputStyle, (int)outputStyle, (InputStream)in);
            }
            catch (IOException ex) {
                throw new SshException("Failed to create EOL processing stream", 5);
            }
        }
        attrs = new SftpFileAttributes(1, "UTF-8");
        if (this.applyUmask) {
            attrs.setPermissions(new UnsignedInteger32((long)(0x1B6 ^ this.umask)));
        }
        if (position > 0L) {
            if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
                throw new SftpStatusException(8, "Resume on text mode files is not supported");
            }
            this.internalPut(in, remotePath, progress, position, 2, attrs);
        } else if (position == 0L) {
            if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
                this.internalPut(in, remotePath, progress, position, 90, attrs);
            } else {
                this.internalPut(in, remotePath, progress, position, 26, attrs);
            }
        } else if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
            this.internalPut(in, remotePath, progress, position, 70, attrs);
        } else {
            this.internalPut(in, remotePath, progress, position, 6, attrs);
        }
    }

    private void internalPut(InputStream in, String remotePath, FileTransferProgress progress, long position, int flags, SftpFileAttributes attrs) throws SftpStatusException, SshException, TransferCancelledException {
        SftpFile file = this.sftp.openFile(remotePath, flags, attrs);
        if (progress != null) {
            try {
                progress.started(in.available(), remotePath);
            }
            catch (IOException ex1) {
                throw new SshException("Failed to determine local file size", 5);
            }
        }
        try {
            this.sftp.performOptimizedWrite(remotePath, file.getHandle(), this.blocksize, this.asyncRequests, in, this.buffersize, progress, position < 0L ? 0L : position);
        }
        catch (SftpStatusException e) {
            Log.error((String)("SFTP status exception during transfer [" + e.getStatus() + "]"), (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
        catch (SshException e) {
            Log.error((String)("SSH exception during transfer [" + e.getReason() + "]"), (Throwable)e, (Object[])new Object[0]);
            if (e.getCause() != null) {
                Log.error((String)"SSH exception cause", (Throwable)e.getCause(), (Object[])new Object[0]);
            }
            throw e;
        }
        catch (TransferCancelledException e) {
            Log.error((String)"Transfer cancelled", (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
            this.sftp.closeFile(file);
        }
        if (progress != null) {
            progress.completed();
        }
    }

    public OutputStream getOutputStream(String remotefile) throws SftpStatusException, SshException {
        String remotePath = this.resolveRemotePath(remotefile);
        return new SftpFileOutputStream(this.sftp.openFile(remotePath, 26));
    }

    public void put(InputStream in, String remote, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, null, position);
    }

    public void put(InputStream in, String remote) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, null, 0L);
    }

    public void chown(String uid, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        SftpFileAttributes newAttrs = new SftpFileAttributes(attrs.getType(), this.sftp.getCharsetEncoding());
        newAttrs.setUID(uid);
        if (this.sftp.getVersion() <= 3) {
            newAttrs.setGID(attrs.getGID());
        }
        this.sftp.setAttributes(actual, newAttrs);
    }

    public void chgrp(String gid, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        SftpFileAttributes newAttrs = new SftpFileAttributes(attrs.getType(), this.sftp.getCharsetEncoding());
        newAttrs.setGID(gid);
        if (this.sftp.getVersion() <= 3) {
            newAttrs.setUID(attrs.getUID());
        }
        this.sftp.setAttributes(actual, newAttrs);
    }

    public void chmod(int permissions, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        this.sftp.changePermissions(actual, permissions);
    }

    public void umask(String umask) throws SshException {
        try {
            this.umask = Integer.parseInt(umask, 8);
            this.applyUmask = true;
        }
        catch (NumberFormatException ex) {
            throw new SshException("umask must be 4 digit octal number e.g. 0022", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldpath, String newpath, boolean posix) throws IOException, SftpStatusException, SshException {
        if (posix) {
            try (ByteArrayWriter msg = new ByteArrayWriter();){
                msg.writeString(this.resolveRemotePath(oldpath));
                msg.writeString(this.resolveRemotePath(newpath));
                this.sftp.getOKRequestStatus(this.sftp.sendExtensionMessage("posix-rename@openssh.com", msg.toByteArray()));
            }
        } else {
            this.rename(oldpath, newpath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyRemoteFile(String sourceFile, String destinationFile, boolean overwriteDestination) throws SftpStatusException, SshException, IOException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(this.resolveRemotePath(sourceFile));
            msg.writeString(this.resolveRemotePath(destinationFile));
            msg.writeBoolean(overwriteDestination);
            this.sftp.getOKRequestStatus(this.sftp.sendExtensionMessage("copy-file", msg.toByteArray()));
        }
    }

    public void copyRemoteData(SftpFile sourceFile, UnsignedInteger64 fromOffset, UnsignedInteger64 length, SftpFile destinationFile, UnsignedInteger64 toOffset) throws SftpStatusException, SshException, IOException {
        if (!sourceFile.isOpen() || !destinationFile.isOpen()) {
            throw new SftpStatusException(9, "source and desintation files must be open");
        }
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeBinaryString(sourceFile.getHandle());
            msg.writeUINT64(fromOffset);
            msg.writeUINT64(length);
            msg.writeBinaryString(destinationFile.getHandle());
            msg.writeUINT64(toOffset);
            this.sftp.getOKRequestStatus(this.sftp.sendExtensionMessage("copy-data", msg.toByteArray()));
        }
    }

    public void rename(String oldpath, String newpath) throws SftpStatusException, SshException {
        String from = this.resolveRemotePath(oldpath);
        String to = this.resolveRemotePath(newpath);
        SftpFileAttributes attrs = null;
        try {
            attrs = this.sftp.getAttributes(to);
        }
        catch (SftpStatusException ex) {
            this.sftp.renameFile(from, to);
            return;
        }
        if (attrs == null || !attrs.isDirectory()) {
            throw new SftpStatusException(11, newpath + " already exists on the remote filesystem");
        }
        this.sftp.renameFile(from, FileUtils.checkEndsWithSlash((String)to) + FileUtils.lastPathElement((String)from));
    }

    public void rm(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        if (attrs.isDirectory()) {
            this.sftp.removeDirectory(actual);
        } else {
            this.sftp.removeFile(actual);
        }
    }

    public void rm(String path, boolean force, boolean recurse) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = null;
        attrs = this.sftp.getAttributes(actual);
        if (attrs.isDirectory()) {
            SftpFile[] list = this.ls(path);
            if (!force && list.length > 0) {
                throw new SftpStatusException(4, "You cannot delete non-empty directory, use force=true to overide");
            }
            for (int i = 0; i < list.length; ++i) {
                SftpFile file = list[i];
                if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                    if (recurse) {
                        this.rm(file.getAbsolutePath(), force, recurse);
                        continue;
                    }
                    throw new SftpStatusException(4, "Directory has contents, cannot delete without recurse=true");
                }
                if (!file.isFile() && !file.isLink()) continue;
                this.sftp.removeFile(file.getAbsolutePath());
            }
            this.sftp.removeDirectory(actual);
        } else {
            this.sftp.removeFile(actual);
        }
    }

    public void symlink(String path, String link) throws SftpStatusException, SshException {
        String actualPath = this.resolveRemotePath(path);
        String actualLink = this.resolveRemotePath(link);
        this.sftp.createSymbolicLink(actualLink, actualPath);
    }

    public SftpFileAttributes stat(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAttributes(actual);
    }

    public SftpFileAttributes statLink(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getLinkAttributes(actual);
    }

    public String getAbsolutePath(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAbsolutePath(actual);
    }

    public boolean verifyFiles(String localFile, String remoteFile) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        return this.verifyFiles(localFile, remoteFile, 0L, 0L);
    }

    public boolean verifyFiles(String localFile, String remoteFile, long offset, long length) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        AbstractFile local = this.resolveLocalPath(localFile);
        if (!local.exists()) {
            throw new IOException("Local file " + localFile + " does not exist!");
        }
        DigestInputStream dis = null;
        ByteArrayWriter msg = new ByteArrayWriter();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(local.getInputStream(), md);
            if (offset > 0L) {
                dis.skip(offset);
            }
            byte[] buf = new byte[Math.min(2048, (int)length)];
            dis.read(buf);
            byte[] digest = md.digest();
            dis.close();
            msg.writeString(this.resolveRemotePath(remoteFile));
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            msg.writeBinaryString(digest);
            byte[] remoteHash = this.getRemoteHash(remoteFile, offset, length, digest);
            md.reset();
            dis = new DigestInputStream(local.getInputStream(), md);
            while (dis.read(buf) > -1) {
            }
            byte[] localHash = md.digest();
            boolean bl = Arrays.equals(remoteHash, localHash);
            return bl;
        }
        catch (NoSuchAlgorithmException e1) {
            throw new SshException(5, (Throwable)e1);
        }
        catch (IOException e1) {
            throw new SshException(5, (Throwable)e1);
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] getRemoteHash(String remoteFile) throws IOException, SftpStatusException, SshException {
        return this.getRemoteHash(remoteFile, 0L, 0L, new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRemoteHash(String remoteFile, long offset, long length, byte[] quickCheck) throws IOException, SftpStatusException, SshException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(this.resolveRemotePath(remoteFile));
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            msg.writeBinaryString(quickCheck);
            SftpMessage resp = this.sftp.getExtensionResponse(this.sftp.sendExtensionMessage("md5-hash", msg.toByteArray()));
            resp.readString();
            byte[] byArray = resp.readBinaryString();
            return byArray;
        }
    }

    public byte[] getRemoteHash(byte[] handle) throws IOException, SftpStatusException, SshException {
        return this.getRemoteHash(handle, 0L, 0L, new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRemoteHash(byte[] handle, long offset, long length, byte[] quickCheck) throws IOException, SftpStatusException, SshException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeBinaryString(handle);
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            msg.writeBinaryString(quickCheck);
            SftpMessage resp = this.sftp.getExtensionResponse(this.sftp.sendExtensionMessage("md5-hash-handle", msg.toByteArray()));
            resp.readString();
            byte[] byArray = resp.readBinaryString();
            return byArray;
        }
    }

    public void quit() throws SshException {
        this.sftp.close();
    }

    public void exit() throws SshException {
        this.sftp.close();
    }

    public DirectoryOperation putLocalDirectory(String localdir, String remotedir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        AbstractFile[] sources;
        DirectoryOperation op = new DirectoryOperation();
        AbstractFile local = this.resolveLocalPath(localdir);
        remotedir = this.resolveRemotePath(remotedir);
        remotedir = remotedir + (remotedir.endsWith("/") ? "" : "/");
        if (commit) {
            try {
                this.sftp.getAttributes(remotedir);
            }
            catch (SftpStatusException ex) {
                this.mkdirs(remotedir);
            }
        }
        for (AbstractFile source : sources = this.listFiles(local)) {
            SftpFileAttributes attrs;
            if (source.isDirectory() && !source.getName().equals(".") && !source.getName().equals("..")) {
                if (!recurse) continue;
                op.addDirectoryOperation(this.putLocalDirectory(source.getAbsolutePath(), remotedir + source.getName(), recurse, sync, commit, progress), source);
                continue;
            }
            if (!source.isFile()) continue;
            boolean newFile = false;
            boolean unchangedFile = false;
            try {
                attrs = this.sftp.getAttributes(remotedir + source.getName());
                unchangedFile = source.length() == attrs.getSize().longValue() && source.lastModified() / 1000L == attrs.getModifiedTime().longValue();
                System.out.println(source.getName() + " is " + (unchangedFile ? "unchanged" : "changed"));
            }
            catch (SftpStatusException ex) {
                System.out.println(source.getName() + " is new");
                newFile = true;
            }
            try {
                if (commit && !unchangedFile) {
                    this.put(source.getAbsolutePath(), remotedir + source.getName(), progress);
                    attrs = this.sftp.getAttributes(remotedir + source.getName());
                    attrs.setTimes(new UnsignedInteger64(source.lastModified() / 1000L), new UnsignedInteger64(source.lastModified() / 1000L));
                    this.sftp.setAttributes(remotedir + source.getName(), attrs);
                }
                if (unchangedFile) {
                    op.addUnchangedFile(source);
                    continue;
                }
                if (!newFile) {
                    op.addUpdatedFile(source);
                    continue;
                }
                op.addNewFile(source);
            }
            catch (SftpStatusException ex) {
                op.addFailedTransfer(source, ex);
            }
        }
        if (sync) {
            try {
                SftpFile[] files = this.ls(remotedir);
                for (int i = 0; i < files.length; ++i) {
                    SftpFile file = files[i];
                    AbstractFile f = local.resolveFile(file.getFilename());
                    if (op.containsFile(f) || file.getFilename().equals(".") || file.getFilename().equals("..")) continue;
                    op.addDeletedFile(file);
                    if (!commit) continue;
                    if (file.isDirectory()) {
                        this.recurseMarkForDeletion(file, op);
                        if (!commit) continue;
                        this.rm(file.getAbsolutePath(), true, true);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    this.rm(file.getAbsolutePath());
                }
            }
            catch (SftpStatusException sftpStatusException) {
                // empty catch block
            }
        }
        return op;
    }

    private String[] getChildNames(AbstractFile local) throws IOException, PermissionDeniedException {
        ArrayList<String> children = new ArrayList<String>();
        for (AbstractFile child : local.getChildren()) {
            children.add(child.getName());
        }
        return children.toArray(new String[0]);
    }

    private void recurseMarkForDeletion(SftpFile file, DirectoryOperation op) throws SftpStatusException, SshException {
        SftpFile[] list = this.ls(file.getAbsolutePath());
        op.addDeletedFile(file);
        for (int i = 0; i < list.length; ++i) {
            file = list[i];
            if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                this.recurseMarkForDeletion(file, op);
                continue;
            }
            if (!file.isFile()) continue;
            op.addDeletedFile(file);
        }
    }

    private void recurseMarkForDeletion(AbstractFile file, DirectoryOperation op) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        String[] list = this.getChildNames(file);
        op.addDeletedFile(file);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if ((file = file.resolveFile(list[i])).isDirectory() && !file.getName().equals(".") && !file.getName().equals("..")) {
                    this.recurseMarkForDeletion(file, op);
                    continue;
                }
                if (!file.isFile()) continue;
                op.addDeletedFile(file);
            }
        }
    }

    public static String formatLongname(SftpFile file) throws SftpStatusException, SshException {
        return SftpClient.formatLongname(file.getAttributes(), file.getFilename());
    }

    public static String formatLongname(SftpFileAttributes attrs, String filename) {
        StringBuffer str = new StringBuffer();
        str.append(SftpClient.pad(10 - attrs.getPermissionsString().length()) + attrs.getPermissionsString());
        str.append("    1 ");
        str.append(attrs.getUID() + SftpClient.pad(8 - attrs.getUID().length()));
        str.append(" ");
        str.append(attrs.getGID() + SftpClient.pad(8 - attrs.getGID().length()));
        str.append(" ");
        str.append(SftpClient.pad(8 - attrs.getSize().toString().length()) + attrs.getSize().toString());
        str.append(" ");
        str.append(SftpClient.pad(12 - SftpClient.getModTimeString(attrs.getModifiedTime()).length()) + SftpClient.getModTimeString(attrs.getModifiedTime()));
        str.append(" ");
        str.append(filename);
        return str.toString();
    }

    private static String getModTimeString(UnsignedInteger64 mtime) {
        if (mtime == null) {
            return "";
        }
        long mt = mtime.longValue() * 1000L;
        long now = System.currentTimeMillis();
        SimpleDateFormat df = now - mt > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
        return df.format(new Date(mt));
    }

    private static String pad(int num) {
        StringBuffer strBuf = new StringBuffer("");
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                strBuf.append(" ");
            }
        }
        return strBuf.toString();
    }

    public DirectoryOperation getRemoteDirectory(String remotedir, String localdir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        String[] contents;
        AbstractFile local;
        int idx;
        DirectoryOperation op = new DirectoryOperation();
        String pwd = this.pwd();
        this.cd(remotedir);
        String base = remotedir;
        if (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        if ((idx = base.lastIndexOf(47)) != -1) {
            base = base.substring(idx + 1);
        }
        if (!(local = this.resolveLocalPath(localdir)).exists() && commit) {
            local.createFolder();
        }
        SftpFile[] files = this.ls();
        for (int i = 0; i < files.length; ++i) {
            AbstractFile f;
            SftpFile file = files[i];
            System.out.println("Process: " + file.getAbsolutePath());
            if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                if (!recurse) continue;
                System.out.println("   is dir " + file.getAbsolutePath());
                f = local.resolveFile(file.getFilename());
                op.addDirectoryOperation(this.getRemoteDirectory(file.getFilename(), local.getAbsolutePath() + "/" + file.getFilename(), recurse, sync, commit, progress), f);
                continue;
            }
            if (!file.isFile()) continue;
            f = local.resolveFile(file.getFilename());
            System.out.println("   file " + f.getAbsolutePath() + " (exists " + f.exists() + ") len: " + f.length() + " vs " + file.getAttributes().getSize().longValue() + " date: " + f.lastModified() / 1000L + " vs " + file.getAttributes().getModifiedTime().longValue());
            if (f.exists() && f.length() == file.getAttributes().getSize().longValue() && f.lastModified() / 1000L == file.getAttributes().getModifiedTime().longValue()) {
                System.out.println("   is unchanged " + file.getAbsolutePath());
                if (commit) {
                    op.addUnchangedFile(f);
                    continue;
                }
                op.addUnchangedFile(file);
                continue;
            }
            try {
                if (f.exists()) {
                    System.out.println("   is updated " + file.getAbsolutePath());
                    if (commit) {
                        op.addUpdatedFile(f);
                    } else {
                        op.addUpdatedFile(file);
                    }
                } else {
                    System.out.println("   is new " + file.getAbsolutePath());
                    if (commit) {
                        op.addNewFile(f);
                    } else {
                        op.addNewFile(file);
                    }
                }
                if (!commit) continue;
                System.out.println("   get " + file.getAbsolutePath());
                this.get(file.getFilename(), f.getAbsolutePath(), progress);
                continue;
            }
            catch (SftpStatusException ex) {
                op.addFailedTransfer(f, ex);
            }
        }
        if (sync && (contents = this.getChildNames(local)) != null) {
            for (int i = 0; i < contents.length; ++i) {
                AbstractFile f2 = local.resolveFile(contents[i]);
                if (op.containsFile(f2)) continue;
                op.addDeletedFile(f2);
                if (f2.isDirectory() && !f2.getName().equals(".") && !f2.getName().equals("..")) {
                    System.out.println("   delete recurse into " + f2.getAbsolutePath());
                    this.recurseMarkForDeletion(f2, op);
                    if (!commit) continue;
                    f2.delete(true);
                    continue;
                }
                if (!commit) continue;
                System.out.println("   delete " + f2.getAbsolutePath());
                f2.delete(false);
            }
        }
        this.cd(pwd);
        return op;
    }

    public SftpFile[] getFiles(String remote) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, (FileTransferProgress)null);
    }

    public SftpFile[] getFiles(String remote, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, (FileTransferProgress)null, resume);
    }

    public SftpFile[] getFiles(String remote, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, progress, false);
    }

    public SftpFile[] getFiles(String remote, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, this.lcwd.getAbsolutePath(), progress, resume);
    }

    public SftpFile[] getFiles(String remote, String local) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, local, false);
    }

    public SftpFile[] getFiles(String remote, String local, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, local, null, resume);
    }

    public SftpFile[] getFiles(String remote, String local, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFileMatches(remote, local, progress, resume);
    }

    public void putFiles(String local) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, false);
    }

    public void putFiles(String local, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, (FileTransferProgress)null, resume);
    }

    public void putFiles(String local, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, progress, false);
    }

    public void putFiles(String local, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, this.pwd(), progress, resume);
    }

    public void putFiles(String local, String remote) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, remote, null, false);
    }

    public void putFiles(String local, String remote, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, remote, null, resume);
    }

    public void putFiles(String local, String remote, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, remote, progress, false);
    }

    public void putFiles(String local, String remote, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFileMatches(local, remote, progress, resume);
    }

    public boolean isConnected() {
        return this.sftp.isClosed();
    }

    public void hardlink(String src, String dst) throws SshException, SftpStatusException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(src);
            msg.writeString(dst);
            SftpChannel channel = this.getSubsystemChannel();
            UnsignedInteger32 requestId = channel.sendExtensionMessage("hardlink@openssh.com", msg.toByteArray());
            channel.getOKRequestStatus(requestId);
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHomeDirectory(String username) throws SshException, SftpStatusException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(username);
            SftpChannel channel = this.getSubsystemChannel();
            UnsignedInteger32 requestId = channel.sendExtensionMessage("home-directory", msg.toByteArray());
            String string = channel.getSingleFileResponse(channel.getResponse(requestId), "SSH_FXP_NAME").getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    public String makeTemporaryFolder() throws SshException, SftpStatusException {
        SftpChannel channel = this.getSubsystemChannel();
        UnsignedInteger32 requestId = channel.sendExtensionMessage("make-temp-folder", null);
        return channel.getSingleFileResponse(channel.getResponse(requestId), "SSH_FXP_NAME").getAbsolutePath();
    }

    public String getTemporaryFolder() throws SshException, SftpStatusException {
        SftpChannel channel = this.getSubsystemChannel();
        UnsignedInteger32 requestId = channel.sendExtensionMessage("get-temp-folder", null);
        return channel.getSingleFileResponse(channel.getResponse(requestId), "SSH_FXP_NAME").getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StatVfs statVFS(String path) throws SshException, SftpStatusException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(path);
            SftpChannel channel = this.getSubsystemChannel();
            UnsignedInteger32 requestId = channel.sendExtensionMessage("statvfs@openssh.com", msg.toByteArray());
            StatVfs statVfs = new StatVfs(channel.getResponse(requestId));
            return statVfs;
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    public String getHome() throws SftpStatusException, SshException {
        return this.getAbsolutePath("");
    }

    class DirectoryIterator
    implements Iterator<SftpFile> {
        SftpFile currentFolder;
        Vector<SftpFile> currentPage = new Vector();
        Iterator<SftpFile> currentIterator;

        DirectoryIterator(String path) throws SftpStatusException, SshException {
            String actual = SftpClient.this.resolveRemotePath(path);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Listing files for " + actual), (Object[])new Object[0]);
            }
            this.currentFolder = SftpClient.this.sftp.openDirectory(actual);
            try {
                this.getNextPage();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }

        private void getNextPage() throws SftpStatusException, SshException, EOFException {
            this.currentPage.clear();
            int ret = SftpClient.this.sftp.listChildren(this.currentFolder, this.currentPage);
            if (ret == -1) {
                this.currentIterator = null;
                throw new EOFException();
            }
            this.currentIterator = this.currentPage.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public SftpFile next() {
            if (this.currentIterator == null) {
                throw new NoSuchElementException();
            }
            SftpFile ret = null;
            if (this.currentIterator.hasNext()) {
                ret = this.currentIterator.next();
            }
            if (!this.currentIterator.hasNext()) {
                try {
                    this.getNextPage();
                }
                catch (EOFException e) {
                    if (ret == null) {
                        throw new NoSuchElementException();
                    }
                }
                catch (SftpStatusException | SshException e) {
                    throw new NoSuchElementException(e.getMessage());
                }
                if (ret == null) {
                    ret = this.currentIterator.next();
                }
            }
            return ret;
        }
    }

    static class RandomAccessFileOutputStream
    extends OutputStream {
        RandomAccessFile file;

        RandomAccessFileOutputStream(RandomAccessFile file) {
            this.file = file;
        }

        @Override
        public void write(int b) throws IOException {
            this.file.write(b);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.file.write(buf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }
}

