/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.client.sftp.RegularExpressionMatching;
import com.sshtools.client.sftp.SftpFile;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.SshException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;

public class GlobRegExpMatching
implements RegularExpressionMatching {
    @Override
    public SftpFile[] matchFilesWithPattern(SftpFile[] files, String pattern) throws SftpStatusException, SshException {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        ArrayList<SftpFile> matched = new ArrayList<SftpFile>();
        for (SftpFile file : files) {
            if (!matcher.matches(Paths.get(file.filename, new String[0]))) continue;
            matched.add(file);
        }
        return matched.toArray(new SftpFile[0]);
    }

    @Override
    public String[] matchFileNamesWithPattern(AbstractFile[] files, String pattern) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        ArrayList<String> matched = new ArrayList<String>();
        for (AbstractFile file : files) {
            Path path = Paths.get(file.getName(), new String[0]);
            if (!matcher.matches(path)) continue;
            matched.add(file.getAbsolutePath());
        }
        return matched.toArray(new String[0]);
    }
}

