/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.PublicKeyAuthenticator;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.publickey.SshPrivateKeyFileFactory;
import com.sshtools.common.ssh.components.SshKeyPair;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class PrivateKeyFileAuthenticator
extends PublicKeyAuthenticator {
    File keyfile;
    String passphrase;

    public PrivateKeyFileAuthenticator(File keyfile, String passphrase) {
        this.keyfile = keyfile;
        this.passphrase = passphrase;
    }

    public PrivateKeyFileAuthenticator(File keyfile) {
        this.keyfile = keyfile;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    @Override
    public void authenticate(TransportProtocolClient transport, String username) {
        try {
            SshPrivateKeyFile privateKeyFile = SshPrivateKeyFileFactory.parse((InputStream)new FileInputStream(this.keyfile));
            SshKeyPair pair = privateKeyFile.isPassphraseProtected() ? privateKeyFile.toKeyPair(this.getPassphrase()) : privateKeyFile.toKeyPair(null);
            this.setKeyPair(pair);
            super.authenticate(transport, username);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

