/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.AuthenticationMessage;
import com.sshtools.client.SimpleClientAuthenticator;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.ssh.SshException;
import com.sshtools.synergy.util.EncodingUtils;
import java.nio.ByteBuffer;
import java.util.Objects;

public class PasswordAuthenticator
extends SimpleClientAuthenticator {
    String password;

    public PasswordAuthenticator() {
    }

    public PasswordAuthenticator(String password) {
        this.password = password;
    }

    public PasswordAuthenticator(char[] password) {
        this.password = new String(password);
    }

    public String getPassword() {
        return this.password;
    }

    private byte[] getPasswordBytes() {
        return EncodingUtils.getUTF8Bytes((String)this.getPassword());
    }

    @Override
    public void authenticate(TransportProtocolClient transport, String username) throws SshException {
        final byte[] tmp = this.getPasswordBytes();
        if (Objects.isNull(tmp)) {
            this.cancel();
            return;
        }
        transport.postMessage(new AuthenticationMessage(username, "ssh-connection", "password"){

            @Override
            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                super.writeMessageIntoBuffer(buf);
                buf.put((byte)0);
                buf.putInt(tmp.length);
                buf.put(tmp);
                return true;
            }
        });
    }

    @Override
    public String getName() {
        return "password";
    }
}

