/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.ClientStateListener;
import com.sshtools.client.ConnectionProtocolClient;
import com.sshtools.client.KeyboardInteractiveAuthenticator;
import com.sshtools.client.NoneAuthenticator;
import com.sshtools.client.PasswordAuthenticator;
import com.sshtools.client.PasswordOverKeyboardInteractiveCallback;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventListener;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.Service;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

public class AuthenticationProtocolClient
implements Service {
    public static final int SSH_MSG_USERAUTH_REQUEST = 50;
    public static final int SSH_MSG_USERAUTH_FAILURE = 51;
    public static final int SSH_MSG_USERAUTH_SUCCESS = 52;
    public static final int SSH_MSG_USERAUTH_BANNER = 53;
    int authIndex = 0;
    TransportProtocolClient transport;
    SshClientContext context;
    String username;
    LinkedList<ClientAuthenticator> authenticators = new LinkedList();
    ClientAuthenticator currentAuthenticator;
    Set<String> supportedAuths = null;
    boolean authenticated = false;
    NoneAuthenticator noneAuthenticator = new NoneAuthenticator();

    public AuthenticationProtocolClient(final TransportProtocolClient transport, final SshClientContext context, String username) {
        this.transport = transport;
        this.context = context;
        this.username = username;
        transport.getConnection().setUsername(username);
        transport.addTask(ExecutorOperationSupport.EVENTS, (ConnectionAwareTask)new ConnectionTaskWrapper((SshConnection)transport.getConnection(), new Runnable(){

            @Override
            public void run() {
                for (ClientStateListener stateListener : context.getStateListeners()) {
                    stateListener.authenticationStarted(AuthenticationProtocolClient.this, (SshConnection)transport.getConnection());
                }
            }
        }));
        transport.getConnection().addEventListener(new EventListener(){

            public void processEvent(Event evt) {
                switch (evt.getId()) {
                    case -16776961: {
                        if (Objects.nonNull(AuthenticationProtocolClient.this.currentAuthenticator)) {
                            if (!AuthenticationProtocolClient.this.currentAuthenticator.isDone()) {
                                AuthenticationProtocolClient.this.currentAuthenticator.failure();
                            }
                            AuthenticationProtocolClient.this.currentAuthenticator = null;
                        }
                        AuthenticationProtocolClient.this.authenticators.clear();
                        if (transport.getConnection().getAuthenticatedFuture().isDone()) break;
                        transport.getConnection().getAuthenticatedFuture().done(false);
                        break;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMessage(byte[] msg) throws IOException, SshException {
        try (ByteArrayReader bar = new ByteArrayReader(msg);){
            if (this.currentAuthenticator != null) {
                if (this.currentAuthenticator.processMessage(bar)) {
                    boolean bl = true;
                    return bl;
                }
                bar.reset();
            }
            bar.skip(1L);
            switch (msg[0]) {
                case 52: {
                    this.authenticated = true;
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"SSH_MSG_USERAUTH_SUCCESS received", (Object[])new Object[0]);
                    }
                    ConnectionProtocolClient con = new ConnectionProtocolClient(this.transport, this.username);
                    this.stop();
                    this.transport.setActiveService((Service)con);
                    con.start();
                    this.currentAuthenticator.success();
                    boolean bl = true;
                    return bl;
                }
                case 51: {
                    String auths = bar.readString();
                    final boolean partial = bar.readBoolean();
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("SSH_MSG_USERAUTH_FAILURE received auths=" + auths), (Object[])new Object[0]);
                    }
                    StringTokenizer t = new StringTokenizer(auths, ",");
                    this.supportedAuths = new HashSet<String>();
                    while (t.hasMoreTokens()) {
                        this.supportedAuths.add(t.nextToken());
                    }
                    if (this.currentAuthenticator.getName().equals("none")) {
                        this.transport.getConnectFuture().connected((ProtocolEngine)this.transport, this.transport.getConnection());
                    }
                    if (partial) {
                        this.currentAuthenticator.success(true, auths.split(","));
                    } else {
                        this.currentAuthenticator.failure();
                    }
                    if (!this.doNextAuthentication()) {
                        this.transport.addTask(ExecutorOperationSupport.EVENTS, (ConnectionAwareTask)new ConnectionTaskWrapper((SshConnection)this.transport.getConnection(), new Runnable(){

                            @Override
                            public void run() {
                                for (ClientStateListener stateListener : AuthenticationProtocolClient.this.context.getStateListeners()) {
                                    stateListener.authenticate(AuthenticationProtocolClient.this, (SshConnection)AuthenticationProtocolClient.this.transport.getConnection(), AuthenticationProtocolClient.this.supportedAuths, partial);
                                }
                            }
                        }));
                    }
                    boolean bl = true;
                    return bl;
                }
                case 53: {
                    String banner = bar.readString();
                    if (this.context.getBannerDisplay() != null) {
                        this.context.getBannerDisplay().displayBanner(banner);
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"SSH_MSG_USERAUTH_BANNER received", (Object[])new Object[0]);
                        Log.debug((String)bar.readString(), (Object[])new Object[0]);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public void start() throws SshException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Starting Authentication Protocol", (Object[])new Object[0]);
        }
        try {
            this.authenticators.add(this.noneAuthenticator);
            if (!this.context.getAuthenticators().isEmpty()) {
                this.authenticators.addAll(this.context.getAuthenticators());
            }
            this.doNextAuthentication();
        }
        catch (IOException e) {
            Log.error((String)"Faild to send none authentication request", (Throwable)e, (Object[])new Object[0]);
            this.transport.disconnected();
        }
    }

    public synchronized boolean doNextAuthentication() throws IOException, SshException {
        if (!this.authenticators.isEmpty()) {
            this.currentAuthenticator = this.authenticators.removeFirst();
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Starting {} authentication", (Object[])new Object[]{this.currentAuthenticator.getName()});
            }
            this.currentAuthenticator.authenticate(this.transport, this.username);
            return true;
        }
        return false;
    }

    public void stop() {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Stopping Authentication Protocol", (Object[])new Object[0]);
        }
    }

    public String getName() {
        return "ssh-userauth";
    }

    public int getIdleTimeoutSeconds() {
        return ((SshClientContext)this.transport.getContext()).getIdleAuthenticationTimeoutSeconds();
    }

    public boolean idle() {
        this.transport.disconnect(11, "Idle unauthenticated connection");
        return true;
    }

    public synchronized void addAuthentication(Collection<ClientAuthenticator> auths) throws IOException, SshException {
        for (ClientAuthenticator auth : auths) {
            this.addAuthentication(auth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthentication(final ClientAuthenticator authenticator) throws IOException, SshException {
        this.checkReady();
        AuthenticationProtocolClient authenticationProtocolClient = this;
        synchronized (authenticationProtocolClient) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Adding {} authentication", (Object[])new Object[]{authenticator.getName()});
            }
            boolean start = this.authenticators.isEmpty();
            if (authenticator instanceof PasswordAuthenticator) {
                if (this.supportedAuths.contains("keyboard-interactive") && this.context.getPreferKeyboardInteractiveOverPassword()) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"We prefer keyboard-interactive over password so injecting keyboard-interactive authenticator", (Object[])new Object[0]);
                    }
                    this.authenticators.addLast(new KeyboardInteractiveAuthenticator(new PasswordOverKeyboardInteractiveCallback(((PasswordAuthenticator)authenticator).getPassword())){

                        public synchronized void done(boolean success) {
                            if (success || !success && !AuthenticationProtocolClient.this.supportedAuths.contains("password")) {
                                ((PasswordAuthenticator)authenticator).done(success);
                            }
                            super.done(success);
                        }
                    });
                    if (this.supportedAuths.contains("password")) {
                        this.authenticators.addLast(authenticator);
                    }
                } else {
                    this.authenticators.addLast(authenticator);
                }
            } else {
                this.authenticators.addLast(authenticator);
            }
            if (start) {
                this.doNextAuthentication();
            }
        }
    }

    private void checkReady() throws IOException {
        if (!this.noneAuthenticator.isDone()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Authentication protocol is NOT ready", (Object[])new Object[0]);
            }
            this.noneAuthenticator.waitFor(30000L);
            if (!this.noneAuthenticator.isDone()) {
                throw new IOException("Timeout waiting for authentication protocol to start");
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Authentication protocol is ready", (Object[])new Object[0]);
            }
        }
    }

    public Set<String> getSupportedAuthentications() {
        return this.supportedAuths;
    }
}

