/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.AbstractSessionChannel;
import com.sshtools.client.SshClient;
import com.sshtools.client.shell.ShellTimeoutException;
import com.sshtools.client.tasks.Task;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.ChannelRequestFuture;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import java.io.IOException;
import java.util.Objects;

public abstract class AbstractSessionTask<T extends AbstractSessionChannel>
extends Task {
    long timeout = 10000L;
    T session;
    ChannelRequestFuture future;
    Throwable lastError;

    public AbstractSessionTask(SshClient ssh, ChannelRequestFuture future) {
        super(ssh);
        this.future = future;
    }

    public AbstractSessionTask(SshConnection con, ChannelRequestFuture future) {
        super(con);
        this.future = future;
    }

    public AbstractSessionTask(SshConnection con) {
        this(con, new ChannelRequestFuture());
    }

    public T getSession() {
        return this.session;
    }

    public void disconnect() {
        this.con.disconnect();
    }

    public final Throwable getLastError() {
        return this.lastError;
    }

    public ChannelRequestFuture getChannelFuture() {
        return this.future;
    }

    public void doTask() {
        this.session = this.createSession(this.con);
        this.con.openChannel(this.session);
        if (!this.session.getOpenFuture().waitFor(this.timeout).isSuccess()) {
            throw new IllegalStateException("Could not open session channel");
        }
        this.setupSession(this.session);
        try {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Starting session task", (Object[])new Object[0]);
            }
            this.onOpenSession(this.session);
        }
        catch (Throwable ex) {
            this.lastError = ex;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Ending session task", (Object[])new Object[0]);
        }
        this.session.close();
        this.onCloseSession(this.session);
        this.done(Objects.isNull(this.lastError));
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Session task is done success={}", (Object[])new Object[]{String.valueOf(Objects.isNull(this.lastError))});
        }
    }

    protected abstract T createSession(SshConnection var1);

    protected abstract void setupSession(T var1);

    protected abstract void onOpenSession(T var1) throws IOException, SshException, ShellTimeoutException;

    protected abstract void onCloseSession(T var1);

    public void close() {
        this.session.close();
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public void changeTerminalDimensions(int cols, int rows, int width, int height) {
        ((AbstractSessionChannel)((Object)this.session)).changeTerminalDimensions(cols, rows, width, height);
    }
}

