/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.sftp.SftpFile;
import com.sshtools.client.sftp.SftpMessage;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.AbstractSubsystem;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.client.tasks.MessageHolder;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.ssh.RequestFuture;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import com.sshtools.synergy.ssh.ByteArrays;
import com.sshtools.synergy.ssh.PacketPool;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpChannel
extends AbstractSubsystem {
    private String CHARSET_ENCODING = "UTF-8";
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int OPEN_TEXT = 64;
    static final int STATUS_FX_OK = 0;
    static final int STATUS_FX_EOF = 1;
    static final int SSH_FXP_INIT = 1;
    static final int SSH_FXP_VERSION = 2;
    static final int SSH_FXP_OPEN = 3;
    static final int SSH_FXP_CLOSE = 4;
    static final int SSH_FXP_READ = 5;
    static final int SSH_FXP_WRITE = 6;
    static final int SSH_FXP_LSTAT = 7;
    static final int SSH_FXP_FSTAT = 8;
    static final int SSH_FXP_SETSTAT = 9;
    static final int SSH_FXP_FSETSTAT = 10;
    static final int SSH_FXP_OPENDIR = 11;
    static final int SSH_FXP_READDIR = 12;
    static final int SSH_FXP_REMOVE = 13;
    static final int SSH_FXP_MKDIR = 14;
    static final int SSH_FXP_RMDIR = 15;
    static final int SSH_FXP_REALPATH = 16;
    static final int SSH_FXP_STAT = 17;
    static final int SSH_FXP_RENAME = 18;
    static final int SSH_FXP_READLINK = 19;
    static final int SSH_FXP_SYMLINK = 20;
    static final int SSH_FXP_LINK = 21;
    static final int SSH_FXP_BLOCK = 22;
    static final int SSH_FXP_UNBLOCK = 23;
    public static final int SSH_FXP_STATUS = 101;
    public static final int SSH_FXP_HANDLE = 102;
    public static final int SSH_FXP_DATA = 103;
    public static final int SSH_FXP_NAME = 104;
    public static final int SSH_FXP_ATTRS = 105;
    public static final int SSH_FXP_EXTENDED = 200;
    public static final int SSH_FXP_EXTENDED_REPLY = 201;
    public static final int MAX_VERSION = 6;
    Long supportedAttributeMask;
    Long supportedAttributeBits;
    Long supportedOpenFileFlags;
    Long supportedAccessMask;
    short supportedOpenBlockVector;
    short supportedBlockVector;
    Integer maxReadSize;
    Set<String> supportedExtensions = new HashSet<String>();
    Set<String> supportedAttrExtensions = new HashSet<String>();
    int version = 6;
    int serverVersion = -1;
    UnsignedInteger32 requestId = new UnsignedInteger32(0L);
    Map<UnsignedInteger32, SftpMessage> responses = new HashMap<UnsignedInteger32, SftpMessage>();
    SftpThreadSynchronizer sync = new SftpThreadSynchronizer();
    Map<String, byte[]> extensions = new HashMap<String, byte[]>();
    public static final int SSH_FXF_ACCESS_DISPOSITION = 7;
    public static final int SSH_FXF_CREATE_NEW = 0;
    public static final int SSH_FXF_CREATE_TRUNCATE = 1;
    public static final int SSH_FXF_OPEN_EXISTING = 2;
    public static final int SSH_FXF_OPEN_OR_CREATE = 3;
    public static final int SSH_FXF_TRUNCATE_EXISTING = 4;
    public static final int SSH_FXF_ACCESS_APPEND_DATA = 8;
    public static final int SSH_FXF_ACCESS_APPEND_DATA_ATOMIC = 16;
    public static final int SSH_FXF_ACCESS_TEXT_MODE = 32;
    public static final int SSH_FXF_ACCESS_BLOCK_READ = 64;
    public static final int SSH_FXF_ACCESS_BLOCK_WRITE = 128;
    public static final int SSH_FXF_ACCESS_BLOCK_DELETE = 256;
    public static final int SSH_FXF_ACCESS_BLOCK_ADVISORY = 512;
    public static final int SSH_FXF_NOFOLLOW = 1024;
    public static final int SSH_FXF_DELETE_ON_CLOSE = 2048;
    public static final int SSH_FXF_ACCESS_AUDIT_ALARM_INFO = 4096;
    public static final int SSH_FXF_ACCESS_BACKUP = 8192;
    public static final int SSH_FXF_BACKUP_STREAM = 16384;
    public static final int SSH_FXF_OVERRIDE_OWNER = 32768;
    public static final int SSH_FXP_RENAME_OVERWRITE = 1;
    public static final int SSH_FXP_RENAME_ATOMIC = 2;
    public static final int SSH_FXP_RENAME_NATIVE = 4;

    public SftpChannel(SshConnection con) throws SshException {
        super(con);
        con.setProperty("sftpVersion", (Object)this.initializeSftp(this.session));
    }

    public int getVersion() {
        return (Integer)this.con.getProperty("sftpVersion");
    }

    @Override
    protected int getMinimumWindowSize() {
        return ((FileSystemPolicy)this.con.getContext().getPolicy(FileSystemPolicy.class)).getSftpMinWindowSize();
    }

    @Override
    protected int getMaximumWindowSize() {
        return ((FileSystemPolicy)this.con.getContext().getPolicy(FileSystemPolicy.class)).getSftpMaxWindowSize();
    }

    @Override
    protected int getMaximumPacketSize() {
        return ((FileSystemPolicy)this.con.getContext().getPolicy(FileSystemPolicy.class)).getSftpMaxPacketSize();
    }

    public Map<String, byte[]> getExtensions() {
        return (Map)this.con.getProperty("sftpExtensions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private int initializeSftp(SessionChannelNG session) throws SshException {
        try {
            RequestFuture future = session.startSubsystem("sftp");
            if (!future.waitFor(this.timeout).isSuccess()) {
                throw new SshException("Could not start sftp subsystem", 10);
            }
            Packet packet = PacketPool.getInstance().getPacket();
            packet.write(1);
            packet.writeInt(6);
            this.sendMessage(packet);
            byte[] msg = this.nextMessage();
            try {
                int n;
                if (msg[0] != 2) {
                    session.close();
                    throw new SshException("Unexpected response from SFTP subsystem.", 6);
                }
                ByteArrayReader bar = new ByteArrayReader(msg);
                try {
                    bar.skip(1L);
                    int serverVersion = (int)bar.readInt();
                    int requestedVersion = 6;
                    this.version = Math.min(serverVersion, requestedVersion);
                    HashMap<String, byte[]> extensions = new HashMap<String, byte[]>();
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)("Version is " + this.version + " [Server=" + serverVersion + " Client=" + requestedVersion + "]"), (Object[])new Object[0]);
                    }
                    try {
                        while (bar.available() > 0) {
                            String name = bar.readString();
                            byte[] data = bar.readBinaryString();
                            extensions.put(name, data);
                            if (!Log.isTraceEnabled()) continue;
                            Log.trace((String)("Processed extension '" + name + "'"), (Object[])new Object[0]);
                        }
                    }
                    catch (Throwable name) {
                        // empty catch block
                    }
                    if (this.version == 5) {
                        if (extensions.containsKey("supported")) {
                            this.processSupported((byte[])extensions.get("supported"));
                        }
                    } else if (this.version >= 6 && extensions.containsKey("supported2")) {
                        this.processSupported2((byte[])extensions.get("supported2"));
                    }
                    if (this.version <= 3) {
                        this.setCharsetEncoding("ISO-8859-1");
                    } else if (extensions.containsKey("filename-charset")) {
                        String newCharset = new String((byte[])extensions.get("filename-charset"), "UTF-8");
                        try {
                            this.setCharsetEncoding(newCharset);
                            this.sendExtensionMessage("filename-translation-control", new byte[]{0});
                        }
                        catch (Exception e) {
                            this.setCharsetEncoding("UTF8");
                            this.sendExtensionMessage("filename-translation-control", new byte[]{1});
                        }
                    } else {
                        this.setCharsetEncoding("UTF8");
                    }
                    this.con.setProperty("sftpExtensions", extensions);
                    n = this.version;
                }
                catch (Throwable throwable) {
                    bar.close();
                    throw throwable;
                }
                bar.close();
                return n;
            }
            finally {
                ByteArrays.getInstance().releaseByteArray(msg);
            }
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(6, (Throwable)ex);
        }
        catch (Throwable t) {
            throw new SshException(6, t);
        }
    }

    public byte[] getCanonicalNewline() throws SftpStatusException {
        if (this.version <= 3) {
            throw new SftpStatusException(8, "Newline setting not available for SFTP versions <= 3");
        }
        if (!this.extensions.containsKey("newline")) {
            return "\r\n".getBytes();
        }
        return this.extensions.get("newline");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSupported2(byte[] data) throws IOException {
        try (ByteArrayReader supportedStructure = new ByteArrayReader(data);){
            String ext;
            int i;
            int count;
            this.supportedAttributeMask = supportedStructure.readInt();
            this.supportedAttributeBits = supportedStructure.readInt();
            this.supportedOpenFileFlags = supportedStructure.readInt();
            this.supportedAccessMask = supportedStructure.readInt();
            this.maxReadSize = (int)supportedStructure.readInt();
            this.supportedOpenBlockVector = supportedStructure.readShort();
            this.supportedBlockVector = supportedStructure.readShort();
            if (supportedStructure.available() >= 4) {
                count = (int)supportedStructure.readInt();
                for (i = 0; i < count; ++i) {
                    ext = supportedStructure.readString();
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)("Server supports '" + ext + "' attribute extension"), (Object[])new Object[0]);
                    }
                    this.supportedAttrExtensions.add(ext);
                }
            }
            if (supportedStructure.available() >= 4) {
                count = (int)supportedStructure.readInt();
                for (i = 0; i < count; ++i) {
                    ext = supportedStructure.readString();
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)("Server supports '" + ext + "' extension"), (Object[])new Object[0]);
                    }
                    this.supportedExtensions.add(ext);
                }
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)("supported-attribute-mask: " + this.supportedAttributeMask.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-attribute-bits: " + this.supportedAttributeBits.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-open-flags: " + this.supportedOpenFileFlags.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-access-mask: " + this.supportedAccessMask.toString()), (Object[])new Object[0]);
                Log.trace((String)("max-read-size: " + this.maxReadSize.toString()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSupported(byte[] data) throws IOException {
        try (ByteArrayReader supportedStructure = new ByteArrayReader(data);){
            this.supportedAttributeMask = supportedStructure.readInt();
            this.supportedAttributeBits = supportedStructure.readInt();
            this.supportedOpenFileFlags = supportedStructure.readInt();
            this.supportedAccessMask = supportedStructure.readInt();
            this.maxReadSize = (int)supportedStructure.readInt();
            if (supportedStructure.available() >= 4) {
                int count = (int)supportedStructure.readInt();
                for (int i = 0; i < count; ++i) {
                    String ext = supportedStructure.readString();
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)("Server supports '" + ext + "' extension"), (Object[])new Object[0]);
                    }
                    this.supportedExtensions.add(ext);
                }
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)("supported-attribute-mask: " + this.supportedAttributeMask.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-attribute-bits: " + this.supportedAttributeBits.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-open-flags: " + this.supportedOpenFileFlags.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-access-mask: " + this.supportedAccessMask.toString()), (Object[])new Object[0]);
                Log.trace((String)("max-read-size: " + this.maxReadSize.toString()), (Object[])new Object[0]);
            }
        }
    }

    public void setCharsetEncoding(String charset) throws SshException, UnsupportedEncodingException {
        if (this.version == -1) {
            throw new SshException("SFTP Channel must be initialized before setting character set encoding", 4);
        }
        String test = "123456890";
        test.getBytes(charset);
        this.CHARSET_ENCODING = charset;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public String getCharsetEncoding() {
        return this.CHARSET_ENCODING;
    }

    public boolean supportsExtension(String name) {
        return this.extensions.containsKey(name);
    }

    public byte[] getExtension(String name) {
        return this.extensions.get(name);
    }

    UnsignedInteger32 nextRequestId() {
        this.requestId = UnsignedInteger32.add((UnsignedInteger32)this.requestId, (int)1);
        return this.requestId;
    }

    public void close() {
        this.responses.clear();
        this.getSession().close();
    }

    public SftpMessage getResponse(UnsignedInteger32 requestId) throws SshException {
        MessageHolder holder = new MessageHolder();
        while (holder.msg == null) {
            try {
                if (!this.sync.requestBlock(requestId, holder)) continue;
                SftpMessage msg = new SftpMessage(this.nextMessage());
                this.responses.put(new UnsignedInteger32((long)msg.getMessageId()), msg);
                if (!Log.isTraceEnabled()) continue;
                Log.trace((String)("There are " + this.responses.size() + " SFTP responses waiting to be processed"), (Object[])new Object[0]);
            }
            catch (InterruptedException e) {
                this.close();
                throw new SshException("The thread was interrupted", 6);
            }
            catch (IOException ex) {
                throw new SshException(5, (Throwable)ex);
            }
            finally {
                this.sync.releaseBlock();
            }
        }
        return this.responses.remove(requestId);
    }

    public void changePermissions(SftpFile file, int permissions) throws SftpStatusException, SshException {
        SftpFileAttributes attrs = new SftpFileAttributes(5, this.getCharsetEncoding());
        attrs.setPermissions(new UnsignedInteger32((long)permissions));
        this.setAttributes(file, attrs);
    }

    public void changePermissions(String filename, int permissions) throws SftpStatusException, SshException {
        SftpFileAttributes attrs = new SftpFileAttributes(5, this.getCharsetEncoding());
        attrs.setPermissions(new UnsignedInteger32((long)permissions));
        this.setAttributes(filename, attrs);
    }

    public void changePermissions(String filename, String permissions) throws SftpStatusException, SshException {
        SftpFileAttributes attrs = new SftpFileAttributes(5, this.getCharsetEncoding());
        attrs.setPermissions(permissions);
        this.setAttributes(filename, attrs);
    }

    /*
     * Unable to fully structure code
     */
    public void getOKRequestStatus(UnsignedInteger32 requestId) throws SftpStatusException, SshException {
        bar = this.getResponse(requestId);
        try {
            if (bar.getType() != 101) ** GOTO lbl12
            status = (int)bar.readInt();
            if (status == 0) {
                return;
            }
            try {
                if (this.version >= 3) {
                    msg = bar.readString();
                    throw new SftpStatusException(status, msg);
                }
                throw new SftpStatusException(status);
lbl12:
                // 1 sources

                this.close();
                throw new SshException("The server responded with an unexpected message!", 6);
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
        finally {
            bar.release();
        }
    }

    public void setAttributes(String path, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(9);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            msg.write(attrs.toByteArray(this.getVersion()));
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex, 5);
        }
    }

    public void setAttributes(SftpFile file, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        if (!this.isValidHandle(file.getHandle())) {
            throw new SftpStatusException(100, "The handle is not an open file handle!");
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(10);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(file.getHandle());
            msg.write(attrs.toByteArray(this.getVersion()));
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public UnsignedInteger32 postWriteRequest(byte[] handle, long position, byte[] data, int off, int len) throws SftpStatusException, SshException {
        if (data.length - off < len) {
            throw new IndexOutOfBoundsException("Incorrect data array size!");
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(6);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.writeUINT64(position);
            msg.writeBinaryString(data, off, len);
            this.sendMessage(msg);
            return requestId;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void writeFile(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws SftpStatusException, SshException {
        this.getOKRequestStatus(this.postWriteRequest(handle, offset.longValue(), data, off, len));
    }

    public void performOptimizedWrite(byte[] handle, int blocksize, int outstandingRequests, InputStream in, int buffersize, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.performOptimizedWrite(handle, blocksize, outstandingRequests, in, buffersize, progress, 0L);
    }

    public void performOptimizedWrite(byte[] handle, int blocksize, int outstandingRequests, InputStream in, int buffersize, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        try {
            if (blocksize < 4096) {
                throw new SshException("Block size cannot be less than 4096", 4);
            }
            int overhead = 13 + handle.length + 8 + 4;
            if (blocksize + overhead > this.getSession().getMaximumRemotePacketLength()) {
                blocksize = this.getSession().getMaximumRemotePacketLength() - overhead;
            }
            System.setProperty("maverick.write.optimizedBlock", String.valueOf(blocksize));
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Performing optimized write length=" + in.available() + " postion=" + position + " blocksize=" + blocksize + " outstandingRequests=" + outstandingRequests), (Object[])new Object[0]);
            }
            if (position < 0L) {
                throw new SshException("Position value must be greater than zero!", 4);
            }
            if (position > 0L && progress != null) {
                progress.progressed(position);
            }
            if (buffersize <= 0) {
                buffersize = blocksize;
            }
            byte[] buf = new byte[blocksize];
            long transfered = position;
            int buffered = 0;
            buffered = in.read(buf);
            if (buffered != -1) {
                long time = System.currentTimeMillis();
                this.writeFile(handle, new UnsignedInteger64(position), buf, 0, buffered);
                time = System.currentTimeMillis() - time;
                System.setProperty("maverick.write.blockRoundtrip", String.valueOf(time));
                transfered += (long)buffered;
                if (progress != null) {
                    if (progress.isCancelled()) {
                        throw new TransferCancelledException();
                    }
                    progress.progressed(transfered);
                }
                Vector<UnsignedInteger32> requests = new Vector<UnsignedInteger32>();
                in = new BufferedInputStream(in, buffersize);
                while ((buffered = in.read(buf)) != -1) {
                    requests.addElement(this.postWriteRequest(handle, transfered, buf, 0, buffered));
                    transfered += (long)buffered;
                    if (progress == null) continue;
                    if (progress.isCancelled()) {
                        throw new TransferCancelledException();
                    }
                    progress.progressed(transfered);
                }
                while (requests.size() > 0) {
                    this.getOKRequestStatus((UnsignedInteger32)requests.remove(0));
                }
            }
        }
        catch (IOException ex) {
            throw new TransferCancelledException();
        }
        catch (OutOfMemoryError ex) {
            throw new SshException("Resource Shortage: try reducing the local file buffer size", 4);
        }
    }

    public void performOptimizedRead(byte[] handle, long length, int blocksize, OutputStream out, int outstandingRequests, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.performOptimizedRead(handle, length, blocksize, out, outstandingRequests, progress, 0L);
    }

    public void performOptimizedRead(byte[] handle, long length, int blocksize, OutputStream out, int outstandingRequests, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        int overhead;
        if (blocksize < 1 || blocksize > 65536) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Blocksize to large for some SFTP servers, reseting to 32K", (Object[])new Object[0]);
            }
            blocksize = 32768;
        }
        if (blocksize + (overhead = 13) > this.getSession().getMaximumLocalPacketLength()) {
            blocksize = this.getSession().getMaximumLocalPacketLength() - overhead;
        }
        System.setProperty("maverick.read.optimizedBlock", String.valueOf(blocksize));
        if (Log.isTraceEnabled()) {
            Log.trace((String)("Performing optimized read length=" + length + " postion=" + position + " blocksize=" + blocksize + " outstandingRequests=" + outstandingRequests), (Object[])new Object[0]);
        }
        if (length <= 0L) {
            length = Long.MAX_VALUE;
        }
        if (position < 0L) {
            throw new SshException("Position value must be greater than zero!", 4);
        }
        int completed = 0;
        long transfered = 0L;
        byte[] tmp = new byte[blocksize];
        long time = System.currentTimeMillis();
        int i = this.readFile(handle, new UnsignedInteger64(0L), tmp, 0, tmp.length);
        time = System.currentTimeMillis() - time;
        System.setProperty("maverick.read.blockRoundtrip", String.valueOf(time));
        if (i == -1) {
            return;
        }
        if ((long)i > position) {
            try {
                out.write(tmp, (int)position, (int)((long)i - position));
            }
            catch (IOException e) {
                throw new TransferCancelledException();
            }
            length -= (long)i - position;
            if (progress != null) {
                progress.progressed(transfered += (long)i - position);
            }
            position = i;
        }
        if (position + length <= (long)i) {
            return;
        }
        if (i < blocksize && length > (long)i) {
            blocksize = i;
        }
        System.setProperty("maverick.read.finalBlock", String.valueOf(blocksize));
        tmp = null;
        long numBlocks = length / (long)blocksize;
        long osr = outstandingRequests;
        Vector<UnsignedInteger32> requests = new Vector<UnsignedInteger32>(outstandingRequests);
        long offset = position;
        if (numBlocks < osr) {
            osr = numBlocks + 1L;
        }
        if (osr <= 0L) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)("We calculated zero outstanding requests! numBlocks=" + numBlocks + " outstandingRequests=" + outstandingRequests + " blocksize=" + blocksize + " length=" + length + " position=" + position), (Object[])new Object[0]);
            }
            osr = 1L;
        }
        long expected = numBlocks + 2L;
        i = 0;
        while ((long)i < osr) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Posting request for file offset " + offset), (Object[])new Object[0]);
            }
            requests.addElement(this.postReadRequest(handle, offset, blocksize));
            offset += (long)blocksize;
            if (progress != null && progress.isCancelled()) {
                throw new TransferCancelledException();
            }
            ++i;
        }
        do {
            block38: {
                UnsignedInteger32 requestId = (UnsignedInteger32)requests.elementAt(0);
                requests.removeElementAt(0);
                SftpMessage bar = this.getResponse(requestId);
                try {
                    if (bar.getType() == 103) {
                        int dataLen = (int)bar.readInt();
                        if (Log.isTraceEnabled()) {
                            Log.trace((String)("Got " + dataLen + " bytes of data"), (Object[])new Object[0]);
                        }
                        try {
                            out.write(bar.array(), bar.getPosition(), dataLen);
                        }
                        catch (IOException e) {
                            throw new TransferCancelledException();
                        }
                        ++completed;
                        if (progress != null) {
                            progress.progressed(transfered += (long)dataLen);
                        }
                        break block38;
                    }
                    if (bar.getType() == 101) {
                        int status = (int)bar.readInt();
                        if (status == 1) {
                            if (Log.isTraceEnabled()) {
                                Log.trace((String)"Received file EOF", (Object[])new Object[0]);
                            }
                            return;
                        }
                        if (this.version >= 3) {
                            String desc = bar.readString();
                            if (Log.isTraceEnabled()) {
                                Log.trace((String)("Received status " + desc), (Object[])new Object[0]);
                            }
                            throw new SftpStatusException(status, desc);
                        }
                        if (Log.isTraceEnabled()) {
                            Log.trace((String)("Received status " + status), (Object[])new Object[0]);
                        }
                        throw new SftpStatusException(status);
                    }
                    throw new SshException("The server responded with an unexpected message", 6);
                }
                catch (IOException ex) {
                    throw new SshException("Failed to read expected data from server response", 6);
                }
                finally {
                    bar.release();
                }
            }
            if (!requests.isEmpty() && (long)(completed + requests.size()) >= expected) continue;
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Posting request for file offset " + offset), (Object[])new Object[0]);
            }
            requests.addElement(this.postReadRequest(handle, offset, blocksize));
            offset += (long)blocksize;
        } while (progress == null || !progress.isCancelled());
        throw new TransferCancelledException();
    }

    public void performSynchronousRead(byte[] handle, int blocksize, OutputStream out, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        if (Log.isTraceEnabled()) {
            Log.trace((String)("Performing synchronous read postion=" + position + " blocksize=" + blocksize), (Object[])new Object[0]);
        }
        if (blocksize < 1 || blocksize > 32768) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Blocksize to large for some SFTP servers, reseting to 32K", (Object[])new Object[0]);
            }
            blocksize = 32768;
        }
        if (position < 0L) {
            throw new SshException("Position value must be greater than zero!", 4);
        }
        byte[] tmp = new byte[blocksize];
        UnsignedInteger64 offset = new UnsignedInteger64(position);
        if (position > 0L && progress != null) {
            progress.progressed(position);
        }
        try {
            int read;
            while ((read = this.readFile(handle, offset, tmp, 0, tmp.length)) > -1) {
                if (progress != null && progress.isCancelled()) {
                    throw new TransferCancelledException();
                }
                out.write(tmp, 0, read);
                offset = UnsignedInteger64.add((UnsignedInteger64)offset, (int)read);
                if (progress == null) continue;
                progress.progressed(offset.longValue());
            }
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    public UnsignedInteger32 postReadRequest(byte[] handle, long offset, int len) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(5);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.writeUINT64(offset);
            msg.writeInt(len);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_READ channel={} requestId={} offset={} blocksize={}", (Object[])new Object[]{this.session.getLocalId(), requestId.toString(), offset, len});
            }
            this.sendMessage(msg);
            return requestId;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFile(byte[] handle, UnsignedInteger64 offset, byte[] output, int off, int len) throws SftpStatusException, SshException {
        try {
            if (output.length - off < len) {
                throw new IndexOutOfBoundsException("Output array size is smaller than read length!");
            }
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(5);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.write(offset.toByteArray());
            msg.writeInt(len);
            this.sendMessage(msg);
            SftpMessage bar = this.getResponse(requestId);
            try {
                if (bar.getType() == 103) {
                    byte[] msgdata = bar.readBinaryString();
                    System.arraycopy(msgdata, 0, output, off, msgdata.length);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Received SSH_FXP_DATA channel={} requestId={} offset={} blocksize={}", (Object[])new Object[]{this.session.getLocalId(), requestId.toString(), offset.toString(), msgdata.length});
                    }
                    int n = msgdata.length;
                    return n;
                }
                if (bar.getType() == 101) {
                    int status = (int)bar.readInt();
                    if (status == 1) {
                        int n = -1;
                        return n;
                    }
                    if (this.version < 3) throw new SftpStatusException(status);
                    String desc = bar.readString();
                    throw new SftpStatusException(status, desc);
                }
                this.close();
                throw new SshException("The server responded with an unexpected message", 6);
            }
            finally {
                bar.release();
            }
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public SftpFile getFile(String path) throws SftpStatusException, SshException {
        String absolute = this.getAbsolutePath(path);
        SftpFile file = new SftpFile(absolute, this.getAttributes(absolute));
        file.sftp = this;
        return file;
    }

    public String getAbsolutePath(SftpFile file) throws SftpStatusException, SshException {
        return this.getAbsolutePath(file.getFilename());
    }

    public void lockFile(byte[] handle, long offset, long length, int lockFlags) throws SftpStatusException, SshException {
        if (this.version < 6) {
            throw new SftpStatusException(8, "Locks are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(22);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            msg.writeInt(lockFlags);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void unlockFile(byte[] handle, long offset, long length) throws SftpStatusException, SshException {
        if (this.version < 6) {
            throw new SftpStatusException(8, "Locks are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(23);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void createSymbolicLink(String targetpath, String linkpath) throws SftpStatusException, SshException {
        if (this.version < 3) {
            throw new SftpStatusException(8, "Symbolic links are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(this.version >= 6 ? 21 : 20);
            msg.writeInt(requestId.longValue());
            msg.writeString(linkpath, this.CHARSET_ENCODING);
            msg.writeString(targetpath, this.CHARSET_ENCODING);
            if (this.version >= 6) {
                msg.writeBoolean(true);
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void createLink(String targetpath, String linkpath, boolean symbolic) throws SftpStatusException, SshException {
        if (this.version < 6 && !symbolic) {
            throw new SftpStatusException(8, "Hard links are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        if (this.version < 6 && symbolic) {
            this.createSymbolicLink(targetpath, linkpath);
            return;
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(21);
            msg.writeInt(requestId.longValue());
            msg.writeString(linkpath, this.CHARSET_ENCODING);
            msg.writeString(targetpath, this.CHARSET_ENCODING);
            msg.writeBoolean(symbolic);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSymbolicLinkTarget(String linkpath) throws SftpStatusException, SshException {
        if (this.version < 3) {
            throw new SftpStatusException(8, "Symbolic links are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        UnsignedInteger32 requestId = this.nextRequestId();
        Packet msg = this.createPacket();
        msg.write(19);
        msg.writeInt(requestId.longValue());
        msg.writeString(linkpath, this.CHARSET_ENCODING);
        this.sendMessage(msg);
        SftpMessage fileMsg = this.getResponse(requestId);
        try {
            SftpFile[] files = this.extractFiles(fileMsg, null);
            String string = files[0].getAbsolutePath();
            fileMsg.release();
            return string;
        }
        catch (Throwable throwable) {
            try {
                fileMsg.release();
                throw throwable;
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
    }

    public String getDefaultDirectory() throws SftpStatusException, SshException {
        return this.getAbsolutePath("");
    }

    public String getAbsolutePath(String path) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(16);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            return this.getSingleFileResponse(this.getResponse(requestId), "SSH_FXP_REALPATH").getAbsolutePath();
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public SftpFile getSingleFileResponse(SftpMessage bar, String messageName) throws SshException, SftpStatusException {
        try {
            if (bar.getType() == 104) {
                SftpFile[] files = this.extractFiles(bar, null);
                if (files.length != 1) {
                    this.close();
                    throw new SshException("Server responded to " + messageName + " with too many files!", 6);
                }
                return files[0];
            }
            if (bar.getType() == 101) {
                int status = (int)bar.readInt();
                if (this.version >= 3) {
                    String desc = bar.readString();
                    throw new SftpStatusException(status, desc);
                }
                throw new SftpStatusException(status);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message", 6);
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int listChildren(SftpFile file, List<SftpFile> children) throws SftpStatusException, SshException {
        if (!file.isDirectory()) throw new SshException("Cannot list children for this file object", 4);
        if (!this.isValidHandle(file.getHandle()) && !this.isValidHandle((file = this.openDirectory(file.getAbsolutePath())).getHandle())) {
            throw new SftpStatusException(4, "Failed to open directory");
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(12);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(file.getHandle());
            this.sendMessage(msg);
            SftpMessage bar = this.getResponse(requestId);
            try {
                if (bar.getType() == 104) {
                    SftpFile[] files = this.extractFiles(bar, file.getAbsolutePath());
                    int i = 0;
                    while (true) {
                        if (i >= files.length) {
                            i = files.length;
                            return i;
                        }
                        children.add(files[i]);
                        ++i;
                    }
                }
                if (bar.getType() == 101) {
                    int status = (int)bar.readInt();
                    if (status == 1) {
                        int i = -1;
                        return i;
                    }
                    if (this.version < 3) throw new SftpStatusException(status);
                    String desc = bar.readString();
                    throw new SftpStatusException(status, desc);
                }
                this.close();
                throw new SshException("The server responded with an unexpected message", 6);
            }
            finally {
                bar.release();
            }
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    SftpFile[] extractFiles(SftpMessage bar, String parent) throws SshException {
        try {
            if (parent != null && !parent.endsWith("/")) {
                parent = parent + "/";
            }
            int count = (int)bar.readInt();
            SftpFile[] files = new SftpFile[count];
            String longname = null;
            for (int i = 0; i < files.length; ++i) {
                String shortname = bar.readString(this.CHARSET_ENCODING);
                if (this.version <= 3) {
                    longname = bar.readString(this.CHARSET_ENCODING);
                }
                files[i] = new SftpFile(parent != null ? parent + shortname : shortname, new SftpFileAttributes((ByteArrayReader)bar, this.getVersion(), this.getCharsetEncoding()));
                files[i].longname = longname;
                if (longname != null && this.version <= 3) {
                    try {
                        StringTokenizer t = new StringTokenizer(longname);
                        t.nextToken();
                        t.nextToken();
                        String username = t.nextToken();
                        String group = t.nextToken();
                        files[i].getAttributes().setUsername(username);
                        files[i].getAttributes().setGroup(group);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                files[i].setSFTPSubsystem(this);
            }
            return files;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void recurseMakeDirectory(String path) throws SftpStatusException, SshException {
        if (path.trim().length() > 0) {
            try {
                SftpFile file = this.openDirectory(path);
                file.close();
            }
            catch (SshException ioe) {
                int idx = 0;
                do {
                    String tmp = (idx = path.indexOf(47, idx)) > -1 ? path.substring(0, idx + 1) : path;
                    try {
                        SftpFile file = this.openDirectory(tmp);
                        file.close();
                    }
                    catch (SshException ioe7) {
                        this.makeDirectory(tmp);
                    }
                } while (idx > -1);
            }
        }
    }

    public SftpFile openFile(String absolutePath, int flags) throws SftpStatusException, SshException {
        return this.openFile(absolutePath, flags, new SftpFileAttributes(5, this.getCharsetEncoding()));
    }

    public SftpFile openFile(String absolutePath, int flags, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        if (this.version >= 5) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Converting openFile request to version 5+ format", (Object[])new Object[0]);
            }
            int accessFlags = 0;
            int newFlags = 0;
            if ((flags & 1) == 1) {
                accessFlags |= 0x81;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_READ present, adding ACE4_READ_DATA, ACE4_READ_ATTRIBUTES", (Object[])new Object[0]);
                }
            }
            if ((flags & 2) == 2) {
                accessFlags |= 2;
                accessFlags |= 0x100;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_WRITE present, adding ACE4_WRITE_DATA, ACE4_WRITE_ATTRIBUTES ", (Object[])new Object[0]);
                }
            }
            if ((flags & 4) == 4) {
                accessFlags |= 4;
                accessFlags |= 2;
                accessFlags |= 0x100;
                newFlags |= 8;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_APPEND present, adding ACE4_APPEND_DATA,ACE4_WRITE_DATA, ACE4_WRITE_ATTRIBUTES", (Object[])new Object[0]);
                }
            }
            if ((flags & 8) == 8) {
                if ((flags & 0x10) == 16) {
                    newFlags |= 1;
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)"OPEN_CREATE and OPEN_TRUNCATE present, adding SSH_FXF_CREATE_TRUNCATE", (Object[])new Object[0]);
                    }
                }
            } else {
                newFlags |= 2;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_CREATE not present, adding SSH_FXF_OPEN_EXISTING", (Object[])new Object[0]);
                }
            }
            if ((flags & 0x40) == 64) {
                newFlags |= 0x20;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_TEXT present adding SSH_FXF_ACCESS_TEXT_MODE", (Object[])new Object[0]);
                }
            }
            return this.openFileVersion5(absolutePath, newFlags, accessFlags, attrs);
        }
        if (attrs == null) {
            attrs = new SftpFileAttributes(5, this.getCharsetEncoding());
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(3);
            msg.writeInt(requestId.longValue());
            msg.writeString(absolutePath, this.CHARSET_ENCODING);
            msg.writeInt(flags);
            msg.write(attrs.toByteArray(this.getVersion()));
            this.sendMessage(msg);
            byte[] handle = this.getHandleResponse(requestId);
            SftpFile file = new SftpFile(absolutePath, null);
            file.setHandle(handle);
            file.setSFTPSubsystem(this);
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, 16711718, true).addAttribute("FILE_NAME", (Object)file.getAbsolutePath()));
            return file;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public SftpFile openFileVersion5(String absolutePath, int flags, int accessFlags, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        if (attrs == null) {
            attrs = new SftpFileAttributes(5, this.getCharsetEncoding());
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(3);
            msg.writeInt(requestId.longValue());
            msg.writeString(absolutePath, this.CHARSET_ENCODING);
            msg.writeInt(accessFlags);
            msg.writeInt(flags);
            msg.write(attrs.toByteArray(this.getVersion()));
            this.sendMessage(msg);
            byte[] handle = this.getHandleResponse(requestId);
            SftpFile file = new SftpFile(absolutePath, null);
            file.setHandle(handle);
            file.setSFTPSubsystem(this);
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, 16711718, true).addAttribute("FILE_NAME", (Object)file.getAbsolutePath()));
            return file;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public SftpFile openDirectory(String path) throws SftpStatusException, SshException {
        String absolutePath = this.getAbsolutePath(path);
        SftpFileAttributes attrs = this.getAttributes(absolutePath);
        if (!attrs.isDirectory()) {
            throw new SftpStatusException(4, path + " is not a directory");
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(11);
            msg.writeInt(requestId.longValue());
            msg.writeString(absolutePath, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            byte[] handle = this.getHandleResponse(requestId);
            SftpFile file = new SftpFile(absolutePath, attrs);
            file.setHandle(handle);
            file.setSFTPSubsystem(this);
            return file;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    void closeHandle(byte[] handle) throws SftpStatusException, SshException {
        if (!this.isValidHandle(handle)) {
            throw new SftpStatusException(100, "The handle is invalid!");
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(4);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void closeFile(SftpFile file) throws SftpStatusException, SshException {
        if (file.getHandle() != null) {
            this.closeHandle(file.getHandle());
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, 16711717, true).addAttribute("FILE_NAME", (Object)file.getAbsolutePath()));
            file.setHandle(null);
        }
    }

    boolean isValidHandle(byte[] handle) {
        return handle != null;
    }

    public void removeDirectory(String path) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(15);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777133, true).addAttribute("DIRECTORY_PATH", (Object)path));
    }

    public void removeFile(String filename) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(13);
            msg.writeInt(requestId.longValue());
            msg.writeString(filename, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777131, true).addAttribute("FILE_NAME", (Object)filename));
    }

    public void renameFile(String oldpath, String newpath) throws SftpStatusException, SshException {
        this.renameFile(oldpath, newpath, 0);
    }

    public void renameFile(String oldpath, String newpath, int flags) throws SftpStatusException, SshException {
        if (this.version < 2) {
            throw new SftpStatusException(8, "Renaming files is not supported by the server SFTP version " + String.valueOf(this.version));
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(18);
            msg.writeInt(requestId.longValue());
            msg.writeString(oldpath, this.CHARSET_ENCODING);
            msg.writeString(newpath, this.CHARSET_ENCODING);
            if (this.version >= 5) {
                msg.writeInt(flags);
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777132, true).addAttribute("FILE_NAME", (Object)oldpath).addAttribute("FILE_NEW_NAME", (Object)newpath));
    }

    public SftpFileAttributes getAttributes(String path) throws SftpStatusException, SshException {
        return this.getAttributes(path, 17);
    }

    public SftpFileAttributes getLinkAttributes(String path) throws SftpStatusException, SshException {
        return this.getAttributes(path, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SftpFileAttributes getAttributes(String path, int messageId) throws SftpStatusException, SshException {
        UnsignedInteger32 requestId = this.nextRequestId();
        Packet msg = this.createPacket();
        msg.write(messageId);
        msg.writeInt(requestId.longValue());
        msg.writeString(path, this.CHARSET_ENCODING);
        if (this.version > 3) {
            long flags = 509L;
            if (this.version > 4) {
                flags |= 0x200L;
            }
            msg.writeInt(flags);
        }
        this.sendMessage(msg);
        SftpMessage bar = this.getResponse(requestId);
        try {
            SftpFileAttributes sftpFileAttributes = this.extractAttributes(bar);
            bar.release();
            return sftpFileAttributes;
        }
        catch (Throwable throwable) {
            try {
                bar.release();
                throw throwable;
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
    }

    SftpFileAttributes extractAttributes(SftpMessage bar) throws SftpStatusException, SshException {
        try {
            if (bar.getType() == 105) {
                return new SftpFileAttributes((ByteArrayReader)bar, this.getVersion(), this.getCharsetEncoding());
            }
            if (bar.getType() == 101) {
                int status = (int)bar.readInt();
                if (this.version >= 3) {
                    String msg = bar.readString();
                    throw new SftpStatusException(status, msg);
                }
                throw new SftpStatusException(status);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message.", 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileAttributes getAttributes(SftpFile file) throws SftpStatusException, SshException {
        if (!this.isValidHandle(file.getHandle())) {
            return this.getAttributes(file.getAbsolutePath());
        }
        UnsignedInteger32 requestId = this.nextRequestId();
        Packet msg = this.createPacket();
        msg.write(8);
        msg.writeInt(requestId.longValue());
        msg.writeBinaryString(file.getHandle());
        if (this.version > 3) {
            msg.writeInt(-2147483139L);
        }
        this.sendMessage(msg);
        SftpMessage attrMessage = this.getResponse(requestId);
        try {
            SftpFileAttributes sftpFileAttributes = this.extractAttributes(attrMessage);
            attrMessage.release();
            return sftpFileAttributes;
        }
        catch (Throwable throwable) {
            try {
                attrMessage.release();
                throw throwable;
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
    }

    public void makeDirectory(String path) throws SftpStatusException, SshException {
        this.makeDirectory(path, new SftpFileAttributes(2, this.getCharsetEncoding()));
    }

    public void makeDirectory(String path, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(14);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            msg.write(attrs.toByteArray(this.getVersion()));
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public byte[] getHandleResponse(UnsignedInteger32 requestId) throws SftpStatusException, SshException {
        return this.getHandleResponse(this.getResponse(requestId));
    }

    public byte[] getHandleResponse(SftpMessage bar) throws SftpStatusException, SshException {
        try {
            if (bar.getType() == 102) {
                return bar.readBinaryString();
            }
            if (bar.getType() == 101) {
                int status = (int)bar.readInt();
                if (this.version >= 3) {
                    String msg = bar.readString();
                    throw new SftpStatusException(status, msg);
                }
                throw new SftpStatusException(status);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message!", 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    SftpMessage getExtensionResponse(UnsignedInteger32 requestId) throws SftpStatusException, SshException {
        SftpMessage bar = this.getResponse(requestId);
        try {
            if (bar.getType() == 201) {
                SftpMessage sftpMessage = bar;
                return sftpMessage;
            }
            try {
                if (bar.getType() == 101) {
                    int status = (int)bar.readInt();
                    if (this.version >= 3) {
                        String msg = bar.readString();
                        throw new SftpStatusException(status, msg);
                    }
                    throw new SftpStatusException(status);
                }
                this.close();
                throw new SshException("The server responded with an unexpected message!", 6);
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
        finally {
            bar.release();
        }
    }

    public UnsignedInteger32 sendExtensionMessage(String request, byte[] requestData) throws SshException, SftpStatusException {
        try {
            UnsignedInteger32 id = this.nextRequestId();
            Packet packet = this.createPacket();
            packet.write(200);
            packet.writeUINT32(id);
            packet.writeString(request);
            if (requestData != null) {
                packet.write(requestData);
            }
            this.sendMessage(packet);
            return id;
        }
        catch (IOException ex) {
            throw new SshException(5, (Throwable)ex);
        }
    }

    protected Packet createPacket() throws IOException {
        return PacketPool.getInstance().getPacket();
    }

    public boolean isClosed() {
        return this.getSession().isClosed();
    }

    public int getMaximumLocalWindowSize() {
        return this.getMaximumWindowSize();
    }

    public int getMaximumLocalPacketLength() {
        return this.getMaximumPacketSize();
    }

    public int getMaximumRemoteWindowSize() {
        return this.session.getMaxiumRemoteWindowSize();
    }

    public int getMaximumRemotePacketLength() {
        return this.session.getMaxiumRemotePacketSize();
    }

    class SftpThreadSynchronizer {
        boolean isBlocking = false;

        SftpThreadSynchronizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean requestBlock(UnsignedInteger32 requestId, MessageHolder holder) throws InterruptedException {
            if (SftpChannel.this.responses.containsKey(requestId)) {
                holder.msg = SftpChannel.this.responses.get(requestId);
                return false;
            }
            SftpThreadSynchronizer sftpThreadSynchronizer = this;
            synchronized (sftpThreadSynchronizer) {
                boolean canBlock;
                boolean bl = canBlock = !this.isBlocking;
                if (canBlock) {
                    this.isBlocking = true;
                } else {
                    this.wait();
                }
                return canBlock;
            }
        }

        public synchronized void releaseBlock() {
            this.isBlocking = false;
            this.notifyAll();
        }
    }
}

