/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.components;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.SshKeyExchangeClient;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.Utils;
import com.sshtools.synergy.ssh.SshTransport;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DiffieHellmanGroup
extends SshKeyExchangeClient {
    static final int SSH_MSG_KEXDH_INIT = 30;
    static final int SSH_MSG_KEXDH_REPLY = 31;
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO;
    static final BigInteger g;
    BigInteger p = null;
    KeyPairGenerator dhKeyPairGen;
    KeyAgreement dhKeyAgreement;
    KeyFactory dhKeyFactory;
    KeyPair dhKeyPair;
    String kexAlgorithm;

    DiffieHellmanGroup(String kexAlgorithm, String hashAlgorithm, BigInteger p, SecurityLevel securityLevel, int priority) {
        super(hashAlgorithm, securityLevel, priority);
        this.kexAlgorithm = kexAlgorithm;
        this.p = p;
    }

    public String getAlgorithm() {
        return this.kexAlgorithm;
    }

    public void init(SshTransport<SshClientContext> transport, String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvkey, SshPublicKey pubkey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException, SshException {
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.firstPacketFollows = firstPacketFollows;
        this.useFirstPacket = useFirstPacket;
        this.transport = transport;
        try {
            this.initCrypto();
            this.e = ((DHPublicKey)this.dhKeyPair.getPublic()).getY();
        }
        catch (Exception ex) {
            throw new IOException("Failed to generate DH value: " + ex.getMessage());
        }
        final byte[] eBytes = this.e.toByteArray();
        transport.postMessage(new SshMessage(){

            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                buf.put((byte)30);
                buf.putInt(eBytes.length);
                buf.put(eBytes);
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sent SSH_MSG_KEXDH_INIT", (Object[])new Object[0]);
                }
            }
        }, true);
    }

    private void initCrypto() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.dhKeyFactory = JCEProvider.getProviderForAlgorithm((String)"DH") == null ? KeyFactory.getInstance("DH") : KeyFactory.getInstance("DH", JCEProvider.getProviderForAlgorithm((String)"DH"));
        this.dhKeyPairGen = JCEProvider.getProviderForAlgorithm((String)"DH") == null ? KeyPairGenerator.getInstance("DH") : KeyPairGenerator.getInstance("DH", JCEProvider.getProviderForAlgorithm((String)"DH"));
        this.dhKeyAgreement = JCEProvider.getProviderForAlgorithm((String)"DH") == null ? KeyAgreement.getInstance("DH") : KeyAgreement.getInstance("DH", JCEProvider.getProviderForAlgorithm((String)"DH"));
        DHParameterSpec dhSkipParamSpec = new DHParameterSpec(this.p, g);
        this.dhKeyPairGen.initialize(dhSkipParamSpec, JCEProvider.getSecureRandom());
        this.dhKeyPair = this.dhKeyPairGen.generateKeyPair();
        this.dhKeyAgreement.init(this.dhKeyPair.getPrivate());
    }

    public String getProvider() {
        if (this.dhKeyAgreement != null) {
            return this.dhKeyAgreement.getProvider().getName();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processMessage(byte[] m) throws SshException, IOException {
        try (ByteArrayReader msg = new ByteArrayReader(m);){
            int msgId = msg.read();
            switch (msgId) {
                case 31: {
                    try {
                        this.hostKey = msg.readBinaryString();
                        this.f = msg.readBigInteger();
                        this.signature = msg.readBinaryString();
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Received SSH_MSG_KEXDH_INIT f={}", (Object[])new Object[]{this.f.toString(16)});
                            Log.debug((String)"Host key: {}", (Object[])new Object[]{SshKeyUtils.getOpenSSHFormattedKey((SshPublicKey)SshPublicKeyFileFactory.decodeSSH2PublicKey((byte[])this.hostKey))});
                            Log.debug((String)"Signature: {}", (Object[])new Object[]{Utils.bytesToHex((byte[])this.signature)});
                        }
                        DHPublicKeySpec spec = new DHPublicKeySpec(this.f, this.p, g);
                        this.dhKeyAgreement.doPhase(this.dhKeyFactory.generatePublic(spec), true);
                        byte[] tmp = this.dhKeyAgreement.generateSecret();
                        if ((tmp[0] & 0x80) == 128) {
                            byte[] tmp2 = new byte[tmp.length + 1];
                            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
                            tmp = tmp2;
                        }
                        this.secret = new BigInteger(tmp);
                        this.calculateExchangeHash();
                        this.transport.sendNewKeys();
                    }
                    catch (Exception ex) {
                        throw new SshException("Failed to read SSH_MSG_KEXDH_REPLY from message buffer", 5, (Throwable)ex);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean isKeyExchangeMessage(int messageid) {
        switch (messageid) {
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    public void test() throws IOException, SshException {
        try {
            this.initCrypto();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    static {
        g = TWO = BigInteger.valueOf(2L);
    }
}

