/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.logger.Log;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.TransportProtocolServer;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.LicenseException;
import com.sshtools.synergy.nio.ProtocolContextFactory;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.ssh.TransportProtocol;

class TransportProtocolSwitchingClient
extends TransportProtocolClient {
    ProtocolContextFactory<SshServerContext> serverFactory;
    String callbackIdentifier;
    ConnectRequestFuture connectFuture;

    public TransportProtocolSwitchingClient(SshClientContext sshContext, String callbackIdentifier, ProtocolContextFactory<SshServerContext> serverFactory, ConnectRequestFuture connectFuture) throws LicenseException {
        super(sshContext, connectFuture);
        this.serverFactory = serverFactory;
        this.callbackIdentifier = callbackIdentifier;
        this.connectFuture = connectFuture;
    }

    protected void onRemoteIdentificationReceived(String remoteIdentification) {
        if (!remoteIdentification.startsWith("SSH-2.0-" + this.callbackIdentifier)) {
            try {
                SshServerContext context = (SshServerContext)this.serverFactory.createContext(((SshClientContext)this.sshContext).getDaemonContext(), this.getSocketConnection().getSocketChannel());
                TransportProtocolServer engine = (TransportProtocolServer)context.createEngine(this.connectFuture);
                this.transferState((TransportProtocol)engine);
                this.getSocketConnection().setProtocolEngine((ProtocolEngine)engine);
            }
            catch (Exception e) {
                Log.error((String)"Failed to switch roles", (Throwable)e, (Object[])new Object[0]);
                this.disconnect(2, "Failed to switch SSH role");
            }
        } else {
            String username = remoteIdentification.substring(8 + this.callbackIdentifier.length()).trim();
            ((SshClientContext)this.getContext()).setUsername(username);
        }
    }
}

