/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.client;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.AgentProvider;
import com.sshtools.agent.KeyConstraints;
import com.sshtools.agent.client.AgentSocketType;
import com.sshtools.agent.exceptions.AgentNotAvailableException;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.agent.openssh.OpenSshSignRequest;
import com.sshtools.agent.rfc.SshAgentAddKey;
import com.sshtools.agent.rfc.SshAgentAlive;
import com.sshtools.agent.rfc.SshAgentDeleteKey;
import com.sshtools.agent.rfc.SshAgentFailure;
import com.sshtools.agent.rfc.SshAgentForwardingNotice;
import com.sshtools.agent.rfc.SshAgentKeyList;
import com.sshtools.agent.rfc.SshAgentLock;
import com.sshtools.agent.rfc.SshAgentOperationComplete;
import com.sshtools.agent.rfc.SshAgentPing;
import com.sshtools.agent.rfc.SshAgentPrivateKeyOp;
import com.sshtools.agent.rfc.SshAgentRandom;
import com.sshtools.agent.rfc.SshAgentRandomData;
import com.sshtools.agent.rfc.SshAgentRequestVersion;
import com.sshtools.agent.rfc.SshAgentSuccess;
import com.sshtools.agent.rfc.SshAgentUnlock;
import com.sshtools.agent.rfc.SshAgentVersionResponse;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.SignatureGenerator;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class SshAgentClient
implements SignatureGenerator,
Closeable {
    public static final String HASH_AND_SIGN = "hash-and-sign";
    InputStream in;
    OutputStream out;
    boolean isForwarded = false;
    HashMap<Integer, Class<? extends AgentMessage>> messages = new HashMap();
    Closeable socket;
    boolean isRFCAgent = false;
    public static String WINDOWS_SSH_AGENT_SERVICE = "openssh-ssh-agent";

    public SshAgentClient(boolean isForwarded, String application, Socket socket) throws IOException {
        this(isForwarded, application, socket, socket.getInputStream(), socket.getOutputStream(), false);
    }

    public SshAgentClient(boolean isForwarded, String application, Closeable socket, InputStream in, OutputStream out, boolean isRFC) throws IOException {
        Log.info((String)"New SshAgentClient instance created", (Object[])new Object[0]);
        this.socket = socket;
        this.in = in;
        this.out = out;
        this.isForwarded = isForwarded;
        this.registerMessages();
        if (isForwarded && isRFC) {
            this.sendForwardingNotice();
        } else if (isRFC) {
            this.sendVersionRequest(application);
        } else {
            this.listKeys();
        }
    }

    public boolean isRFCAgent() {
        return this.isRFCAgent;
    }

    public static SshAgentClient connectOpenSSHAgent(String application) throws AgentNotAvailableException, IOException {
        String location = System.getenv("SSH_AUTH_SOCK");
        if (location == null && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            location = WINDOWS_SSH_AGENT_SERVICE;
        } else if (location == null) {
            throw new AgentNotAvailableException("SSH_AUTH_SOCK is undefined");
        }
        return SshAgentClient.connectOpenSSHAgent(application, location);
    }

    public static SshAgentClient connectOpenSSHAgent(String application, String location) throws AgentNotAvailableException, IOException {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return SshAgentClient.connectLocalAgent(application, location, AgentSocketType.WINDOWS_NAMED_PIPE, false);
        }
        return SshAgentClient.connectLocalAgent(application, location, AgentSocketType.UNIX_DOMAIN, false);
    }

    public static SshAgentClient connectLocalAgent(String application, String location, AgentSocketType type, boolean RFCAgent) throws AgentNotAvailableException, IOException {
        try {
            AgentProvider l;
            if (location == null) {
                throw new AgentNotAvailableException();
            }
            SshAgentClient socket = null;
            Iterator<AgentProvider> iterator = ServiceLoader.load(AgentProvider.class, JCEComponentManager.getDefaultInstance().getClassLoader()).iterator();
            while (iterator.hasNext() && (socket = (l = iterator.next()).client(application, location, type, RFCAgent)) == null) {
            }
            if (socket == null) {
                throw new IOException("No unix domain socket provider available. Check that you have a provider, such as maverick-sshagent-jnr-sockets, maverick-sshagent-jdk16-sockets or maverick-sshagent-namedpipes on the classpath and is the address in the correct format.");
            }
            return socket;
        }
        catch (IOException ex) {
            Log.error((String)"Agent socket error :", (Throwable)ex, (Object[])new Object[0]);
            throw new AgentNotAvailableException();
        }
    }

    @Override
    public void close() {
        Log.info((String)"Closing agent client", (Object[])new Object[0]);
        try {
            this.in.close();
        }
        catch (IOException ex) {
            Log.error((String)"Error in closing inputstream", (Throwable)ex, (Object[])new Object[0]);
        }
        try {
            this.out.close();
        }
        catch (IOException ex1) {
            Log.error((String)"Error in closing outputstream", (Throwable)ex1, (Object[])new Object[0]);
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ex2) {
            Log.error((String)"Error in closing socket", (Throwable)ex2, (Object[])new Object[0]);
        }
    }

    public void ping(byte[] padding) throws IOException {
        AgentMessage msg = new SshAgentPing(padding);
        this.sendMessage(msg);
        try {
            msg = this.readMessage();
        }
        catch (InvalidMessageException e) {
            throw new IOException("Error in reading agent response");
        }
        if (msg instanceof SshAgentAlive) {
            if (!Arrays.equals(padding, ((SshAgentAlive)msg).getPadding())) {
                throw new IOException("Agent failed to reply with expected data");
            }
        } else {
            throw new IOException("Agent failed to provide the request random data");
        }
    }

    protected void registerMessages() {
        this.messages.put(6, SshAgentSuccess.class);
        this.messages.put(5, SshAgentFailure.class);
        this.messages.put(12, SshAgentKeyList.class);
        this.messages.put(103, SshAgentVersionResponse.class);
        this.messages.put(101, SshAgentSuccess.class);
        this.messages.put(102, SshAgentFailure.class);
        this.messages.put(104, SshAgentKeyList.class);
        this.messages.put(106, SshAgentRandomData.class);
        this.messages.put(150, SshAgentAlive.class);
        this.messages.put(105, SshAgentOperationComplete.class);
        this.messages.put(14, SshAgentOperationComplete.class);
    }

    protected void sendForwardingNotice() throws IOException {
        InetAddress addr = InetAddress.getLocalHost();
        SshAgentForwardingNotice msg = new SshAgentForwardingNotice(addr.getHostName(), addr.getHostAddress(), 22);
        this.sendMessage(msg);
    }

    protected void sendMessage(AgentMessage msg) throws IOException {
        Log.info((String)("Sending message " + msg.getMessageName()), (Object[])new Object[0]);
        try {
            byte[] msgdata = msg.toByteArray();
            this.out.write(ByteArrayWriter.encodeInt((int)msgdata.length));
            this.out.write(msgdata);
            this.out.flush();
        }
        catch (InvalidMessageException e) {
            Log.error((String)"Message sending error :", (Throwable)((Object)e), (Object[])new Object[0]);
            throw new IOException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected void sendVersionRequest(String application) throws IOException {
        block6: {
            try {
                AgentMessage msg = new SshAgentRequestVersion(application);
                this.sendMessage(msg);
                msg = this.readMessage();
                if (msg instanceof SshAgentVersionResponse) {
                    this.isRFCAgent = true;
                    SshAgentVersionResponse reply = (SshAgentVersionResponse)msg;
                    System.out.println("Agent Version :" + reply.getVersion());
                    if (reply.getVersion() != 2) {
                        throw new IOException("The agent verison is not compatible with verison 2");
                    }
                    break block6;
                }
                if (msg instanceof SshAgentSuccess) {
                    this.isRFCAgent = false;
                    break block6;
                }
                if (msg instanceof SshAgentFailure) {
                    this.isRFCAgent = false;
                    break block6;
                }
                throw new IOException("The agent did not respond with the appropriate version");
            }
            catch (InvalidMessageException e) {
                Log.error((String)"Version sending error :", (Throwable)((Object)e), (Object[])new Object[0]);
                throw new IOException(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    public void deleteAllKeys() throws IOException {
        try {
            AgentMessage msg = new AgentMessage(203);
            this.sendMessage(msg);
            msg = this.readMessage();
            if (!(msg instanceof SshAgentSuccess)) {
                throw new IOException("The agent failed to delete all keys");
            }
        }
        catch (Exception ex) {
            Log.error((String)"delete All key error :", (Throwable)ex, (Object[])new Object[0]);
            throw new IOException(ex.getMessage(), ex);
        }
    }

    protected AgentMessage readMessage() throws InvalidMessageException {
        try {
            int len;
            byte[] lendata = new byte[4];
            for (len = 0; len < 3; len += this.in.read(lendata, len, lendata.length - len)) {
            }
            len = (int)ByteArrayReader.readInt((byte[])lendata, (int)0);
            byte[] msgdata = new byte[len];
            for (len = 0; len < msgdata.length; len += this.in.read(msgdata, len, msgdata.length - len)) {
            }
            Integer id = msgdata[0] & 0xFF;
            if (this.messages.containsKey(id)) {
                Class<? extends AgentMessage> cls = this.messages.get(id);
                AgentMessage msg = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                msg.fromByteArray(msgdata);
                Log.info((String)("Received message " + msg.getMessageName()), (Object[])new Object[0]);
                return msg;
            }
            throw new InvalidMessageException("Unrecognised message id " + id.toString(), 13);
        }
        catch (Exception ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
    }

    public void addKey(SshPrivateKey prvkey, SshPublicKey pubkey, String description, KeyConstraints constraints) throws IOException {
        AgentMessage msg = new SshAgentAddKey(prvkey, pubkey, description, constraints);
        this.sendMessage(msg);
        try {
            msg = this.readMessage();
            if (!(msg instanceof SshAgentSuccess)) {
                throw new IOException("The key could not be added");
            }
        }
        catch (InvalidMessageException e) {
            throw new IOException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public Map<SshPublicKey, String> listKeys() throws IOException {
        try {
            AgentMessage msg = new AgentMessage(this.isRFCAgent ? 204 : 11);
            this.sendMessage(msg);
            msg = this.readMessage();
            if (msg instanceof SshAgentKeyList) {
                return ((SshAgentKeyList)msg).getKeys();
            }
            throw new IOException("The agent responsed with an invalid message :" + msg.getMessageName());
        }
        catch (InvalidMessageException e) {
            throw new IOException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public boolean lockAgent(String password) throws IOException {
        try {
            AgentMessage msg = new SshAgentLock(this.isRFCAgent, password);
            this.sendMessage(msg);
            msg = this.readMessage();
            return msg instanceof SshAgentSuccess;
        }
        catch (InvalidMessageException e) {
            throw new IOException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public boolean unlockAgent(String password) throws IOException {
        try {
            AgentMessage msg = new SshAgentUnlock(this.isRFCAgent, password);
            this.sendMessage(msg);
            msg = this.readMessage();
            return msg instanceof SshAgentSuccess;
        }
        catch (InvalidMessageException e) {
            throw new IOException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public byte[] getRandomData(int count) throws IOException {
        try {
            AgentMessage msg = new SshAgentRandom(count);
            this.sendMessage(msg);
            msg = this.readMessage();
            if (msg instanceof SshAgentRandomData) {
                return ((SshAgentRandomData)msg).getRandomData();
            }
            throw new IOException("Agent failed to provide the request random data");
        }
        catch (InvalidMessageException e) {
            throw new IOException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void deleteKey(SshPublicKey key, String description) throws IOException {
        try {
            AgentMessage msg = new SshAgentDeleteKey(key, description);
            this.sendMessage(msg);
            msg = this.readMessage();
            if (!(msg instanceof SshAgentSuccess)) {
                throw new IOException("The agent failed to delete the key");
            }
        }
        catch (InvalidMessageException e) {
            throw new IOException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public byte[] hashAndSign(SshPublicKey key, String signingAlgorithm, byte[] data) throws IOException {
        try {
            AgentMessage msg = this.isRFCAgent() ? new SshAgentPrivateKeyOp(key, HASH_AND_SIGN, data) : new OpenSshSignRequest(key, data);
            this.sendMessage(msg);
            msg = this.readMessage();
            if (msg instanceof SshAgentOperationComplete) {
                return ((SshAgentOperationComplete)msg).getData();
            }
            throw new IOException("The operation failed");
        }
        catch (InvalidMessageException e) {
            throw new IOException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public byte[] sign(SshPublicKey key, String signingAlgorithm, byte[] data) throws SshException {
        try {
            return this.hashAndSign(key, signingAlgorithm, data);
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    public Collection<SshPublicKey> getPublicKeys() throws IOException {
        return this.listKeys().keySet();
    }

    public static String getEnvironmentSocket() throws AgentNotAvailableException {
        String location = System.getenv("SSH_AUTH_SOCK");
        if (location == null && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            location = WINDOWS_SSH_AGENT_SERVICE;
        } else if (location == null) {
            throw new AgentNotAvailableException("SSH_AUTH_SOCK is undefined");
        }
        return location;
    }
}

