/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.rfc;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.ForwardingNotice;
import com.sshtools.agent.KeyStore;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.agent.exceptions.KeyTimeoutException;
import com.sshtools.agent.rfc.SshAgentAddKey;
import com.sshtools.agent.rfc.SshAgentAlive;
import com.sshtools.agent.rfc.SshAgentDeleteKey;
import com.sshtools.agent.rfc.SshAgentFailure;
import com.sshtools.agent.rfc.SshAgentForwardingNotice;
import com.sshtools.agent.rfc.SshAgentKeyList;
import com.sshtools.agent.rfc.SshAgentLock;
import com.sshtools.agent.rfc.SshAgentOperationComplete;
import com.sshtools.agent.rfc.SshAgentPing;
import com.sshtools.agent.rfc.SshAgentPrivateKeyOp;
import com.sshtools.agent.rfc.SshAgentRandom;
import com.sshtools.agent.rfc.SshAgentRandomData;
import com.sshtools.agent.rfc.SshAgentRequestVersion;
import com.sshtools.agent.rfc.SshAgentUnlock;
import com.sshtools.agent.rfc.SshAgentVersionResponse;
import com.sshtools.agent.server.SshAgentConnection;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Vector;

public class RFCAgentConnection
implements Runnable,
SshAgentConnection {
    private InputStream in;
    OutputStream out;
    KeyStore keystore;
    Thread thread;
    Vector<ForwardingNotice> forwardingNodes = new Vector();
    Closeable closeable;
    boolean isRFCAgent = true;

    public RFCAgentConnection(KeyStore keystore, InputStream in, OutputStream out, Closeable closeable) {
        this.keystore = keystore;
        this.in = in;
        this.out = out;
        this.closeable = closeable;
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void sendAgentSuccess() throws IOException {
        AgentMessage msg = new AgentMessage(101);
        this.sendMessage(msg);
    }

    protected void sendAgentFailure(int errorcode) throws IOException {
        SshAgentFailure msg = new SshAgentFailure(errorcode);
        this.sendMessage(msg);
    }

    protected void sendVersionResponse() throws IOException {
        SshAgentVersionResponse msg = new SshAgentVersionResponse(2);
        this.sendMessage(msg);
    }

    protected void sendAgentKeyList() throws IOException {
        SshAgentKeyList msg = null;
        msg = new SshAgentKeyList(this.keystore.getPublicKeys());
        this.sendMessage(msg);
    }

    protected void sendOperationComplete(byte[] data) throws IOException {
        SshAgentOperationComplete msg = new SshAgentOperationComplete(data);
        this.sendMessage(msg);
    }

    protected void sendRandomData(byte[] data) throws IOException {
        SshAgentRandomData msg = new SshAgentRandomData(data);
        this.sendMessage(msg);
    }

    protected void sendAgentAlive(byte[] padding) throws IOException {
        if (!this.keystore.isLocked()) {
            SshAgentAlive msg = new SshAgentAlive(padding);
            this.sendMessage(msg);
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void sendMessage(AgentMessage msg) throws IOException {
        Log.info((String)("Sending message " + msg.getMessageName()), (Object[])new Object[0]);
        try {
            byte[] msgdata = msg.toByteArray();
            this.out.write(ByteArrayWriter.encodeInt((int)msgdata.length));
            this.out.write(msgdata);
            this.out.flush();
        }
        catch (InvalidMessageException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void onForwardingNotice(SshAgentForwardingNotice msg) {
        this.forwardingNodes.add(new ForwardingNotice(msg.getRemoteHostname(), msg.getRemoteIPAddress(), msg.getRemotePort()));
    }

    protected void onRequestVersion(SshAgentRequestVersion msg) throws IOException {
        this.sendVersionResponse();
    }

    protected void onAddKey(SshAgentAddKey msg) throws IOException {
        if (!this.keystore.isLocked()) {
            if (this.keystore.addKey(msg.getPrivateKey(), msg.getPublicKey(), msg.getDescription(), msg.getKeyConstraints())) {
                this.sendAgentSuccess();
            } else {
                this.sendAgentFailure(6);
            }
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void onDeleteAllKeys(AgentMessage msg) throws IOException {
        if (!this.keystore.isLocked()) {
            this.keystore.deleteAllKeys();
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void onListKeys(AgentMessage msg) throws IOException {
        if (!this.keystore.isLocked()) {
            this.sendAgentKeyList();
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void onPrivateKeyOp(SshAgentPrivateKeyOp msg) throws IOException {
        try {
            if (msg.getOperation().equals("sign")) {
                this.sendAgentFailure(5);
            } else if (msg.getOperation().equals("hash-and-sign")) {
                byte[] sig = this.keystore.performHashAndSign(msg.getPublicKey(), this.forwardingNodes, msg.getOperationData(), 0);
                this.sendOperationComplete(sig);
            } else if (msg.getOperation().equals("decrypt")) {
                this.sendAgentFailure(5);
            } else if (msg.getOperation().equals("ssh1-challenge-response")) {
                this.sendAgentFailure(5);
            } else {
                this.sendAgentFailure(8);
            }
        }
        catch (KeyTimeoutException ex) {
            this.sendAgentFailure(1);
        }
        catch (InvalidMessageException ex) {
            this.sendAgentFailure(2);
        }
        catch (SshException e) {
            this.sendAgentFailure(5);
        }
    }

    protected void onDeleteKey(SshAgentDeleteKey msg) throws IOException {
        if (this.keystore.deleteKey(msg.getPublicKey())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(2);
        }
    }

    protected void onLock(SshAgentLock msg) throws IOException {
        if (this.keystore.lock(msg.getPassword())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void onUnlock(SshAgentUnlock msg) throws IOException {
        if (this.keystore.unlock(msg.getPassword())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void onPing(SshAgentPing msg) throws IOException {
        this.sendAgentAlive(msg.getPadding());
    }

    protected void onRandom(SshAgentRandom msg) throws IOException {
        if (!this.keystore.isLocked()) {
            if (msg.getLength() > 0) {
                byte[] random = new byte[msg.getLength()];
                new SecureRandom().nextBytes(random);
                this.sendRandomData(random);
            } else {
                this.sendAgentFailure(7);
            }
        } else {
            this.sendAgentFailure(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Log.info((String)"Starting agent connection thread", (Object[])new Object[0]);
            byte[] lendata = new byte[4];
            boolean alive = true;
            while (alive) {
                int len = 0;
                while (len < lendata.length) {
                    try {
                        int read = 0;
                        read = this.in.read(lendata, len, lendata.length - len);
                        if (read >= 0) {
                            len += read;
                            continue;
                        }
                        alive = false;
                        break;
                    }
                    catch (InterruptedIOException ex) {
                        if (ex.bytesTransferred <= 0) continue;
                        len += ex.bytesTransferred;
                    }
                }
                if (!alive) continue;
                len = (int)ByteArrayReader.readInt((byte[])lendata, (int)0);
                byte[] msgdata = new byte[len];
                len = 0;
                while (len < msgdata.length) {
                    try {
                        len += this.in.read(msgdata, len, msgdata.length - len);
                    }
                    catch (InterruptedIOException ex1) {
                        len += ex1.bytesTransferred;
                    }
                }
                this.onMessageReceived(msgdata);
            }
        }
        catch (IOException ex) {
            Log.info((String)"The agent connection terminated", (Object[])new Object[0]);
        }
        finally {
            try {
                if (this.closeable != null) {
                    this.closeable.close();
                }
            }
            catch (Exception exception) {}
        }
        Log.info((String)"Exiting agent connection thread", (Object[])new Object[0]);
    }

    protected void onMessageReceived(byte[] msgdata) throws IOException {
        try {
            switch (msgdata[0] & 0xFF) {
                case 206: {
                    Log.info((String)"Agent forwarding notice received", (Object[])new Object[0]);
                    SshAgentForwardingNotice msg = new SshAgentForwardingNotice();
                    msg.fromByteArray(msgdata);
                    this.onForwardingNotice(msg);
                    break;
                }
                case 9: {
                    Log.info((String)"Agent version request received", (Object[])new Object[0]);
                    SshAgentRequestVersion msg = new SshAgentRequestVersion();
                    msg.fromByteArray(msgdata);
                    this.onRequestVersion(msg);
                    break;
                }
                case 202: {
                    Log.info((String)"Adding key to agent", (Object[])new Object[0]);
                    SshAgentAddKey msg = new SshAgentAddKey();
                    msg.fromByteArray(msgdata);
                    this.onAddKey(msg);
                    break;
                }
                case 203: {
                    Log.info((String)"Deleting all keys from agent", (Object[])new Object[0]);
                    AgentMessage msg = new AgentMessage(203);
                    msg.fromByteArray(msgdata);
                    this.onDeleteAllKeys(msg);
                    break;
                }
                case 204: {
                    Log.info((String)"Listing agent keys", (Object[])new Object[0]);
                    AgentMessage msg = new AgentMessage(204);
                    msg.fromByteArray(msgdata);
                    this.onListKeys(msg);
                    break;
                }
                case 205: {
                    Log.info((String)"Performing agent private key operation", (Object[])new Object[0]);
                    SshAgentPrivateKeyOp msg = new SshAgentPrivateKeyOp();
                    msg.fromByteArray(msgdata);
                    this.onPrivateKeyOp(msg);
                    break;
                }
                case 207: {
                    Log.info((String)"Deleting key from agent", (Object[])new Object[0]);
                    SshAgentDeleteKey msg = new SshAgentDeleteKey();
                    msg.fromByteArray(msgdata);
                    this.onDeleteKey(msg);
                    break;
                }
                case 208: {
                    Log.info((String)"Locking agent", (Object[])new Object[0]);
                    SshAgentLock msg = new SshAgentLock(this.isRFCAgent);
                    msg.fromByteArray(msgdata);
                    this.onLock(msg);
                    break;
                }
                case 209: {
                    Log.info((String)"Unlocking agent", (Object[])new Object[0]);
                    SshAgentUnlock msg = new SshAgentUnlock(this.isRFCAgent);
                    msg.fromByteArray(msgdata);
                    this.onUnlock(msg);
                    break;
                }
                case 212: {
                    Log.info((String)"Ping Ping Ping Ping Ping", (Object[])new Object[0]);
                    SshAgentPing msg = new SshAgentPing();
                    msg.fromByteArray(msgdata);
                    this.onPing(msg);
                    break;
                }
                case 213: {
                    Log.info((String)"Random message received", (Object[])new Object[0]);
                    SshAgentRandom msg = new SshAgentRandom();
                    msg.fromByteArray(msgdata);
                    this.onRandom(msg);
                    break;
                }
                default: {
                    throw new IOException("Unrecognized message type " + String.valueOf(msgdata[0]) + " received");
                }
            }
        }
        catch (InvalidMessageException e) {
            e.printStackTrace();
        }
        System.out.println("Key store size :" + this.keystore.size());
    }
}

