/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.provider.namedpipes;

import com.sshtools.agent.provider.namedpipes.AbstractNamedPipe;
import com.sshtools.common.logger.Log;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;

public class NamedPipeServer
extends AbstractNamedPipe {
    WinNT.HANDLE hNextHandle = null;
    boolean closed;

    public NamedPipeServer(String pipeName) throws IOException {
        super(pipeName);
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        if (this.hNextHandle != null) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Closing pipe server {} handle={}", (Object[])new Object[]{this.pipeName, this.hNextHandle.toString()});
            }
            try {
                NamedPipeServer.assertCallSucceeded("DisconnectNamedPipe", Kernel32.INSTANCE.DisconnectNamedPipe(this.hNextHandle));
                NamedPipeServer.assertCallSucceeded("Named pipe handle close", Kernel32.INSTANCE.CloseHandle(this.hNextHandle));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNamedPipe.NamedPipeSession accept() throws IOException {
        if (this.closed) {
            throw new IOException("Named pipe has been closed!");
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Waiting for client on pipe {}", (Object[])new Object[]{this.pipeName});
        }
        NamedPipeServer namedPipeServer = this;
        synchronized (namedPipeServer) {
            this.hNextHandle = NamedPipeServer.assertValidHandle("CreateNamedPipe", Kernel32.INSTANCE.CreateNamedPipe(this.pipeName, 3, 6, 255, 1024, 1024, 0, null));
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Waiting for client to connect to pipe {} handle={}", (Object[])new Object[]{this.pipeName, this.hNextHandle.toString()});
        }
        NamedPipeServer.assertCallSucceeded("ConnectNamedPipe", Kernel32.INSTANCE.ConnectNamedPipe(this.hNextHandle, null));
        if (Log.isInfoEnabled()) {
            Log.info((String)"Client connected to pipe {} handle={}", (Object[])new Object[]{this.pipeName, this.hNextHandle.toString()});
        }
        namedPipeServer = this;
        synchronized (namedPipeServer) {
            AbstractNamedPipe.NamedPipeSession namedPipeSession;
            try {
                namedPipeSession = new AbstractNamedPipe.NamedPipeSession(this.hNextHandle);
                this.hNextHandle = null;
            }
            catch (Throwable throwable) {
                try {
                    this.hNextHandle = null;
                    throw throwable;
                }
                catch (Throwable t) {
                    if (Log.isErrorEnabled()) {
                        Log.error((String)"Accept failure", (Throwable)t, (Object[])new Object[0]);
                    }
                    throw new IOException(t.getMessage(), t);
                }
            }
            return namedPipeSession;
        }
    }
}

