/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.provider.jdk16;

import com.sshtools.agent.AgentProvider;
import com.sshtools.agent.client.AgentSocketType;
import com.sshtools.agent.client.SshAgentClient;
import com.sshtools.agent.server.SshAgentAcceptor;
import com.sshtools.agent.server.SshAgentTransport;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class JDK16UnixDomainSocketAgentProvider
implements AgentProvider {
    public SshAgentAcceptor server(String location, AgentSocketType type) throws IOException {
        if (type == AgentSocketType.UNIX_DOMAIN) {
            UnixDomainSocketAddress unixSocketAddress = UnixDomainSocketAddress.of(location);
            final ServerSocketChannel serverSocket = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
            serverSocket.bind(unixSocketAddress);
            return new SshAgentAcceptor(){

                public void close() throws IOException {
                    serverSocket.close();
                }

                public SshAgentTransport accept() throws IOException {
                    final SocketChannel socket = serverSocket.accept();
                    return new SshAgentTransport(){

                        public OutputStream getOutputStream() throws IOException {
                            return Channels.newOutputStream(socket);
                        }

                        public InputStream getInputStream() throws IOException {
                            return Channels.newInputStream(socket);
                        }

                        public void close() throws IOException {
                            socket.close();
                        }
                    };
                }
            };
        }
        return null;
    }

    public SshAgentClient client(String application, String location, AgentSocketType type, boolean RFCAgent) throws IOException {
        if (type == AgentSocketType.UNIX_DOMAIN) {
            UnixDomainSocketAddress unixSocketAddress = UnixDomainSocketAddress.of(location);
            SocketChannel channel = SocketChannel.open(unixSocketAddress);
            channel.configureBlocking(true);
            return new SshAgentClient(false, application, (Closeable)channel, Channels.newInputStream(channel), Channels.newOutputStream(channel), false);
        }
        return null;
    }
}

