/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.files.FileVolume;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.sftp.extensions.AbstractSftpExtension;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.FileNotFoundException;
import java.io.IOException;

public class StatVFSExtension
extends AbstractSftpExtension {
    public static final String EXTENSION_NAME = "statvfs@openssh.com";

    public StatVFSExtension() {
        super(EXTENSION_NAME, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(ByteArrayReader msg, int requestId, SftpSubsystem sftp) {
        try {
            FileVolume store = sftp.getFileSystem().getVolume(msg.readString());
            try (Packet reply = new Packet();){
                reply.write(201);
                reply.writeInt(requestId);
                reply.writeUINT64(new UnsignedInteger64(store.blockSize()));
                reply.writeUINT64(new UnsignedInteger64(store.underlyingBlockSize()));
                reply.writeUINT64(new UnsignedInteger64(store.blocks()));
                reply.writeUINT64(new UnsignedInteger64(store.freeBlocks()));
                reply.writeUINT64(new UnsignedInteger64(store.userFreeBlocks()));
                reply.writeUINT64(new UnsignedInteger64(store.totalInodes()));
                reply.writeUINT64(new UnsignedInteger64(store.freeInodes()));
                reply.writeUINT64(new UnsignedInteger64(store.userFreeInodes()));
                reply.writeUINT64(new UnsignedInteger64(store.id()));
                reply.writeUINT64(new UnsignedInteger64(store.flags()));
                reply.writeUINT64(new UnsignedInteger64(store.maxFilenameLength()));
                sftp.sendMessage(reply);
            }
            sftp.sendStatusMessage(requestId, 0, "The copy-file operation completed.");
        }
        catch (FileNotFoundException e) {
            sftp.sendStatusMessage(requestId, 2, e.getMessage());
        }
        catch (IOException e) {
            sftp.sendStatusMessage(requestId, 4, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            sftp.sendStatusMessage(requestId, 3, e.getMessage());
        }
    }

    @Override
    public boolean supportsExtendedMessage(int messageId) {
        return false;
    }

    @Override
    public void processExtendedMessage(ByteArrayReader msg, SftpSubsystem sftp) {
    }
}

