/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.sftp.extensions.AbstractDigestExtension;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.util.ByteArrayReader;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class FileHashingExtension
extends AbstractDigestExtension {
    public FileHashingExtension(String name) {
        super(name);
    }

    @Override
    public void processMessage(ByteArrayReader msg, int requestId, SftpSubsystem sftp) {
        block6: {
            try {
                byte[] handle = this.getFileHandle(msg, sftp);
                String algorithms = msg.readString();
                long startOffset = msg.readUINT64().longValue();
                long length = msg.readUINT64().longValue();
                int blockSize = (int)msg.readInt();
                String selectedAlgorithm = this.selectAlgorithm(algorithms);
                if (blockSize <= 1) {
                    byte[] hashValue = this.doHash(selectedAlgorithm, handle, startOffset, length, sftp);
                    this.sendReply(requestId, selectedAlgorithm, Arrays.asList(new byte[][]{hashValue}), sftp);
                    break block6;
                }
                ArrayList<byte[]> hashes = new ArrayList<byte[]>();
                try {
                    while (true) {
                        hashes.add(this.doHash(selectedAlgorithm, handle, startOffset, (long)blockSize, sftp));
                        startOffset += (long)blockSize;
                    }
                }
                catch (EOFException e) {
                    this.sendReply(requestId, selectedAlgorithm, hashes, sftp);
                }
            }
            catch (Exception e) {
                Log.error((String)"Failed to process EXT_MD5_HASH_HANDLE", (Throwable)e, (Object[])new Object[0]);
                sftp.sendStatusMessage(requestId, 4, e.getMessage());
                return;
            }
        }
    }

    protected abstract byte[] getFileHandle(ByteArrayReader var1, SftpSubsystem var2) throws IOException, PermissionDeniedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendReply(int requestId, String algorithm, List<byte[]> hashValue, SftpSubsystem sftp) throws IOException {
        try (Packet reply = new Packet();){
            reply.write(201);
            reply.writeInt(requestId);
            reply.writeString(algorithm);
            for (byte[] hash : hashValue) {
                reply.write(hash);
            }
            sftp.sendMessage(reply);
        }
    }

    private String selectAlgorithm(String algorithms) {
        String[] tmp;
        for (String alg : tmp = algorithms.split(",")) {
            String result = (String)ALGOS.get(alg);
            if (!Objects.nonNull(result)) continue;
            return alg;
        }
        return null;
    }
}

